/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.database;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Database {
    private static final YamlConfiguration config = HoloMobHealth.getConfiguration();
    private static final String table = "HoloMobHealth_USER_PERFERENCES";
    private static final Object syncdb = new Object();
    public static boolean isMYSQL = false;
    private static Connection connection;
    private static String host;
    private static String database;
    private static String username;
    private static String password;
    private static int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup() {
        String type = config.getString("Database.Type");
        isMYSQL = type.equalsIgnoreCase("MYSQL");
        Object object = syncdb;
        synchronized (object) {
            if (isMYSQL) {
                Database.mysqlSetup(true);
                Database.createTable();
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                Database.sqliteSetup(true);
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void open() {
        if (isMYSQL) {
            Database.mysqlSetup(false);
        } else {
            Database.sqliteSetup(false);
        }
    }

    public static void mysqlSetup(boolean echo) {
        host = config.getString("Database.MYSQL.Host");
        port = config.getInt("Database.MYSQL.Port");
        database = config.getString("Database.MYSQL.Database");
        username = config.getString("Database.MYSQL.Username");
        password = config.getString("Database.MYSQL.Password");
        try {
            if (Database.getConnection() != null && !Database.getConnection().isClosed()) {
                return;
            }
            Class.forName("com.mysql.jdbc.Driver");
            Database.setConnection(DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database, username, password));
            if (echo) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[HoloMobHealth] MYSQL CONNECTED");
            }
        }
        catch (SQLException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] MYSQL Failed to connect! (SQLException)");
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] MYSQL Failed to connect! (ClassNotFoundException)");
            e.printStackTrace();
        }
    }

    public static void sqliteSetup(boolean echo) {
        try {
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection("jdbc:sqlite:plugins/HoloMobHealth/database.db");
            if (echo) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[HoloMobHealth] Opened Sqlite database successfully");
            }
            Statement stmt = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS HoloMobHealth_USER_PERFERENCES (UUID TEXT PRIMARY KEY, NAME TEXT NOT NULL, DISPLAY BOOLEAN);";
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to connect to sqlite database!!!");
            e.printStackTrace();
            HoloMobHealth.plugin.getPluginLoader().disablePlugin(HoloMobHealth.plugin);
        }
    }

    public static Connection getConnection() {
        return connection;
    }

    public static void setConnection(Connection connection) {
        Database.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable() {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS HoloMobHealth_USER_PERFERENCES (UUID Text, NAME Text, DISPLAY BOOLEAN)");
                statement.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean playerExists(Player player) {
        return Database.playerExists(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean playerExists(UUID uuid) {
        Object object = syncdb;
        synchronized (object) {
            boolean exist = false;
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM HoloMobHealth_USER_PERFERENCES WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet results = statement.executeQuery();
                if (results.next()) {
                    exist = true;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return exist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPlayer(Player player) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement insert = Database.getConnection().prepareStatement("INSERT INTO HoloMobHealth_USER_PERFERENCES (UUID,NAME,DISPLAY) VALUES (?,?,?)");
                insert.setString(1, player.getUniqueId().toString());
                insert.setString(2, player.getName());
                insert.setBoolean(3, true);
                insert.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toggle(Player player) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            boolean newvalue = true;
            if (HoloMobHealth.playersEnabled.contains(player)) {
                newvalue = false;
                HoloMobHealth.playersEnabled.remove(player);
            } else {
                HoloMobHealth.playersEnabled.add(player);
            }
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("UPDATE HoloMobHealth_USER_PERFERENCES SET DISPLAY=? WHERE UUID=?");
                statement.setBoolean(1, newvalue);
                statement.setString(2, player.getUniqueId().toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updatePlayer(player), 10L);
            return newvalue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> getPlayerInfo(UUID uuid) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM HoloMobHealth_USER_PERFERENCES WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet results = statement.executeQuery();
                results.next();
                map.put("display", results.getBoolean("DISPLAY"));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<String, Boolean> getPlayerInfo(Player player) {
        return Database.getPlayerInfo(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlayer(Player player) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM HoloMobHealth_USER_PERFERENCES WHERE UUID=?");
                statement.setString(1, player.getUniqueId().toString());
                ResultSet results = statement.executeQuery();
                results.next();
                boolean display = results.getBoolean("DISPLAY");
                if (HoloMobHealth.playersEnabled.contains(player)) {
                    if (!display) {
                        HoloMobHealth.playersEnabled.remove(player);
                    }
                } else if (display) {
                    HoloMobHealth.playersEnabled.add(player);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updatePlayer(player), 10L);
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

