/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.holders;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.holders.HoloMobArmorStand;
import com.loohp.holomobhealth.holders.IMultilineStands;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.protocol.ArmorStandPacket;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class MultilineStands
implements IMultilineStands {
    private static final Vector SPACING = new Vector(0.0, 0.27, 0.0);
    private final List<HoloMobArmorStand> stands;
    private final Location location;
    private final Entity entity;
    private final UUID uuid;
    private final int id;
    private int offset;
    private int gctask;

    /*
     * WARNING - void declaration
     */
    public MultilineStands(Entity entity) {
        void var4_8;
        Location location = entity.getLocation().clone();
        this.offset = HoloMobHealth.armorStandYOffset;
        if (entity.getCustomName() != null) {
            for (Map.Entry<String, Integer> entry : HoloMobHealth.specialNameOffset.entrySet()) {
                if (!entity.getCustomName().matches(entry.getKey())) continue;
                this.offset += entry.getValue().intValue();
                break;
            }
        }
        for (Map.Entry<String, Integer> entry : HoloMobHealth.specialTypeOffset.entrySet()) {
            if (!EntityTypeUtils.getEntityType(entity).equals((Object)entry.getKey())) continue;
            this.offset += entry.getValue().intValue();
            break;
        }
        this.location = location.clone();
        Location standloc = location.clone();
        this.stands = new ArrayList<HoloMobArmorStand>();
        boolean bl = false;
        while (var4_8 < HoloMobHealth.displayText.size()) {
            HoloMobArmorStand stand = new HoloMobArmorStand(standloc, EntityType.ARMOR_STAND, this);
            this.stands.add(stand);
            ++var4_8;
        }
        Location location2 = entity.getLocation().add(0.0, NMS.getInstance().getEntityHeight(entity), 0.0);
        for (int i = 0; i < this.stands.size(); ++i) {
            HoloMobArmorStand stand = this.stands.get(i);
            stand.setLocation(location2.clone());
            location2.add(SPACING);
        }
        Collections.reverse(this.stands);
        this.entity = entity;
        this.uuid = entity.getUniqueId();
        this.id = entity.getEntityId();
        this.gc();
    }

    private void gc() {
        this.gctask = Bukkit.getScheduler().runTaskTimerAsynchronously(HoloMobHealth.plugin, () -> {
            if (!this.entity.isValid() || !this.entity.getUniqueId().equals(this.uuid)) {
                this.remove();
            }
        }, 0L, 15L).getTaskId();
    }

    @Override
    public HoloMobArmorStand getStand(int line) {
        return this.stands.get(line);
    }

    public List<HoloMobArmorStand> getStands() {
        return this.stands;
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public void setLocation(Location location) {
        Location base = this.entity.getLocation().add(0.0, NMS.getInstance().getEntityHeight(this.entity), 0.0);
        for (int i = this.stands.size() - 1; i >= 0; --i) {
            HoloMobArmorStand stand = this.stands.get(i);
            stand.setLocation(base.clone());
            base.add(SPACING);
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public int getEntityId() {
        return this.id;
    }

    @Override
    public void remove() {
        for (HoloMobArmorStand stand : this.stands) {
            Bukkit.getScheduler().runTask(HoloMobHealth.plugin, () -> ArmorStandPacket.removeArmorStand(Bukkit.getOnlinePlayers(), stand, true, false));
        }
        Bukkit.getScheduler().cancelTask(this.gctask);
    }
}

