/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseYamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Comment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ReflectedYamlMapping
extends BaseYamlMapping {
    private final Object bean;

    ReflectedYamlMapping(Object bean) {
        if (bean instanceof Collection || bean.getClass().isArray()) {
            throw new IllegalArgumentException("YamlMapping can only be reflected from an Object or from a Map.");
        }
        this.bean = bean;
    }

    @Override
    public Set<YamlNode> keys() {
        LinkedHashSet<YamlNode> keys = new LinkedHashSet<YamlNode>();
        if (this.bean instanceof Map) {
            for (Object key : ((Map)this.bean).keySet()) {
                keys.add(this.objectToYamlNode(key));
            }
        } else {
            Method[] methods;
            for (Method method : methods = this.bean.getClass().getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType().equals(Void.TYPE)) continue;
                keys.add(new MethodKey(method));
            }
        }
        return keys;
    }

    @Override
    public YamlNode value(YamlNode key) {
        YamlNode node = null;
        if (this.bean instanceof Map) {
            for (Object mapKey : ((Map)this.bean).keySet()) {
                if (!key.equals(this.objectToYamlNode(mapKey))) continue;
                node = this.objectToYamlNode(((Map)this.bean).get(mapKey));
                break;
            }
        } else if (key instanceof Scalar) {
            node = this.objectToYamlNode(this.invokeMethod(((Scalar)key).value()));
        } else {
            throw new IllegalArgumentException("Reflected YamlMapping can only have string keys representing the method names of the reflected Java Bean!");
        }
        return node;
    }

    @Override
    public Comment comment() {
        return new Comment(){

            @Override
            public YamlNode yamlNode() {
                return ReflectedYamlMapping.this;
            }

            @Override
            public String value() {
                return "";
            }
        };
    }

    private Object invokeMethod(String keyName) {
        Method[] methods;
        Object value = null;
        for (Method method : methods = this.bean.getClass().getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType().equals(Void.TYPE) || !method.getName().equalsIgnoreCase(keyName) && !method.getName().equalsIgnoreCase("get" + keyName)) continue;
            try {
                value = method.invoke(this.bean, new Object[0]);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalStateException(ite);
            }
        }
        return value;
    }

    private YamlNode objectToYamlNode(Object value) {
        return Yaml.createYamlDump(value).dump();
    }

    static class MethodKey
    extends BaseScalar {
        private final Method method;

        MethodKey(Method method) {
            this.method = method;
        }

        @Override
        public String value() {
            String keyName;
            String methodName = this.method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3) {
                String first = String.valueOf(this.method.getName().substring(3).charAt(0));
                keyName = first.toLowerCase();
                if (methodName.substring(3).length() > 1) {
                    keyName = keyName + methodName.substring(4);
                }
            } else {
                keyName = this.method.getName();
            }
            return keyName;
        }

        @Override
        public Comment comment() {
            return new Comment(){

                @Override
                public YamlNode yamlNode() {
                    return this;
                }

                @Override
                public String value() {
                    return "";
                }
            };
        }
    }
}

