/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.holomobhealth.nms.NMSWrapper;
import com.loohp.holomobhealth.utils.BoundingBox;
import com.loohp.holomobhealth.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class V1_21_2
extends NMSWrapper {
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field dataWatcherNoGravityField;
    private Method worldServerEntityLookup;

    public V1_21_2() {
        try {
            this.entityCountField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, AtomicInteger.class, "ENTITY_COUNTER", "c");
            this.dataWatcherByteField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, "DATA_SHARED_FLAGS_ID", "am");
            this.dataWatcherCustomNameField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, "DATA_CUSTOM_NAME", "aO");
            this.dataWatcherCustomNameVisibleField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, "DATA_CUSTOM_NAME_VISIBLE", "aP");
            this.dataWatcherSilentField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, "DATA_SILENT", "aQ");
            this.dataWatcherNoGravityField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, "DATA_NO_GRAVITY", "aR");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            this.worldServerEntityLookup = WorldServer.class.getMethod("moonrise$getEntityLookup", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketContainer[]{V1_21_2.p(new PacketPlayOutEntityDestroy(entityIds))};
    }

    @Override
    public PacketContainer createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        return V1_21_2.p(new PacketPlayOutEntityMetadata(entityId, dataWatchers));
    }

    @Override
    public PacketContainer createEntityTeleportPacket(int entityId, Location location) {
        return V1_21_2.p(new PacketPlayOutEntityTeleport(entityId, new PositionMoveRotation(new Vec3D(location.getX(), location.getY(), location.getZ()), Vec3D.c, location.getYaw(), location.getPitch()), Collections.emptySet(), false));
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        org.bukkit.util.BoundingBox box = entity.getBoundingBox();
        return BoundingBox.of(box.getMin(), box.getMax());
    }

    @Override
    public String getEntityTranslationKey(Entity entity) {
        return CraftEntityType.bukkitToMinecraft((EntityType)entity.getType()).g();
    }

    @Override
    public Component getEntityCustomName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().al();
        return GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Future<Integer> getNextEntityId() {
        try {
            this.entityCountField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)this.entityCountField.get(null);
            return CompletableFuture.completedFuture(counter.incrementAndGet());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        return entity.getPassengers();
    }

    @Override
    public int getTropicalFishVariant(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityTropicalFish fish = (EntityTropicalFish)nmsEntity;
        return fish.gz();
    }

    @Override
    public UUID getEntityUUIDFromID(World world, int id) {
        try {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            LevelEntityGetter levelEntityGetter = this.worldServerEntityLookup == null ? worldServer.O.d() : (LevelEntityGetter)this.worldServerEntityLookup.invoke((Object)worldServer, new Object[0]);
            net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)levelEntityGetter.a(id);
            return entity == null ? null : entity.cG();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Entity getEntityFromUUID(UUID uuid) {
        return Bukkit.getEntity((UUID)uuid);
    }

    @Override
    public double getEntityHeight(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.cR();
        double minY = axisAlignedBB.b;
        double maxY = axisAlignedBB.e;
        return maxY - minY;
    }

    @Override
    public double getEntityWidth(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.cR();
        double minX = axisAlignedBB.a;
        double maxX = axisAlignedBB.d;
        return maxX - minX;
    }

    @Override
    public PacketContainer createUpdateEntityPacket(Entity entity) {
        try {
            ArrayList<DataWatcher.c> dataWatcher = new ArrayList<DataWatcher.c>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.au();
            Optional name = (Optional)watcher.a((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.a((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), (Object)name));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createUpdateEntityMetadataPacket(Entity entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.c> dataWatcher = new ArrayList<DataWatcher.c>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<?> buildDataWatchers(IHoloMobArmorStand entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.c> dataWatcher = new ArrayList<DataWatcher.c>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherByteField.get(null)), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherNoGravityField.get(null)), (Object)true));
            byte standbitmask = 17;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityArmorStand.bJ, (Object)standbitmask));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        EntityTypes type = CraftEntityType.bukkitToMinecraft((EntityType)entity.getType());
        Vec3D velocity = Vec3D.c;
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, 0, velocity, (double)entity.getLocation().getYaw());
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet2 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        return new PacketContainer[]{V1_21_2.p(packet1), packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet1 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        PacketContainer packet2 = this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation());
        return new PacketContainer[]{packet1, packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return new PacketContainer[]{this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation())};
    }

    @Override
    public PacketContainer[] createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, Location location, Vector velocity, boolean gravity) {
        try {
            EntityTypes type = EntityTypes.f;
            Vec3D vec = new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ());
            PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entityId, uuid, location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, type, 0, vec, 0.0);
            ArrayList<DataWatcher.c> dataWatcher = new ArrayList<DataWatcher.c>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherByteField.get(null)), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)true));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherSilentField.get(null)), (Object)true));
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherNoGravityField.get(null)), (Object)(!gravity ? 1 : 0)));
            byte standBitmask = 25;
            dataWatcher.add(DataWatcher.c.a((DataWatcherObject)EntityArmorStand.bJ, (Object)standBitmask));
            PacketContainer packet2 = this.createEntityMetadataPacket(entityId, dataWatcher);
            return new PacketContainer[]{V1_21_2.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.c<?>> readDataWatchersFromMetadataPacket(PacketContainer packet) {
        PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
        return nmsPacket.e();
    }

    private <T> void addOrReplaceDataWatcher(List<DataWatcher.c<?>> dataWatcher, DataWatcher.c<T> newWatcher) {
        for (int i = 0; i < dataWatcher.size(); ++i) {
            DataWatcher.c<?> watcher = dataWatcher.get(i);
            if (newWatcher.a() != watcher.a() || !newWatcher.b().equals((Object)watcher.b())) continue;
            dataWatcher.set(i, newWatcher);
            return;
        }
        dataWatcher.add(newWatcher);
    }

    @Override
    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        try {
            List<DataWatcher.c<?>> dataWatcher = dataWatchers;
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            this.addOrReplaceDataWatcher(dataWatcher, DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            this.addOrReplaceDataWatcher(dataWatcher, DataWatcher.c.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createModifiedMetadataPacket(PacketContainer packet, List<?> dataWatchers) {
        PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
        return this.createEntityMetadataPacket(nmsPacket.b(), dataWatchers);
    }
}

