/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.holders;

import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.holders.MultilineStands;
import com.loohp.holomobhealth.nms.NMSWrapper;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;

public class HoloMobArmorStand
implements IHoloMobArmorStand {
    private final UUID uuid;
    private final EntityType type;
    private final transient Future<Integer> entityIdFuture = NMSWrapper.getInstance().getNextEntityId();
    private final MultilineStands host;
    private int id = Integer.MIN_VALUE;
    private Location location;

    public HoloMobArmorStand(Location location, EntityType type, MultilineStands host) {
        this.uuid = UUID.randomUUID();
        this.location = location.clone();
        this.type = type;
        this.host = host;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    public MultilineStands getHost() {
        return this.host;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.teleport(this.location.getWorld(), this.location.getX(), this.location.getY(), this.location.getZ(), yaw, pitch);
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    public void teleport(Location location) {
        this.location = location.clone();
    }

    @Override
    public void teleport(World world, double x, double y, double z) {
        this.location = new Location(world, x, y, z, this.location.getYaw(), this.location.getPitch());
    }

    @Override
    public void teleport(World world, double x, double y, double z, float yaw, float pitch) {
        this.location = new Location(world, x, y, z, yaw, pitch);
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public void setLocation(Location location) {
        this.location = location.clone();
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public final int getEntityId() {
        if (this.id != Integer.MIN_VALUE) {
            return this.id;
        }
        try {
            this.id = this.entityIdFuture.get();
            return this.id;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

