/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.listeners;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.database.Database;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class Events
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Scheduler.runTaskAsynchronously(HoloMobHealth.plugin, () -> {
            if (!Database.playerExists(player)) {
                Database.createPlayer(player);
            }
            Database.loadPlayer(player);
        });
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        HoloMobHealth.playersEnabled.remove(player);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        Scheduler.runTaskLater(HoloMobHealth.plugin, () -> Events.lambda$onCreatureSpawn$1((Entity)entity), 5L);
    }

    @EventHandler
    public void onAttack(EntityDamageEvent event) {
        if (!HoloMobHealth.useAlterHealth) {
            return;
        }
        if (HoloMobHealth.disabledWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (HoloMobHealth.altOnlyPlayer) {
            return;
        }
        Entity entity = event.getEntity();
        UUID uuid = entity.getUniqueId();
        HoloMobHealth.altShowHealth.put(uuid, System.currentTimeMillis() + (long)(HoloMobHealth.altHealthDisplayTime * 1000));
        EntityMetadata.updateEntity(entity.getWorld().getPlayers(), entity);
        Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
            Long timeout = HoloMobHealth.altShowHealth.get(uuid);
            if (timeout != null && System.currentTimeMillis() > timeout) {
                HoloMobHealth.altShowHealth.remove(uuid);
                EntityMetadata.updateEntity(entity.getWorld().getPlayers(), entity);
            }
        }, HoloMobHealth.altHealthDisplayTime * 20 + 5);
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        if (!HoloMobHealth.useAlterHealth) {
            return;
        }
        if (HoloMobHealth.disabledWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!HoloMobHealth.altOnlyPlayer) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.PLAYER)) {
            if (event.getDamager() instanceof Projectile) {
                Projectile projectile = (Projectile)event.getDamager();
                if (projectile.getShooter() == null) {
                    return;
                }
                if (!(projectile.getShooter() instanceof Player)) {
                    return;
                }
            } else {
                return;
            }
        }
        Entity entity = event.getEntity();
        UUID uuid = entity.getUniqueId();
        HoloMobHealth.altShowHealth.put(uuid, System.currentTimeMillis() + (long)(HoloMobHealth.altHealthDisplayTime * 1000));
        EntityMetadata.updateEntity(entity.getWorld().getPlayers(), entity);
        Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
            Long timeout = HoloMobHealth.altShowHealth.get(uuid);
            if (timeout != null && System.currentTimeMillis() > timeout) {
                HoloMobHealth.altShowHealth.remove(uuid);
                EntityMetadata.updateEntity(entity.getWorld().getPlayers(), entity);
            }
        }, HoloMobHealth.altHealthDisplayTime * 20 + 5);
    }

    private static /* synthetic */ void lambda$onCreatureSpawn$1(Entity entity) {
        EntityMetadata.updateEntity(entity.getWorld().getPlayers(), entity);
    }
}

