/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.modules;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class RangeModule {
    private static final Queue<Player> updateQueue = new LinkedList<Player>();
    protected static int playersPerTick = 1;
    protected static int rate = 20;
    protected static double distance = 15.0;
    private static Map<Player, List<Entity>> upcomming = new HashMap<Player, List<Entity>>();
    private static Map<Player, List<Entity>> current = new HashMap<Player, List<Entity>>();

    public static void reloadNumbers() {
        rate = HoloMobHealth.getConfiguration().getInt("Options.Range.UpdateRate");
        distance = HoloMobHealth.getConfiguration().getDouble("Options.Range.Distance");
    }

    public static boolean isEntityInRangeOfPlayer(Player player, Entity entity) {
        List<Entity> nearby = current.get(player);
        return nearby != null && nearby.contains(entity);
    }

    public static void run() {
        for (World world : Bukkit.getWorlds()) {
            if (HoloMobHealth.disabledWorlds.contains(world.getName())) continue;
            updateQueue.addAll(world.getPlayers());
        }
        playersPerTick = updateQueue.size() / rate;
        Scheduler.runTaskLater(HoloMobHealth.plugin, () -> RangeModule.getEntitiesInRange(), 1L);
    }

    private static void getEntitiesInRange() {
        int count = 0;
        while (!updateQueue.isEmpty()) {
            Player player = updateQueue.poll();
            upcomming.put(player, player.getNearbyEntities(distance, distance, distance));
            if (++count < playersPerTick) continue;
            break;
        }
        if (updateQueue.isEmpty()) {
            Scheduler.runTaskAsynchronously(HoloMobHealth.plugin, () -> RangeModule.compareEntities());
        } else {
            Scheduler.runTaskLater(HoloMobHealth.plugin, () -> RangeModule.getEntitiesInRange(), 1L);
        }
    }

    private static void compareEntities() {
        for (Map.Entry<Player, List<Entity>> entry : upcomming.entrySet()) {
            Player player = entry.getKey();
            List<Entity> last = current.get(player);
            if (last == null) {
                ArrayList now1 = new ArrayList(entry.getValue());
                Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
                    for (Entity entity : now1) {
                        EntityMetadata.updateEntity(player, entity);
                    }
                }, 1L);
                continue;
            }
            ArrayList<Entity> last1 = new ArrayList<Entity>(last);
            ArrayList now1 = new ArrayList(entry.getValue());
            ArrayList now2 = new ArrayList(entry.getValue());
            now1.removeAll(last1);
            Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
                for (Entity entity : now1) {
                    EntityMetadata.updateEntity(player, entity);
                }
            }, 1L);
            last1.removeAll(now2);
            Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
                for (Entity entity : last1) {
                    EntityMetadata.updateEntity(player, entity);
                }
            }, 1L);
        }
        Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
            current = upcomming;
            upcomming = new HashMap<Player, List<Entity>>();
            Scheduler.runTaskLater(HoloMobHealth.plugin, () -> RangeModule.run(), 1L);
        }, 1L);
    }
}

