/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.holders.DataWatcherField;
import com.loohp.holomobhealth.holders.DataWatcherFieldType;
import com.loohp.holomobhealth.holders.DataWatcherFields;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.nms.NMSWrapper;
import com.loohp.holomobhealth.utils.BoundingBox;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.DataWatcher;
import net.minecraft.server.v1_8_R3.EntityTypes;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class V1_8_4
extends NMSWrapper {
    private final Field[] entityMetadataPacketFields;
    private final Field entityCountField;
    private final Field dataWatcherTypeMapField;
    private final int dataWatcherByteIndex;
    private final int dataWatcherCustomNameIndex;
    private final int dataWatcherCustomNameVisibleIndex;
    private final int dataWatcherArmorStandByteIndex;
    private final Field[] spawnEntityLivingPacketFields;

    public V1_8_4() {
        try {
            this.entityMetadataPacketFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.entityCountField = net.minecraft.server.v1_8_R3.Entity.class.getDeclaredField("entityCount");
            this.dataWatcherTypeMapField = DataWatcher.class.getDeclaredField("c");
            this.dataWatcherByteIndex = 0;
            this.dataWatcherCustomNameIndex = 2;
            this.dataWatcherCustomNameVisibleIndex = 3;
            this.dataWatcherArmorStandByteIndex = 10;
            this.spawnEntityLivingPacketFields = PacketPlayOutSpawnEntityLiving.class.getDeclaredFields();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketContainer[]{V1_8_4.p(new PacketPlayOutEntityDestroy(entityIds))};
    }

    @Override
    public PacketContainer createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            this.entityMetadataPacketFields[0].setAccessible(true);
            this.entityMetadataPacketFields[0].setInt(packet, entityId);
            this.entityMetadataPacketFields[1].setAccessible(true);
            this.entityMetadataPacketFields[1].set(packet, dataWatchers);
            return V1_8_4.p(packet);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createEntityTeleportPacket(int entityId, Location location) {
        return V1_8_4.p(new PacketPlayOutEntityTeleport(entityId, MathHelper.floor((double)(location.getX() * 32.0)), MathHelper.floor((double)(location.getY() * 32.0)), MathHelper.floor((double)(location.getZ() * 32.0)), (byte)(location.getYaw() * 256.0f / 360.0f), (byte)(location.getPitch() * 256.0f / 360.0f), false));
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        return new BoundingBox(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c, axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f);
    }

    @Override
    public String getEntityTranslationKey(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return "entity." + EntityTypes.b((net.minecraft.server.v1_8_R3.Entity)nmsEntity) + ".name";
    }

    @Override
    public Component getEntityCustomName(Entity entity) {
        String customName = ((CraftEntity)entity).getHandle().getCustomName();
        return LegacyComponentSerializer.legacySection().deserialize(customName);
    }

    @Override
    public Future<Integer> getNextEntityId() {
        this.entityCountField.setAccessible(true);
        return Bukkit.getScheduler().callSyncMethod(V1_8_4.getPlugin(), () -> {
            try {
                int counter = this.entityCountField.getInt(null);
                this.entityCountField.setInt(null, counter + 1);
                return counter;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        Entity passenger = entity.getPassenger();
        return passenger == null ? Collections.emptyList() : Collections.singletonList(passenger);
    }

    @Override
    public int getTropicalFishVariant(Entity entity) {
        return -1;
    }

    @Override
    public UUID getEntityUUIDFromID(World world, int id) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_8_R3.Entity entity = worldServer.a(id);
        return entity == null ? null : entity.getUniqueID();
    }

    @Override
    public Entity getEntityFromUUID(UUID uuid) {
        for (World world : Bukkit.getWorlds()) {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            net.minecraft.server.v1_8_R3.Entity entity = worldServer.getEntity(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public double getEntityHeight(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        double minY = axisAlignedBB.b;
        double maxY = axisAlignedBB.e;
        return maxY - minY;
    }

    @Override
    public double getEntityWidth(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        double minX = axisAlignedBB.a;
        double maxX = axisAlignedBB.d;
        return maxX - minX;
    }

    @Override
    public PacketContainer createUpdateEntityPacket(Entity entity) {
        try {
            ArrayList<DataWatcher.WatchableObject> dataWatcher = new ArrayList<DataWatcher.WatchableObject>();
            this.dataWatcherTypeMapField.setAccessible(true);
            Map typeMap = (Map)this.dataWatcherTypeMapField.get(null);
            net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.getDataWatcher();
            String name = watcher.getString(this.dataWatcherCustomNameIndex);
            Byte visible = watcher.getByte(this.dataWatcherCustomNameVisibleIndex);
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(String.class)).intValue(), this.dataWatcherCustomNameIndex, (Object)name));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherCustomNameVisibleIndex, (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createUpdateEntityMetadataPacket(Entity entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.WatchableObject> dataWatcher = new ArrayList<DataWatcher.WatchableObject>();
            this.dataWatcherTypeMapField.setAccessible(true);
            Map typeMap = (Map)this.dataWatcherTypeMapField.get(null);
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_8_4.t(entityNameComponent));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(String.class)).intValue(), this.dataWatcherCustomNameIndex, (Object)name));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherCustomNameVisibleIndex, (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<?> buildDataWatchers(IHoloMobArmorStand entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.WatchableObject> dataWatcher = new ArrayList<DataWatcher.WatchableObject>();
            this.dataWatcherTypeMapField.setAccessible(true);
            Map typeMap = (Map)this.dataWatcherTypeMapField.get(null);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherByteIndex, (Object)bitmask));
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_8_4.t(entityNameComponent));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(String.class)).intValue(), this.dataWatcherCustomNameIndex, (Object)name));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherCustomNameVisibleIndex, (Object)visible));
            byte standbitmask = 17;
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherArmorStandByteIndex, (Object)standbitmask));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        try {
            PacketPlayOutSpawnEntityLiving packet1 = new PacketPlayOutSpawnEntityLiving();
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[12].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entity.getEntityId());
            this.spawnEntityLivingPacketFields[1].setInt(packet1, entity.getType().getTypeId());
            this.spawnEntityLivingPacketFields[2].setDouble(packet1, entity.getLocation().getX());
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, entity.getLocation().getY());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, entity.getLocation().getZ());
            this.spawnEntityLivingPacketFields[5].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[6].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[7].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[8].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[11].set(packet1, new DataWatcher(null));
            this.spawnEntityLivingPacketFields[12].set(packet1, Collections.emptyList());
            List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
            PacketContainer packet2 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
            return new PacketContainer[]{V1_8_4.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet1 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        PacketContainer packet2 = this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation());
        return new PacketContainer[]{packet1, packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return new PacketContainer[]{this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation())};
    }

    @Override
    public PacketContainer[] createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, Location location, Vector velocity, boolean gravity) {
        try {
            PacketPlayOutSpawnEntityLiving packet1 = new PacketPlayOutSpawnEntityLiving();
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[12].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entityId);
            this.spawnEntityLivingPacketFields[1].setInt(packet1, EntityType.ARMOR_STAND.getTypeId());
            this.spawnEntityLivingPacketFields[2].setDouble(packet1, location.getX());
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, location.getY());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, location.getZ());
            this.spawnEntityLivingPacketFields[5].setInt(packet1, (int)(MathHelper.a((double)velocity.getX(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[6].setInt(packet1, (int)(MathHelper.a((double)velocity.getY(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[7].setInt(packet1, (int)(MathHelper.a((double)velocity.getZ(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[8].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[11].set(packet1, new DataWatcher(null));
            this.spawnEntityLivingPacketFields[12].set(packet1, Collections.emptyList());
            ArrayList<DataWatcher.WatchableObject> dataWatcher = new ArrayList<DataWatcher.WatchableObject>();
            this.dataWatcherTypeMapField.setAccessible(true);
            Map typeMap = (Map)this.dataWatcherTypeMapField.get(null);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherByteIndex, (Object)bitmask));
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_8_4.t(entityNameComponent));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(String.class)).intValue(), this.dataWatcherCustomNameIndex, (Object)name));
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherCustomNameVisibleIndex, (Object)1));
            byte standBitmask = 25;
            dataWatcher.add(new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherArmorStandByteIndex, (Object)standBitmask));
            PacketContainer packet2 = this.createEntityMetadataPacket(entityId, dataWatcher);
            return new PacketContainer[]{V1_8_4.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.WatchableObject> readDataWatchersFromMetadataPacket(PacketContainer packet) {
        try {
            PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
            this.entityMetadataPacketFields[1].setAccessible(true);
            return (List)this.entityMetadataPacketFields[1].get(nmsPacket);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void addOrReplaceDataWatcher(List<DataWatcher.WatchableObject> dataWatcher, DataWatcher.WatchableObject newWatcher) {
        for (int i = 0; i < dataWatcher.size(); ++i) {
            DataWatcher.WatchableObject watcher = dataWatcher.get(i);
            if (newWatcher.a() != watcher.a() || newWatcher.c() != watcher.c()) continue;
            dataWatcher.set(i, newWatcher);
            return;
        }
        dataWatcher.add(newWatcher);
    }

    @Override
    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        try {
            List<DataWatcher.WatchableObject> dataWatcher = dataWatchers;
            this.dataWatcherTypeMapField.setAccessible(true);
            Map typeMap = (Map)this.dataWatcherTypeMapField.get(null);
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_8_4.t(entityNameComponent));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.WatchableObject(((Integer)typeMap.get(String.class)).intValue(), this.dataWatcherCustomNameIndex, (Object)name));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.WatchableObject(((Integer)typeMap.get(Byte.class)).intValue(), this.dataWatcherCustomNameVisibleIndex, (Object)1));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createModifiedMetadataPacket(PacketContainer packet, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
            this.entityMetadataPacketFields[0].setAccessible(true);
            int id = this.entityMetadataPacketFields[0].getInt(nmsPacket);
            return this.createEntityMetadataPacket(id, dataWatchers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataWatcherFields getDataWatcherFields() {
        return new DataWatcherFields(new DataWatcherField(this.dataWatcherByteIndex, DataWatcherFieldType.BYTE), new DataWatcherField(this.dataWatcherCustomNameIndex, DataWatcherFieldType.STRING), new DataWatcherField(this.dataWatcherCustomNameVisibleIndex, DataWatcherFieldType.BYTE), null, null, new DataWatcherField(this.dataWatcherArmorStandByteIndex, DataWatcherFieldType.BYTE));
    }
}

