/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.holders.DataWatcherField;
import com.loohp.holomobhealth.holders.DataWatcherFieldType;
import com.loohp.holomobhealth.holders.DataWatcherFields;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.nms.NMSWrapper;
import com.loohp.holomobhealth.utils.BoundingBox;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.server.v1_9_R2.AxisAlignedBB;
import net.minecraft.server.v1_9_R2.DataWatcher;
import net.minecraft.server.v1_9_R2.DataWatcherObject;
import net.minecraft.server.v1_9_R2.EntityArmorStand;
import net.minecraft.server.v1_9_R2.EntityTypes;
import net.minecraft.server.v1_9_R2.MathHelper;
import net.minecraft.server.v1_9_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_9_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_9_R2.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_9_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_9_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_9_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class V1_9_4
extends NMSWrapper {
    private final Field[] entityMetadataPacketFields;
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field[] spawnEntityLivingPacketFields;
    private final Field[] entityTeleportPacketFields;

    public V1_9_4() {
        try {
            this.entityMetadataPacketFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.entityCountField = net.minecraft.server.v1_9_R2.Entity.class.getDeclaredField("entityCount");
            this.dataWatcherByteField = net.minecraft.server.v1_9_R2.Entity.class.getDeclaredField("ay");
            this.dataWatcherCustomNameField = net.minecraft.server.v1_9_R2.Entity.class.getDeclaredField("aA");
            this.dataWatcherCustomNameVisibleField = net.minecraft.server.v1_9_R2.Entity.class.getDeclaredField("aB");
            this.dataWatcherSilentField = net.minecraft.server.v1_9_R2.Entity.class.getDeclaredField("aC");
            this.spawnEntityLivingPacketFields = PacketPlayOutSpawnEntityLiving.class.getDeclaredFields();
            this.entityTeleportPacketFields = PacketPlayOutEntityTeleport.class.getDeclaredFields();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketContainer[]{V1_9_4.p(new PacketPlayOutEntityDestroy(entityIds))};
    }

    @Override
    public PacketContainer createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            this.entityMetadataPacketFields[0].setAccessible(true);
            this.entityMetadataPacketFields[0].setInt(packet, entityId);
            this.entityMetadataPacketFields[1].setAccessible(true);
            this.entityMetadataPacketFields[1].set(packet, dataWatchers);
            return V1_9_4.p(packet);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createEntityTeleportPacket(int entityId, Location location) {
        try {
            PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport();
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet, entityId);
            this.entityTeleportPacketFields[1].setDouble(packet, location.getX());
            this.entityTeleportPacketFields[2].setDouble(packet, location.getY());
            this.entityTeleportPacketFields[3].setDouble(packet, location.getZ());
            this.entityTeleportPacketFields[4].setByte(packet, (byte)(location.getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet, (byte)(location.getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet, false);
            return V1_9_4.p(packet);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        net.minecraft.server.v1_9_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        return new BoundingBox(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c, axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f);
    }

    @Override
    public String getEntityTranslationKey(Entity entity) {
        net.minecraft.server.v1_9_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return "entity." + EntityTypes.b((net.minecraft.server.v1_9_R2.Entity)nmsEntity) + ".name";
    }

    @Override
    public Component getEntityCustomName(Entity entity) {
        String customName = ((CraftEntity)entity).getHandle().getCustomName();
        return LegacyComponentSerializer.legacySection().deserialize(customName);
    }

    @Override
    public Future<Integer> getNextEntityId() {
        this.entityCountField.setAccessible(true);
        return Bukkit.getScheduler().callSyncMethod(V1_9_4.getPlugin(), () -> {
            try {
                int counter = this.entityCountField.getInt(null);
                this.entityCountField.setInt(null, counter + 1);
                return counter;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        return ((CraftEntity)entity).getHandle().passengers.stream().map(e -> e.getBukkitEntity()).collect(Collectors.toList());
    }

    @Override
    public int getTropicalFishVariant(Entity entity) {
        return -1;
    }

    @Override
    public UUID getEntityUUIDFromID(World world, int id) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_9_R2.Entity entity = worldServer.getEntity(id);
        return entity == null ? null : entity.getUniqueID();
    }

    @Override
    public Entity getEntityFromUUID(UUID uuid) {
        for (World world : Bukkit.getWorlds()) {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            net.minecraft.server.v1_9_R2.Entity entity = worldServer.getEntity(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public double getEntityHeight(Entity entity) {
        net.minecraft.server.v1_9_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        double minY = axisAlignedBB.b;
        double maxY = axisAlignedBB.e;
        return maxY - minY;
    }

    @Override
    public double getEntityWidth(Entity entity) {
        net.minecraft.server.v1_9_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        double minX = axisAlignedBB.a;
        double maxX = axisAlignedBB.d;
        return maxX - minX;
    }

    @Override
    public PacketContainer createUpdateEntityPacket(Entity entity) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.server.v1_9_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.getDataWatcher();
            String name = (String)watcher.get((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.get((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createUpdateEntityMetadataPacket(Entity entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_9_4.t(entityNameComponent));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<?> buildDataWatchers(IHoloMobArmorStand entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_9_4.t(entityNameComponent));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            byte standbitmask = 17;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.a, (Object)standbitmask));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        try {
            PacketPlayOutSpawnEntityLiving packet1 = new PacketPlayOutSpawnEntityLiving();
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[12].setAccessible(true);
            this.spawnEntityLivingPacketFields[13].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entity.getEntityId());
            this.spawnEntityLivingPacketFields[1].set(packet1, entity.getUniqueId());
            this.spawnEntityLivingPacketFields[2].setInt(packet1, entity.getType().getTypeId());
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, entity.getLocation().getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, entity.getLocation().getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, entity.getLocation().getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[7].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[8].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[12].set(packet1, new DataWatcher(null));
            this.spawnEntityLivingPacketFields[13].set(packet1, Collections.emptyList());
            List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
            PacketContainer packet2 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
            return new PacketContainer[]{V1_9_4.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet1 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        PacketContainer packet2 = this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation());
        return new PacketContainer[]{packet1, packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return new PacketContainer[]{this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation())};
    }

    @Override
    public PacketContainer[] createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, Location location, Vector velocity, boolean gravity) {
        try {
            PacketPlayOutSpawnEntityLiving packet1 = new PacketPlayOutSpawnEntityLiving();
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[12].setAccessible(true);
            this.spawnEntityLivingPacketFields[13].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entityId);
            this.spawnEntityLivingPacketFields[1].set(packet1, uuid);
            this.spawnEntityLivingPacketFields[2].setInt(packet1, EntityType.ARMOR_STAND.getTypeId());
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, location.getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, location.getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, location.getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, (int)(MathHelper.a((double)velocity.getX(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[7].setInt(packet1, (int)(MathHelper.a((double)velocity.getY(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[8].setInt(packet1, (int)(MathHelper.a((double)velocity.getZ(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[12].set(packet1, new DataWatcher(null));
            this.spawnEntityLivingPacketFields[13].set(packet1, Collections.emptyList());
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_9_4.t(entityNameComponent));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)true));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherSilentField.get(null), (Object)true));
            byte standBitmask = 25;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.a, (Object)standBitmask));
            PacketContainer packet2 = this.createEntityMetadataPacket(entityId, dataWatcher);
            return new PacketContainer[]{V1_9_4.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> readDataWatchersFromMetadataPacket(PacketContainer packet) {
        try {
            PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
            this.entityMetadataPacketFields[1].setAccessible(true);
            return (List)this.entityMetadataPacketFields[1].get(nmsPacket);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void addOrReplaceDataWatcher(List<DataWatcher.Item<?>> dataWatcher, DataWatcher.Item<T> newWatcher) {
        for (int i = 0; i < dataWatcher.size(); ++i) {
            DataWatcher.Item<?> watcher = dataWatcher.get(i);
            if (newWatcher.a().a() != watcher.a().a() || !newWatcher.b().equals(watcher.b())) continue;
            dataWatcher.set(i, newWatcher);
            return;
        }
        dataWatcher.add(newWatcher);
    }

    @Override
    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        try {
            List<DataWatcher.Item<?>> dataWatcher = dataWatchers;
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            String name = entityNameComponent == null ? "" : LegacyComponentSerializer.legacySection().serialize(V1_9_4.t(entityNameComponent));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createModifiedMetadataPacket(PacketContainer packet, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
            this.entityMetadataPacketFields[0].setAccessible(true);
            int id = this.entityMetadataPacketFields[0].getInt(nmsPacket);
            return this.createEntityMetadataPacket(id, dataWatchers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataWatcherFields getDataWatcherFields() {
        try {
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            return new DataWatcherFields(new DataWatcherField(((DataWatcherObject)this.dataWatcherByteField.get(null)).a(), DataWatcherFieldType.BYTE), new DataWatcherField(((DataWatcherObject)this.dataWatcherCustomNameField.get(null)).a(), DataWatcherFieldType.STRING), new DataWatcherField(((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(((DataWatcherObject)this.dataWatcherSilentField.get(null)).a(), DataWatcherFieldType.BOOLEAN), null, new DataWatcherField(EntityArmorStand.a.a(), DataWatcherFieldType.BYTE));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

