/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.protocol;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.holders.HoloMobArmorStand;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.platform.packets.PlatformPacket;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import com.loohp.holomobhealth.utils.PacketSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ArmorStandPacket
implements Listener {
    private static final Plugin plugin = HoloMobHealth.plugin;
    public static final Set<HoloMobArmorStand> active = Collections.synchronizedSet(new LinkedHashSet());
    public static final Map<Player, Map<HoloMobArmorStand, Boolean>> playerStatus = new ConcurrentHashMap<Player, Map<HoloMobArmorStand, Boolean>>();

    public static void update() {
        Scheduler.runTaskTimerAsynchronously(plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Map<HoloMobArmorStand, Boolean> activeList = playerStatus.get(player);
                if (activeList == null) continue;
                LinkedList<Player> playerList = new LinkedList<Player>();
                playerList.add(player);
                HashSet<Entity> entitiesUpdated = new HashSet<Entity>();
                for (Map.Entry<HoloMobArmorStand, Boolean> entry : activeList.entrySet()) {
                    HoloMobArmorStand entity = entry.getKey();
                    World world = player.getWorld();
                    int range = HoloMobHealth.getUpdateRange(world);
                    range *= range;
                    if (entry.getValue().booleanValue()) {
                        if (entity.getWorld().equals((Object)world) && !(entity.getLocation().distanceSquared(player.getLocation()) > (double)(range + 1))) continue;
                        ArmorStandPacket.removeArmorStand(playerList, entity, false, true);
                        entry.setValue(false);
                        continue;
                    }
                    if (!entity.getWorld().equals((Object)world) || !(entity.getLocation().distanceSquared(player.getLocation()) <= (double)range) || !HoloMobHealth.playersEnabled.contains(player)) continue;
                    ArmorStandPacket.sendArmorStandSpawn(playerList, entity, Component.empty(), false);
                    entitiesUpdated.add(entity.getHost().getEntity());
                    entry.setValue(true);
                }
                for (Entity entity : entitiesUpdated) {
                    Scheduler.runTask(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity));
                }
            }
        }, 0L, 20L);
    }

    public static void sendArmorStandSpawnIfNotAlready(Collection<? extends Player> players, HoloMobArmorStand entity, Component component, boolean visible) {
        if (players.isEmpty()) {
            return;
        }
        ArrayList<Player> playersNotAlready = new ArrayList<Player>();
        for (Player player : players) {
            Map<HoloMobArmorStand, Boolean> list = playerStatus.get(player);
            if (list == null || list.containsKey(entity)) continue;
            playersNotAlready.add(player);
        }
        ArmorStandPacket.sendArmorStandSpawn(playersNotAlready, entity, component, visible);
    }

    public static void sendArmorStandSpawn(Collection<? extends Player> players, HoloMobArmorStand entity, Component component, boolean visible) {
        if (players.isEmpty()) {
            return;
        }
        active.add(entity);
        World world = entity.getWorld();
        ArrayList<Player> playersInRange = new ArrayList<Player>();
        for (Player player : players) {
            Map<HoloMobArmorStand, Boolean> list;
            if (!player.getWorld().equals((Object)world) || !(player.getLocation().distanceSquared(entity.getLocation()) <= (double)(HoloMobHealth.getUpdateRange(world) * HoloMobHealth.getUpdateRange(world))) || (list = playerStatus.get(player)) == null) continue;
            list.put(entity, true);
            playersInRange.add(player);
        }
        List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createArmorStandSpawnPackets(entity, component, visible);
        PacketSender.sendServerPackets(playersInRange, packets);
    }

    public static void updateArmorStand(Collection<? extends Player> players, HoloMobArmorStand entity, Component component, boolean visible) {
        if (players.isEmpty()) {
            return;
        }
        Scheduler.runTaskAsynchronously(plugin, () -> {
            World world = entity.getWorld();
            List playersInRange = players.stream().filter(each -> each.getWorld().equals((Object)world) && each.getLocation().distanceSquared(entity.getLocation()) <= (double)(HoloMobHealth.getUpdateRange(world) * HoloMobHealth.getUpdateRange(world))).collect(Collectors.toList());
            List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createUpdateArmorStandPackets(entity, component, visible);
            PacketSender.sendServerPackets(playersInRange, packets);
        });
    }

    public static void updateArmorStand(Entity host, HoloMobArmorStand entity, Component component, boolean visible) {
        Scheduler.runTaskAsynchronously(plugin, () -> {
            World world = entity.getWorld();
            List playersInRange = Bukkit.getOnlinePlayers().stream().filter(each -> each.getWorld().equals((Object)world) && each.getLocation().distanceSquared(entity.getLocation()) <= (double)(HoloMobHealth.getUpdateRange(world) * HoloMobHealth.getUpdateRange(world))).collect(Collectors.toList());
            List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createUpdateArmorStandPackets(entity, component, visible);
            Scheduler.runTask(plugin, () -> PacketSender.sendServerPackets(playersInRange, packets));
        });
    }

    public static void updateArmorStandLocation(Collection<? extends Player> players, HoloMobArmorStand entity) {
        if (players.isEmpty()) {
            return;
        }
        Scheduler.runTaskAsynchronously(plugin, () -> {
            World world = entity.getWorld();
            List playersInRange = players.stream().filter(each -> each.getWorld().equals((Object)world) && each.getLocation().distanceSquared(entity.getLocation()) <= (double)(HoloMobHealth.getUpdateRange(world) * HoloMobHealth.getUpdateRange(world))).collect(Collectors.toList());
            List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createUpdateArmorStandLocationPackets(entity);
            Scheduler.runTask(plugin, () -> PacketSender.sendServerPackets(playersInRange, packets));
        });
    }

    public static void updateArmorStandLocation(Entity host, HoloMobArmorStand entity) {
        Scheduler.runTaskAsynchronously(plugin, () -> {
            World world = entity.getWorld();
            List playersInRange = Bukkit.getOnlinePlayers().stream().filter(each -> each.getWorld().equals((Object)world) && each.getLocation().distanceSquared(entity.getLocation()) <= (double)(HoloMobHealth.getUpdateRange(world) * HoloMobHealth.getUpdateRange(world))).collect(Collectors.toList());
            List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createUpdateArmorStandLocationPackets(entity);
            Scheduler.runTask(plugin, () -> {
                for (Player player : playersInRange) {
                    for (PlatformPacket packet : packets) {
                        PacketSender.sendServerPacket(player, packet, false);
                    }
                }
            });
        });
    }

    public static void removeArmorStand(Collection<? extends Player> players, HoloMobArmorStand entity, boolean removeFromActive, boolean bypassFilter) {
        if (players.isEmpty()) {
            return;
        }
        if (removeFromActive) {
            active.remove(entity);
        }
        Scheduler.runTaskAsynchronously(plugin, () -> {
            ArrayList<Player> playersInRange;
            World world = entity.getWorld();
            if (bypassFilter) {
                playersInRange = new ArrayList<Player>();
                for (Player each : players) {
                    Map<HoloMobArmorStand, Boolean> list;
                    if (removeFromActive && (list = playerStatus.get(each)) != null) {
                        list.remove(entity);
                    }
                    playersInRange.add(each);
                }
            } else {
                playersInRange = new ArrayList();
                for (Player each : players) {
                    Map<HoloMobArmorStand, Boolean> list;
                    if (!each.getWorld().equals((Object)world) || !(each.getLocation().distanceSquared(entity.getLocation()) <= (double)(HoloMobHealth.getUpdateRange(world) * HoloMobHealth.getUpdateRange(world)))) continue;
                    if (removeFromActive && (list = playerStatus.get(each)) != null) {
                        list.remove(entity);
                    }
                    playersInRange.add(each);
                }
            }
            List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createEntityDestroyPackets(entity.getEntityId());
            Scheduler.runTask(plugin, () -> PacketSender.sendServerPackets(playersInRange, packets));
        });
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        playerStatus.put(event.getPlayer(), new ConcurrentHashMap());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        playerStatus.put(event.getPlayer(), new ConcurrentHashMap());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        playerStatus.remove(event.getPlayer());
    }
}

