/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.protocol;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.platform.packets.PlatformPacket;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.PacketSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityMetadata {
    public static void updatePlayer(Player player) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(player);
        int range = HoloMobHealth.getUpdateRange(player.getWorld());
        for (Entity entity : player.getNearbyEntities((double)range, (double)range, (double)range)) {
            EntityMetadata.updateEntity(players, entity);
        }
    }

    public static void updateEntity(Player player, Entity entity) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(player);
        EntityMetadata.updateEntity(players, entity);
    }

    public static void updateEntity(Collection<? extends Player> players, Entity entity) {
        if (!EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity))) {
            return;
        }
        if (!entity.isValid()) {
            return;
        }
        List<PlatformPacket<?>> packet = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createUpdateEntityPackets(entity);
        Scheduler.runTaskAsynchronously(HoloMobHealth.plugin, () -> {
            for (Player player : players) {
                if (!player.getWorld().equals((Object)entity.getWorld())) continue;
                try {
                    PacketSender.sendServerPackets(player, packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void sendMetadataPacket(Entity entity, Component entityNameComponent, boolean visible, List<Player> players, boolean quiet) {
        Scheduler.runTask(HoloMobHealth.plugin, () -> {
            List<PlatformPacket<?>> packet = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createUpdateEntityMetadataPackets(entity, entityNameComponent, visible);
            for (Player player : players) {
                if (!player.hasPermission("holomobhealth.use")) continue;
                PacketSender.sendServerPackets(player, packet, !quiet);
            }
        });
    }
}

