/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.utils.MythicMobsUtils;
import com.nisovin.shopkeepers.api.ShopkeepersAPI;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import de.Keyle.MyPet.api.entity.MyPet;
import de.Keyle.MyPet.api.entity.MyPetBukkitEntity;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;

public class CustomNameUtils {
    public static String getMobCustomName(Entity entity) {
        Shopkeeper keeper;
        NPC npc;
        if (HoloMobHealth.mythicHook) {
            String customName = MythicMobsUtils.getMobCustomName(entity);
            String vanillaCustomName = entity.getCustomName();
            if (HoloMobHealth.useMythicMobCustomNamesFirst) {
                return customName == null || customName.isEmpty() ? vanillaCustomName : customName;
            }
            return vanillaCustomName == null || vanillaCustomName.isEmpty() ? customName : vanillaCustomName;
        }
        if (HoloMobHealth.citizensHook && (npc = CitizensAPI.getNPCRegistry().getNPC(entity)) != null) {
            try {
                return npc.getFullName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (HoloMobHealth.shopkeepersHook && (keeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperByEntity(entity)) != null) {
            return keeper.getName();
        }
        if (HoloMobHealth.myPetHook && entity instanceof MyPetBukkitEntity) {
            MyPet mypet = ((MyPetBukkitEntity)entity).getMyPet();
            return mypet.getPetName();
        }
        String bukkitCustomName = entity.getCustomName();
        if (bukkitCustomName == null || bukkitCustomName.isEmpty()) {
            return null;
        }
        return bukkitCustomName;
    }
}

