/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class HashUtils {
    public static byte[] createSha1(File file) throws Exception {
        return HashUtils.createSha1(new FileInputStream(file));
    }

    public static byte[] createSha1(InputStream fis) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        int n = 0;
        byte[] buffer = new byte[8192];
        while (n != -1) {
            n = fis.read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        fis.close();
        return digest.digest();
    }

    public static String createSha1String(File file) throws Exception {
        byte[] b = HashUtils.createSha1(file);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static String createSha1String(InputStream fis) throws Exception {
        byte[] b = HashUtils.createSha1(fis);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

