/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.platform.packets.PlatformPacket;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PacketSender {
    private static void schedule(Runnable runnable) {
        if (HoloMobHealth.sendPacketsOnMainThread && !Bukkit.isPrimaryThread()) {
            Scheduler.runTask(HoloMobHealth.plugin, runnable);
        } else {
            runnable.run();
        }
    }

    public static void sendServerPacket(Player receiver, PlatformPacket<?> packet) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet);
            }
        });
    }

    public static void sendServerPacket(Collection<? extends Player> receivers, PlatformPacket<?> packet) {
        PacketSender.schedule(() -> {
            for (Player receiver : receivers) {
                if (!receiver.isOnline()) continue;
                HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet);
            }
        });
    }

    public static void sendServerPackets(Player receiver, Collection<? extends PlatformPacket<?>> packets) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                for (PlatformPacket packet : packets) {
                    HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet);
                }
            }
        });
    }

    public static void sendServerPackets(Collection<? extends Player> receivers, Collection<? extends PlatformPacket<?>> packets) {
        PacketSender.schedule(() -> {
            for (Player receiver : receivers) {
                if (!receiver.isOnline()) continue;
                for (PlatformPacket packet : packets) {
                    HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet);
                }
            }
        });
    }

    public static void sendServerPackets(Collection<? extends Player> receivers, Collection<? extends PlatformPacket<?>> packets, boolean filters) {
        PacketSender.schedule(() -> {
            for (Player receiver : receivers) {
                if (!receiver.isOnline()) continue;
                for (PlatformPacket packet : packets) {
                    HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet, filters);
                }
            }
        });
    }

    public static void sendServerPackets(Player receiver, Collection<? extends PlatformPacket<?>> packets, boolean filters) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                for (PlatformPacket packet : packets) {
                    HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet, filters);
                }
            }
        });
    }

    public static void sendServerPacket(Player receiver, PlatformPacket<?> packet, boolean filters) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                HoloMobHealth.protocolPlatform.sendServerPacket(receiver, packet, filters);
            }
        });
    }
}

