/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.TextReplacementConfig;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.registries.CustomPlaceholderScripts;
import com.loohp.holomobhealth.registries.DisplayTextCacher;
import com.loohp.holomobhealth.utils.ChatColorUtils;
import com.loohp.holomobhealth.utils.ComponentFont;
import com.loohp.holomobhealth.utils.CustomNameUtils;
import com.loohp.holomobhealth.utils.LanguageUtils;
import com.loohp.holomobhealth.utils.MCVersion;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ParsePlaceholders {
    public static Component parse(LivingEntity entity, String text, double healthChange) {
        return ParsePlaceholders.parse(null, entity, text, healthChange);
    }

    public static Component parse(Player player, LivingEntity entity, String text) {
        return ParsePlaceholders.parse(player, entity, text, 0.0);
    }

    public static Component parse(Player player, LivingEntity entity, String text, double healthChange) {
        String symbol;
        double health = entity.getHealth();
        double maxHealth = 0.0;
        try {
            maxHealth = !HoloMobHealth.version.isLegacy() ? entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() : entity.getMaxHealth();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        double percentage = health / maxHealth * 100.0;
        int heartScale = HoloMobHealth.dynamicScale ? (Math.ceil(maxHealth / 2.0) > (double)HoloMobHealth.heartScale ? HoloMobHealth.heartScale : (int)Math.ceil(maxHealth / 2.0)) : HoloMobHealth.heartScale;
        for (Map.Entry<String, DisplayTextCacher.HealthFormatData> entry : DisplayTextCacher.getDecimalFormatMapping().entrySet()) {
            DisplayTextCacher.HealthFormatData data = entry.getValue();
            switch (data.getType()) {
                case HEALTH: {
                    text = text.replace(entry.getKey(), String.valueOf(data.getFormatter().format(health)));
                    break;
                }
                case MAXHEALTH: {
                    text = text.replace(entry.getKey(), String.valueOf(data.getFormatter().format(maxHealth)));
                    break;
                }
                case PERCENTAGEHEALTH: {
                    text = text.replace(entry.getKey(), String.valueOf(data.getFormatter().format(percentage)));
                    break;
                }
                case INDICATOR: {
                    text = text.replace(entry.getKey(), String.valueOf(data.getFormatter().format(Math.abs(healthChange))));
                }
            }
        }
        if (text.contains("{DynamicColor}")) {
            symbol = percentage < 33.33 ? HoloMobHealth.lowColor : (percentage < 66.67 ? HoloMobHealth.halfColor : HoloMobHealth.healthyColor);
            text = text.replace("{DynamicColor}", symbol);
        }
        if (text.contains("{ScaledSymbols}")) {
            symbol = ParsePlaceholders.getSymbol(percentage, heartScale);
            text = text.replace("{ScaledSymbols}", symbol);
        }
        try {
            text = CustomPlaceholderScripts.runScripts(text, entity, healthChange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        text = ChatColorUtils.translateAlternateColorCodes('&', text);
        if (HoloMobHealth.placeholderAPIHook && player != null) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        text = ChatColorUtils.translateAlternateColorCodes('&', text);
        String rawName = CustomNameUtils.getMobCustomName((Entity)entity);
        TextComponent customName = rawName == null ? Component.empty() : LegacyComponentSerializer.legacySection().deserialize(rawName);
        Component displayComponent = LegacyComponentSerializer.legacySection().deserialize(text);
        if (HoloMobHealth.version.isNewerOrEqualTo(MCVersion.V1_16) && ComponentFont.FONT_TAG_PATTERN.matcher(text).find()) {
            displayComponent = ComponentFont.parseFont(displayComponent);
        }
        displayComponent = displayComponent.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{Mob_Type}").replacement(Component.translatable(LanguageUtils.getTranslationKey((Entity)entity))).build());
        displayComponent = displayComponent.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{Mob_Name}").replacement(customName).build());
        displayComponent = displayComponent.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{Mob_Type_Or_Name}").replacement(customName.equals(Component.empty()) ? Component.translatable(LanguageUtils.getTranslationKey((Entity)entity)) : customName).build());
        return displayComponent;
    }

    private static String getSymbol(double percentage, int heartScale) {
        StringBuilder symbol = new StringBuilder();
        double healthpercentagescaled = percentage / 100.0 * (double)heartScale;
        int fullhearts = (int)Math.floor(healthpercentagescaled);
        for (int i = 0; i < fullhearts; ++i) {
            symbol.append(HoloMobHealth.healthyChar);
        }
        if (fullhearts < heartScale) {
            double leftover = healthpercentagescaled - (double)fullhearts;
            if (leftover > 0.5) {
                symbol.append(HoloMobHealth.healthyChar);
            } else if (fullhearts > 0 && leftover > 1.0E-6 || fullhearts == 0 && leftover > 0.0) {
                symbol.append(HoloMobHealth.halfChar);
            } else {
                symbol.append(HoloMobHealth.emptyChar);
            }
            for (int i = fullhearts + 1; i < heartScale; ++i) {
                symbol.append(HoloMobHealth.emptyChar);
            }
        }
        return symbol.toString();
    }
}

