/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.ConfigurationSection;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ScalarComment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.extensions.MergedYamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.utils.UnicodeUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class RootConfigurationSection
extends ConfigurationSection {
    private Map<String, WeakReference<ConfigurationSection>> createdSubsections;
    private ReentrantLock lock;

    protected RootConfigurationSection(YamlMapping rootMapping) {
        super(null, "", rootMapping);
        this.root = this;
        this.createdSubsections = new HashMap<String, WeakReference<ConfigurationSection>>();
        this.lock = new ReentrantLock(true);
    }

    @Override
    public boolean isRoot() {
        return this.root == this;
    }

    @Override
    public void set(String path, Object value) {
        if (!this.isRoot()) {
            super.set(path, value);
            return;
        }
        this.lock.lock();
        if (value == null) {
            String[] paths = this.toPathArray(path);
            if (paths.length < 1) {
                this.currentMapping = Yaml.createYamlMappingBuilder().build();
            } else if (paths.length < 2) {
                YamlMappingBuilder builder = Yaml.createYamlMappingBuilder();
                for (YamlNode key : this.currentMapping.keys()) {
                    if (key.asScalar().value().equals(paths[paths.length - 1])) continue;
                    builder = builder.add(key, this.currentMapping.value(key));
                }
                this.currentMapping = builder.build();
            } else {
                LinkedList<String> pathSections = new LinkedList<String>(Arrays.asList(paths));
                String sectionKey = pathSections.removeLast();
                YamlMapping section = this.getMapping(this.fromPathList(pathSections));
                if (section != null) {
                    YamlMappingBuilder builder = Yaml.createYamlMappingBuilder();
                    for (YamlNode key : section.keys()) {
                        if (key.asScalar().value().equals(sectionKey)) continue;
                        builder = builder.add(key, section.value(key));
                    }
                    YamlMapping mapping = builder.build(section.comment().value());
                    for (int i = paths.length - 3; i >= 0; --i) {
                        sectionKey = pathSections.removeLast();
                        builder = Yaml.createYamlMappingBuilder();
                        section = this.getMapping(this.fromPathList(pathSections));
                        for (YamlNode key : section.keys()) {
                            if (key.asScalar().value().equals(sectionKey)) {
                                builder = builder.add(key, (YamlNode)mapping);
                                continue;
                            }
                            builder = builder.add(key, section.value(key));
                        }
                        mapping = Yaml.createYamlMappingBuilder().add(paths[i], (YamlNode)builder.build(section.comment().value())).build();
                    }
                    sectionKey = pathSections.removeLast();
                    builder = Yaml.createYamlMappingBuilder();
                    for (YamlNode key : this.currentMapping.keys()) {
                        if (key.asScalar().value().equals(sectionKey)) {
                            builder = builder.add(key, mapping.value(key));
                            continue;
                        }
                        builder = builder.add(key, this.currentMapping.value(key));
                    }
                    this.currentMapping = builder.build(this.currentMapping.comment().value());
                }
            }
        } else {
            YamlNode newNode;
            if (value instanceof String) {
                value = UnicodeUtils.escape((String)value);
            }
            String comment = "";
            YamlNode currentNode = this.getNode(path);
            if (currentNode != null) {
                comment = currentNode.comment().value();
            }
            if (value instanceof Collection) {
                newNode = this.createSequence((Collection)value).build(comment);
            } else if (value instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)value;
                if (section == this) {
                    this.lock.unlock();
                    throw new IllegalStateException("ConfigurationSection cannot be nested into self");
                }
                if (section.fromExistingYaml()) {
                    this.lock.unlock();
                    throw new IllegalStateException("ConfigurationSection from an existing Yaml cannot be set into another Yaml");
                }
                YamlMappingBuilder builder = Yaml.createYamlMappingBuilder();
                YamlMapping mapping = section.currentMapping;
                for (YamlNode key : mapping.keys()) {
                    builder = builder.add(key, mapping.value(key));
                }
                newNode = builder.build(comment);
                section.toSubsection(this, path);
            } else {
                String inlineComment = "";
                if (currentNode != null && currentNode.comment() instanceof ScalarComment) {
                    inlineComment = ((ScalarComment)currentNode.comment()).inline().value();
                }
                newNode = Yaml.createYamlScalarBuilder().addLine(value.toString()).buildPlainScalar(comment, inlineComment);
            }
            String[] paths = this.toPathArray(path);
            YamlMapping mapping = Yaml.createYamlMappingBuilder().add(paths[paths.length - 1], newNode).build();
            for (int i = paths.length - 2; i >= 0; --i) {
                mapping = Yaml.createYamlMappingBuilder().add(paths[i], (YamlNode)mapping).build();
            }
            this.currentMapping = new MergedYamlMapping(this.currentMapping, mapping, true);
        }
        this.remapSubsections();
        this.lock.unlock();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAboveComment(String path, String comment) {
        void var7_11;
        YamlMapping mapping;
        Object builder;
        YamlNode newNode;
        if (!this.isRoot()) {
            super.setAboveComment(path, comment);
            return;
        }
        if (comment == null) {
            comment = "";
        }
        this.lock.lock();
        YamlNode currentNode = this.getNode(path);
        if (currentNode == null) {
            return;
        }
        if (currentNode instanceof Scalar) {
            Scalar scalar = (Scalar)currentNode;
            newNode = Yaml.createYamlScalarBuilder().addLine(scalar.value()).buildPlainScalar(comment, ((ScalarComment)scalar.comment()).inline().value());
        } else if (currentNode instanceof YamlSequence) {
            builder = Yaml.createYamlSequenceBuilder();
            for (YamlNode yamlNode : ((YamlSequence)currentNode).values()) {
                builder = builder.add(yamlNode);
            }
            newNode = builder.build(comment);
        } else if (currentNode instanceof YamlMapping) {
            builder = Yaml.createYamlMappingBuilder();
            mapping = (YamlMapping)currentNode;
            for (YamlNode key : mapping.keys()) {
                builder = builder.add(key, mapping.value(key));
            }
            newNode = builder.build(comment);
        } else {
            return;
        }
        String[] paths = this.toPathArray(path);
        mapping = Yaml.createYamlMappingBuilder().add(paths[paths.length - 1], newNode).build();
        int n = paths.length - 2;
        while (var7_11 >= 0) {
            mapping = Yaml.createYamlMappingBuilder().add(paths[var7_11], (YamlNode)mapping).build();
            --var7_11;
        }
        this.currentMapping = new MergedYamlMapping(this.currentMapping, mapping, true);
        this.remapSubsections();
        this.lock.unlock();
    }

    @Override
    public void setInlineComment(String path, String comment) {
        if (!this.isRoot()) {
            super.setInlineComment(path, comment);
            return;
        }
        if (comment == null) {
            comment = "";
        }
        this.lock.lock();
        Scalar currentNode = this.getScalar(path);
        if (currentNode == null) {
            return;
        }
        String[] paths = this.toPathArray(path);
        YamlMapping mapping = Yaml.createYamlMappingBuilder().add(paths[paths.length - 1], (YamlNode)Yaml.createYamlScalarBuilder().addLine(currentNode.toString()).buildPlainScalar(currentNode.comment().value(), comment)).build();
        for (int i = paths.length - 2; i >= 0; --i) {
            mapping = Yaml.createYamlMappingBuilder().add(paths[i], (YamlNode)mapping).build();
        }
        this.currentMapping = new MergedYamlMapping(this.currentMapping, mapping, true);
        this.remapSubsections();
        this.lock.unlock();
    }

    @Override
    protected void toSubsection(RootConfigurationSection root, String currentPath) {
        if (!this.isRoot()) {
            super.toSubsection(root, currentPath);
            return;
        }
        this.lock.lock();
        this.root = root;
        this.currentPath = currentPath;
        for (Map.Entry<String, WeakReference<ConfigurationSection>> entry : this.createdSubsections.entrySet()) {
            String fullPath = this.toFullPath(entry.getKey());
            WeakReference<ConfigurationSection> reference = entry.getValue();
            ConfigurationSection subsection = (ConfigurationSection)reference.get();
            if (subsection == null) continue;
            subsection.currentPath = fullPath;
            root.createdSubsections.put(fullPath, reference);
        }
        this.createdSubsections = null;
        this.lock.unlock();
        this.lock = null;
    }

    protected ConfigurationSection createOrGetSubsection(String path, YamlMapping mapping) {
        ConfigurationSection section;
        if (!this.isRoot()) {
            throw new IllegalStateException("This RootConfigurationSection is no longer root.");
        }
        if (path.isEmpty()) {
            return this;
        }
        this.lock.lock();
        WeakReference<ConfigurationSection> reference = this.createdSubsections.get(path);
        if (reference == null || (section = (ConfigurationSection)reference.get()) == null) {
            section = new ConfigurationSection(this, path, mapping);
            this.createdSubsections.put(path, new WeakReference<ConfigurationSection>(section));
        }
        this.lock.unlock();
        return section;
    }

    protected void remapSubsections() {
        this.lock.lock();
        Iterator<Map.Entry<String, WeakReference<ConfigurationSection>>> itr = this.createdSubsections.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, WeakReference<ConfigurationSection>> entry = itr.next();
            ConfigurationSection section = (ConfigurationSection)entry.getValue().get();
            if (section == null) {
                itr.remove();
                continue;
            }
            section.currentMapping = this.getMapping(entry.getKey());
        }
        this.lock.unlock();
    }
}

