/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.AllYamlLines;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadFoldedBlockScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadLiteralBlockScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadPlainScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadYamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadYamlSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadYamlStream;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.RtYamlLine;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Skip;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlInput;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlLine;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;

final class RtYamlInput
implements YamlInput {
    private final InputStream source;
    private final Charset charset;
    private final boolean guessIndentation;

    RtYamlInput(InputStream source) {
        this(source, false);
    }

    RtYamlInput(InputStream source, boolean guessIndentation) {
        this(source, Charset.defaultCharset(), guessIndentation);
    }

    RtYamlInput(InputStream source, Charset charset, boolean guessIndentation) {
        this.source = source;
        this.charset = charset;
        this.guessIndentation = guessIndentation;
    }

    @Override
    public YamlMapping readYamlMapping() throws IOException {
        return new ReadYamlMapping(this.readInput(), this.guessIndentation);
    }

    @Override
    public YamlSequence readYamlSequence() throws IOException {
        return new ReadYamlSequence(this.readInput(), this.guessIndentation);
    }

    @Override
    public YamlStream readYamlStream() throws IOException {
        return new ReadYamlStream(this.readInput(), this.guessIndentation);
    }

    @Override
    public Scalar readPlainScalar() throws IOException {
        AllYamlLines all = this.readInput();
        Iterator<YamlLine> iterator = new Skip(all, line -> line.trimmed().startsWith("#"), line -> line.trimmed().startsWith("---"), line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!")).iterator();
        ReadPlainScalar read = !iterator.hasNext() ? new ReadPlainScalar(all, new YamlLine.NullYamlLine()) : new ReadPlainScalar(all, iterator.next());
        return read;
    }

    @Override
    public Scalar readFoldedBlockScalar() throws IOException {
        return new ReadFoldedBlockScalar(this.readInput());
    }

    @Override
    public Scalar readLiteralBlockScalar() throws IOException {
        return new ReadLiteralBlockScalar(this.readInput());
    }

    private AllYamlLines readInput() throws IOException {
        ArrayList<YamlLine> lines = new ArrayList<YamlLine>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.source, this.charset));){
            String line;
            int number = 0;
            while ((line = reader.readLine()) != null) {
                if (this.mappingStartsAtDash(line)) {
                    String seqIndent = Stream.iterate(" ", s -> s).limit(new RtYamlLine(line, number).indentation()).reduce((acc, space) -> acc + space).orElse("");
                    RtYamlLine sequenceLine = new RtYamlLine(seqIndent + "-", number);
                    lines.add(sequenceLine);
                    String offset = "  ";
                    String keyValueIndent = seqIndent + "  ";
                    RtYamlLine keyValueLine = new RtYamlLine(keyValueIndent + line.split("-")[1].trim(), ++number);
                    if (!((Object)keyValueLine).toString().trim().isEmpty()) {
                        lines.add(keyValueLine);
                    }
                } else {
                    RtYamlLine current = new RtYamlLine(line, number);
                    if (!((Object)current).toString().trim().isEmpty()) {
                        lines.add(current);
                    }
                }
                ++number;
            }
        }
        return new AllYamlLines(lines);
    }

    private boolean mappingStartsAtDash(String line) {
        String trimmed = line.trim();
        boolean escapedScalar = trimmed.matches("^[ ]*-[ ]*\".*\"$") || trimmed.matches("^[ ]*-[ ]*'.*'$");
        return trimmed.matches("^[ ]*-.*:.+$") && !escapedScalar;
    }
}

