/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.modules;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.holders.HoloMobArmorStand;
import com.loohp.holomobhealth.holders.MultilineStands;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.holomobhealth.modules.RangeModule;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.platform.PlatformPacketListenerPriority;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientEntityMetadataPacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientEntityTeleportPacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientRelativeEntityMoveLookPacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientRelativeEntityMovePacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientSpawnEntityLivingPacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientSpawnEntityPacket;
import com.loohp.holomobhealth.protocol.ArmorStandPacket;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import com.loohp.holomobhealth.utils.ChatColorUtils;
import com.loohp.holomobhealth.utils.CitizensUtils;
import com.loohp.holomobhealth.utils.CustomNameUtils;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.MCVersion;
import com.loohp.holomobhealth.utils.MyPetUtils;
import com.loohp.holomobhealth.utils.MythicMobsUtils;
import com.loohp.holomobhealth.utils.ParsePlaceholders;
import com.loohp.holomobhealth.utils.RayTrace;
import com.loohp.holomobhealth.utils.ShopkeepersUtils;
import com.loohp.holomobhealth.utils.WorldGuardUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.potion.PotionEffectType;

public class ArmorstandDisplay
implements Listener {
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private static final Map<UUID, MultilineStands> mapping = new HashMap<UUID, MultilineStands>();
    private static final Map<Player, UUID> focusingEntities = new HashMap<Player, UUID>();

    public static void run() {
        Scheduler.runTaskTimer(HoloMobHealth.plugin, () -> {
            if (HoloMobHealth.alwaysShow || !HoloMobHealth.armorStandMode) {
                return;
            }
            Collection players = Bukkit.getOnlinePlayers();
            int perTick = (int)Math.ceil((double)players.size() / 5.0);
            int current = 0;
            int count = 0;
            for (Player each : players) {
                UUID playerUUID = each.getUniqueId();
                if (count >= perTick) {
                    count = 0;
                    ++current;
                }
                ++count;
                Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
                    Player player = Bukkit.getPlayer((UUID)playerUUID);
                    if (player == null) {
                        return;
                    }
                    if (HoloMobHealth.disabledWorlds.contains(player.getWorld().getName())) {
                        return;
                    }
                    Entity entity = RayTrace.getLookingEntity((LivingEntity)player, 6.0);
                    UUID last = focusingEntities.get(player);
                    if (entity != null) {
                        UUID now = entity.getUniqueId();
                        if (!now.equals(last)) {
                            focusingEntities.put(player, now);
                            EntityMetadata.updateEntity(player, entity);
                        }
                    } else if (last != null) {
                        focusingEntities.remove(player);
                        Entity lastEntity = NMS.getInstance().getEntityFromUUID(last);
                        if (lastEntity != null) {
                            EntityMetadata.updateEntity(player, lastEntity);
                        }
                    }
                }, current);
            }
        }, 0L, 5L);
    }

    public static void entityMetadataPacketListener() {
        Bukkit.getPluginManager().registerEvents((Listener)new ArmorstandDisplay(), HoloMobHealth.plugin);
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientEntityMeta(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
            block13: {
                try {
                    Player player = event.getPlayer();
                    PlatformPlayClientEntityMetadataPacket packet = (PlatformPlayClientEntityMetadataPacket)event.getPacket();
                    World world = player.getWorld();
                    int entityId = packet.getEntityId();
                    Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                    if (entity == null) {
                        return;
                    }
                    UUID entityUUID = entity.getUniqueId();
                    if (!player.hasPermission("holomobhealth.use") || !HoloMobHealth.playersEnabled.contains(player)) {
                        MultilineStands multi = mapping.get(entityUUID);
                        if (multi == null) {
                            return;
                        }
                        ArrayList<Player> players = new ArrayList<Player>();
                        players.add(player);
                        Map<HoloMobArmorStand, Boolean> list = ArmorStandPacket.playerStatus.get(player);
                        multi.getStands().forEach(each -> {
                            ArmorStandPacket.removeArmorStand(players, each, false, false);
                            if (list != null) {
                                list.remove(each);
                            }
                        });
                        return;
                    }
                    ArmorStandDisplayData data = ArmorstandDisplay.getData(player, entity, world, packet);
                    if (data == null) break block13;
                    if (data.use()) {
                        packet.setEntityDataWatchers(data.getWatcher());
                        Component customName = data.getCustomName();
                        if (!EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity))) break block13;
                        if (entity.getPassenger() != null || ArmorstandDisplay.isInvisible(entity) || !HoloMobHealth.applyToNamed && customName != null || HoloMobHealth.useAlterHealth && !HoloMobHealth.idleUse && !HoloMobHealth.altShowHealth.containsKey(entity.getUniqueId()) || HoloMobHealth.rangeEnabled && !RangeModule.isEntityInRangeOfPlayer(player, entity)) {
                            Component name = customName == null ? Component.empty() : customName;
                            boolean visible = entity.isCustomNameVisible();
                            EntityMetadata.sendMetadataPacket(entity, name, visible, Collections.singletonList(player), true);
                            MultilineStands multi = mapping.remove(entity.getUniqueId());
                            if (multi == null) {
                                return;
                            }
                            multi.getStands().forEach(each -> ArmorStandPacket.removeArmorStand(HoloMobHealth.playersEnabled, each, true, false));
                            multi.remove();
                            break block13;
                        }
                        if (!entity.isValid()) break block13;
                        MultilineStands multi = mapping.get(entity.getUniqueId());
                        if (multi == null) {
                            multi = new MultilineStands(entity);
                            mapping.put(entity.getUniqueId(), multi);
                            ArrayList<HoloMobArmorStand> stands = new ArrayList<HoloMobArmorStand>(multi.getStands());
                            Collections.reverse(stands);
                            for (HoloMobArmorStand stand : stands) {
                                ArmorStandPacket.sendArmorStandSpawn(HoloMobHealth.playersEnabled, stand, Component.empty(), HoloMobHealth.alwaysShow);
                            }
                        } else {
                            ArrayList<Player> players = new ArrayList<Player>();
                            players.add(player);
                            for (HoloMobArmorStand stand : multi.getStands()) {
                                ArmorStandPacket.sendArmorStandSpawnIfNotAlready(players, stand, Component.empty(), HoloMobHealth.alwaysShow);
                            }
                        }
                        UUID focusing = focusingEntities.getOrDefault(player, EMPTY_UUID);
                        multi.setLocation(entity.getLocation());
                        for (int i = 0; i < data.getComponents().size(); ++i) {
                            Component display = data.getComponents().get(i);
                            ArmorStandPacket.updateArmorStand(entity, multi.getStand(i), display, HoloMobHealth.alwaysShow || focusing.equals(entityUUID));
                        }
                        break block13;
                    }
                    Scheduler.runTaskLater(HoloMobHealth.plugin, () -> {
                        MultilineStands multi = mapping.remove(entityUUID);
                        if (multi == null) {
                            return;
                        }
                        Component name = NMS.getInstance().getEntityName(entity);
                        boolean visible = entity.isCustomNameVisible();
                        EntityMetadata.sendMetadataPacket(entity, name, visible, Collections.singletonList(player), true);
                        multi.getStands().forEach(each -> ArmorStandPacket.removeArmorStand(HoloMobHealth.playersEnabled, each, true, false));
                        multi.remove();
                        EntityMetadata.sendMetadataPacket(entity, name, entity.isCustomNameVisible(), entity.getWorld().getPlayers(), true);
                    }, 1L);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        });
        if (HoloMobHealth.version.isOlderThan(MCVersion.V1_19)) {
            HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientSpawnEntityLiving(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
                try {
                    PlatformPlayClientSpawnEntityLivingPacket packet = (PlatformPlayClientSpawnEntityLivingPacket)event.getPacket();
                    Player player = event.getPlayer();
                    World world = player.getWorld();
                    int entityId = packet.getEntityId();
                    Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                    if (entity == null) {
                        return;
                    }
                    Scheduler.runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity), 5L);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            });
        }
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientSpawnEntity(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
            try {
                PlatformPlayClientSpawnEntityPacket packet = (PlatformPlayClientSpawnEntityPacket)event.getPacket();
                Player player = event.getPlayer();
                World world = player.getWorld();
                int entityId = packet.getEntityId();
                Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                if (entity == null) {
                    return;
                }
                Scheduler.runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity), 5L);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientEntityTeleport(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
            try {
                PlatformPlayClientEntityTeleportPacket packet = (PlatformPlayClientEntityTeleportPacket)event.getPacket();
                Player player = event.getPlayer();
                World world = player.getWorld();
                int entityId = packet.getEntityId();
                Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                if (entity == null) {
                    return;
                }
                MultilineStands multi = mapping.get(entity.getUniqueId());
                if (multi == null) {
                    return;
                }
                multi.setLocation(entity.getLocation());
                multi.getStands().forEach(each -> ArmorStandPacket.updateArmorStandLocation(entity, each));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientRelativeEntityMove(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
            try {
                PlatformPlayClientRelativeEntityMovePacket packet = (PlatformPlayClientRelativeEntityMovePacket)event.getPacket();
                Player player = event.getPlayer();
                World world = player.getWorld();
                int entityId = packet.getEntityId();
                Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                if (entity == null) {
                    return;
                }
                MultilineStands multi = mapping.get(entity.getUniqueId());
                if (multi == null) {
                    return;
                }
                multi.setLocation(entity.getLocation());
                multi.getStands().forEach(each -> ArmorStandPacket.updateArmorStandLocation(entity, each));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientRelativeEntityMoveLook(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
            try {
                PlatformPlayClientRelativeEntityMoveLookPacket packet = (PlatformPlayClientRelativeEntityMoveLookPacket)event.getPacket();
                Player player = event.getPlayer();
                World world = player.getWorld();
                int entityId = packet.getEntityId();
                Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                if (entity == null) {
                    return;
                }
                MultilineStands multi = mapping.get(entity.getUniqueId());
                if (multi == null) {
                    return;
                }
                multi.setLocation(entity.getLocation());
                multi.getStands().forEach(each -> ArmorStandPacket.updateArmorStandLocation(entity, each));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }

    public static ArmorStandDisplayData getData(Player player, Entity entity, World world, PlatformPlayClientEntityMetadataPacket<?> packet) {
        if (entity == null || !EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity))) {
            return null;
        }
        if (HoloMobHealth.disabledMobTypes.contains(EntityTypeUtils.getEntityType(entity))) {
            return new ArmorStandDisplayData();
        }
        Component customName = CustomNameUtils.getMobCustomName(entity);
        if (!HoloMobHealth.disabledWorlds.contains(world.getName())) {
            if (HoloMobHealth.worldGuardHook && !WorldGuardUtils.checkStateFlag(entity.getLocation(), player, WorldGuardUtils.getHealthDisplayFlag())) {
                return null;
            }
            if (!HoloMobHealth.showCitizens && HoloMobHealth.citizensHook && CitizensUtils.isNPC(entity)) {
                return null;
            }
            if (!HoloMobHealth.showMythicMobs && HoloMobHealth.mythicHook && MythicMobsUtils.isMythicMob(entity)) {
                return null;
            }
            if (!HoloMobHealth.showShopkeepers && HoloMobHealth.shopkeepersHook && ShopkeepersUtils.isShopkeeper(entity)) {
                return null;
            }
            if (!HoloMobHealth.showMyPet && HoloMobHealth.myPetHook && MyPetUtils.isMyPet(entity)) {
                return null;
            }
            if (customName != null) {
                for (String each2 : HoloMobHealth.disabledMobNamesAbsolute) {
                    if (!LegacyComponentSerializer.legacySection().serialize(customName).equals(ChatColorUtils.translateAlternateColorCodes('&', each2))) continue;
                    return new ArmorStandDisplayData();
                }
                for (String each2 : HoloMobHealth.disabledMobNamesContains) {
                    if (!PlainTextComponentSerializer.plainText().serialize(customName).toLowerCase().contains(ChatColorUtils.stripColor(ChatColorUtils.translateAlternateColorCodes('&', each2).toLowerCase()))) continue;
                    return new ArmorStandDisplayData();
                }
            }
            if (!HoloMobHealth.applyToNamed && customName != null) {
                return null;
            }
            boolean useIdle = false;
            if (HoloMobHealth.useAlterHealth && !HoloMobHealth.altShowHealth.containsKey(entity.getUniqueId()) && HoloMobHealth.idleUse) {
                useIdle = true;
            }
            List<?> watcher = packet.getEntityDataWatchers();
            List components = useIdle ? HoloMobHealth.idleDisplayText.stream().map(each -> ParsePlaceholders.parse(player, (LivingEntity)entity, each)).collect(Collectors.toList()) : HoloMobHealth.displayText.stream().map(each -> ParsePlaceholders.parse(player, (LivingEntity)entity, each)).collect(Collectors.toList());
            HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().modifyDataWatchers(watcher, null, false);
            return new ArmorStandDisplayData(watcher, components, customName);
        }
        return null;
    }

    public static boolean isInvisible(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getPotionEffect(PotionEffectType.INVISIBILITY) != null;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (event.getFrom().distanceSquared(event.getTo()) > 0.0) {
            Vehicle vehicle = event.getVehicle();
            List<Entity> passengers = NMS.getInstance().getPassengers((Entity)vehicle);
            if (!passengers.isEmpty()) {
                int range = HoloMobHealth.getUpdateRange(vehicle.getWorld());
                List nearby = vehicle.getNearbyEntities((double)range, (double)range, (double)range).stream().filter(each -> each instanceof Player).map(each -> (Player)each).collect(Collectors.toList());
                for (Entity passenger : passengers) {
                    Scheduler.runTask(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(nearby, passenger));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChangeDimension(EntityPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        MultilineStands multi = mapping.remove(entity.getUniqueId());
        if (multi == null) {
            return;
        }
        multi.getStands().forEach(each -> ArmorStandPacket.removeArmorStand(HoloMobHealth.playersEnabled, each, true, false));
        multi.remove();
        Scheduler.runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(HoloMobHealth.playersEnabled, entity), 2L);
    }

    public static class ArmorStandDisplayData {
        private final boolean use;
        private List<?> watcher;
        private List<Component> components;
        private Component customName;

        private ArmorStandDisplayData(List<?> watcher, List<Component> components, Component customName) {
            this.watcher = watcher;
            this.components = components;
            this.customName = customName;
            this.use = true;
        }

        public ArmorStandDisplayData() {
            this.use = false;
        }

        public List<?> getWatcher() {
            return this.watcher;
        }

        public List<Component> getComponents() {
            return this.components;
        }

        public Component getCustomName() {
            return this.customName;
        }

        public boolean use() {
            return this.use;
        }
    }
}

