/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.modules;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.platform.packets.PlatformPacket;
import com.loohp.holomobhealth.utils.ChatColorUtils;
import com.loohp.holomobhealth.utils.CitizensUtils;
import com.loohp.holomobhealth.utils.CustomNameUtils;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.MathUtils;
import com.loohp.holomobhealth.utils.MyPetUtils;
import com.loohp.holomobhealth.utils.MythicMobsUtils;
import com.loohp.holomobhealth.utils.PacketSender;
import com.loohp.holomobhealth.utils.ParsePlaceholders;
import com.loohp.holomobhealth.utils.ShopkeepersUtils;
import com.loohp.holomobhealth.utils.WorldGuardUtils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DamageIndicator
implements Listener {
    private static final Random RANDOM = new Random();
    private static final Vector VECTOR_ZERO = new Vector(0, 0, 0);
    private static final double EPSILON = 0.001;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (HoloMobHealth.useDamageIndicator && HoloMobHealth.damageIndicatorDamageEnabled && !HoloMobHealth.damageIndicatorPlayerTriggered) {
            LivingEntity livingEntity;
            double finalDamage;
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.SUICIDE) || event.getFinalDamage() > 2.147483647E9) {
                return;
            }
            Entity entity = event.getEntity();
            if (HoloMobHealth.disabledWorlds.contains(entity.getWorld().getName())) {
                return;
            }
            if (!HoloMobHealth.showCitizens && HoloMobHealth.citizensHook && CitizensUtils.isNPC(entity)) {
                return;
            }
            if (!HoloMobHealth.showMythicMobs && HoloMobHealth.mythicHook && MythicMobsUtils.isMythicMob(entity)) {
                return;
            }
            if (!HoloMobHealth.showShopkeepers && HoloMobHealth.shopkeepersHook && ShopkeepersUtils.isShopkeeper(entity)) {
                return;
            }
            if (!HoloMobHealth.showMyPet && HoloMobHealth.myPetHook && MyPetUtils.isMyPet(entity)) {
                return;
            }
            Component customName = CustomNameUtils.getMobCustomName(entity);
            if (customName != null) {
                for (String each : HoloMobHealth.disabledMobNamesAbsolute) {
                    if (!LegacyComponentSerializer.legacySection().serialize(customName).equals(ChatColorUtils.translateAlternateColorCodes('&', each))) continue;
                    return;
                }
                for (String each : HoloMobHealth.disabledMobNamesContains) {
                    if (!PlainTextComponentSerializer.plainText().serialize(customName).toLowerCase().contains(ChatColorUtils.stripColor(ChatColorUtils.translateAlternateColorCodes('&', each).toLowerCase()))) continue;
                    return;
                }
            }
            if ((finalDamage = event.getFinalDamage()) >= HoloMobHealth.damageIndicatorDamageMinimum && entity instanceof LivingEntity && (EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity)) || EntityTypeUtils.getEntityType(entity).equals((Object)EntityType.PLAYER)) && MathUtils.greaterThan((livingEntity = (LivingEntity)entity).getHealth(), 0.0, 0.001) && !livingEntity.isDead()) {
                this.damage(livingEntity, finalDamage);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageEntity(EntityDamageByEntityEvent event) {
        if (HoloMobHealth.useDamageIndicator && HoloMobHealth.damageIndicatorDamageEnabled && HoloMobHealth.damageIndicatorPlayerTriggered) {
            LivingEntity livingEntity;
            double finalDamage;
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.SUICIDE) || event.getFinalDamage() > 2.147483647E9) {
                return;
            }
            Entity entity = event.getEntity();
            if (HoloMobHealth.disabledWorlds.contains(entity.getWorld().getName())) {
                return;
            }
            if (!HoloMobHealth.showCitizens && HoloMobHealth.citizensHook && CitizensUtils.isNPC(entity)) {
                return;
            }
            if (!HoloMobHealth.showMythicMobs && HoloMobHealth.mythicHook && MythicMobsUtils.isMythicMob(entity)) {
                return;
            }
            if (!HoloMobHealth.showShopkeepers && HoloMobHealth.shopkeepersHook && ShopkeepersUtils.isShopkeeper(entity)) {
                return;
            }
            if (!HoloMobHealth.showMyPet && HoloMobHealth.myPetHook && MyPetUtils.isMyPet(entity)) {
                return;
            }
            Component customName = CustomNameUtils.getMobCustomName(entity);
            if (customName != null) {
                for (String each : HoloMobHealth.disabledMobNamesAbsolute) {
                    if (!LegacyComponentSerializer.legacySection().serialize(customName).equals(ChatColorUtils.translateAlternateColorCodes('&', each))) continue;
                    return;
                }
                for (String each : HoloMobHealth.disabledMobNamesContains) {
                    if (!PlainTextComponentSerializer.plainText().serialize(customName).toLowerCase().contains(ChatColorUtils.stripColor(ChatColorUtils.translateAlternateColorCodes('&', each).toLowerCase()))) continue;
                    return;
                }
            }
            if (!event.getDamager().getType().equals((Object)EntityType.PLAYER)) {
                if (event.getDamager() instanceof Projectile) {
                    Projectile projectile = (Projectile)event.getDamager();
                    if (projectile.getShooter() == null) {
                        return;
                    }
                    if (!(projectile.getShooter() instanceof Player)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if ((finalDamage = event.getFinalDamage()) >= HoloMobHealth.damageIndicatorDamageMinimum && entity instanceof LivingEntity && (EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity)) || EntityTypeUtils.getEntityType(entity).equals((Object)EntityType.PLAYER)) && MathUtils.greaterThan((livingEntity = (LivingEntity)entity).getHealth(), 0.0, 0.001) && !livingEntity.isDead()) {
                this.damage(livingEntity, finalDamage);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRegen(EntityRegainHealthEvent event) {
        if (HoloMobHealth.useDamageIndicator && HoloMobHealth.damageIndicatorRegenEnabled) {
            LivingEntity livingentity;
            Entity entity = event.getEntity();
            if (HoloMobHealth.disabledWorlds.contains(entity.getWorld().getName())) {
                return;
            }
            if (!HoloMobHealth.showCitizens && HoloMobHealth.citizensHook && CitizensUtils.isNPC(entity)) {
                return;
            }
            if (!HoloMobHealth.showMythicMobs && HoloMobHealth.mythicHook && MythicMobsUtils.isMythicMob(entity)) {
                return;
            }
            if (!HoloMobHealth.showShopkeepers && HoloMobHealth.shopkeepersHook && ShopkeepersUtils.isShopkeeper(entity)) {
                return;
            }
            if (!HoloMobHealth.showMyPet && HoloMobHealth.myPetHook && MyPetUtils.isMyPet(entity)) {
                return;
            }
            Component customName = CustomNameUtils.getMobCustomName(entity);
            if (customName != null) {
                for (String each : HoloMobHealth.disabledMobNamesAbsolute) {
                    if (!LegacyComponentSerializer.legacySection().serialize(customName).equals(ChatColorUtils.translateAlternateColorCodes('&', each))) continue;
                    return;
                }
                for (String each : HoloMobHealth.disabledMobNamesContains) {
                    if (!PlainTextComponentSerializer.plainText().serialize(customName).toLowerCase().contains(ChatColorUtils.stripColor(ChatColorUtils.translateAlternateColorCodes('&', each).toLowerCase()))) continue;
                    return;
                }
            }
            if (HoloMobHealth.damageIndicatorPlayerTriggered) {
                if (entity instanceof Player) {
                    livingentity = (LivingEntity)entity;
                    double health = livingentity.getHealth();
                    double maxHealth = !HoloMobHealth.version.isLegacy() ? livingentity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() : livingentity.getMaxHealth();
                    double gain = Math.min(maxHealth - health, event.getAmount());
                    if (gain >= HoloMobHealth.damageIndicatorRegenMinimum) {
                        this.regen(livingentity, gain);
                    }
                }
            } else if (entity instanceof LivingEntity && (EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity)) || EntityTypeUtils.getEntityType(entity).equals((Object)EntityType.PLAYER))) {
                livingentity = (LivingEntity)entity;
                double health = livingentity.getHealth();
                double maxHealth = !HoloMobHealth.version.isLegacy() ? livingentity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() : livingentity.getMaxHealth();
                double gain = Math.min(maxHealth - health, event.getAmount());
                if (gain >= HoloMobHealth.damageIndicatorRegenMinimum) {
                    this.regen(livingentity, gain);
                }
            }
        }
    }

    public void damage(LivingEntity entity, double damage) {
        double z;
        double x;
        Location location = entity.getLocation();
        if (HoloMobHealth.worldGuardHook && !WorldGuardUtils.checkStateFlag(location, null, WorldGuardUtils.getDamageIndicatorFlag())) {
            return;
        }
        double height = NMS.getInstance().getEntityHeight((Entity)entity);
        double width = NMS.getInstance().getEntityWidth((Entity)entity);
        double y = height / 2.0 + (RANDOM.nextDouble() - 0.5) * 0.5;
        if (RANDOM.nextBoolean()) {
            x = RANDOM.nextBoolean() ? width : -width;
            z = RANDOM.nextDouble() * width - width / 2.0;
        } else {
            x = RANDOM.nextDouble() * width - width / 2.0;
            z = RANDOM.nextBoolean() ? width : -width;
        }
        location.add(0.0, y + HoloMobHealth.damageIndicatorDamageY, 0.0);
        Location indicator = location.clone().add(x, 0.0, z);
        Vector velocity = HoloMobHealth.damageIndicatorDamageAnimation ? indicator.toVector().subtract(location.toVector()).normalize().multiply(0.15).add(new Vector(0.0, 0.1, 0.0)) : VECTOR_ZERO;
        Component component = ParsePlaceholders.parse(entity, HoloMobHealth.damageIndicatorDamageText, -damage);
        this.playIndicator(component, indicator, velocity, true, height);
    }

    public void regen(LivingEntity entity, double gain) {
        double z;
        double x;
        Location location = entity.getLocation();
        if (HoloMobHealth.worldGuardHook && !WorldGuardUtils.checkStateFlag(location, null, WorldGuardUtils.getRegenIndicatorFlag())) {
            return;
        }
        double height = NMS.getInstance().getEntityHeight((Entity)entity);
        double width = NMS.getInstance().getEntityWidth((Entity)entity);
        if (RANDOM.nextBoolean()) {
            x = RANDOM.nextBoolean() ? width : -width;
            z = RANDOM.nextDouble() * width - width / 2.0;
        } else {
            x = RANDOM.nextDouble() * width - width / 2.0;
            z = RANDOM.nextBoolean() ? width : -width;
        }
        location.add(x, height / 2.0 + (RANDOM.nextDouble() - 1.0) * 0.5 + HoloMobHealth.damageIndicatorRegenY, z);
        Vector velocity = HoloMobHealth.damageIndicatorRegenAnimation ? new Vector(0.0, 0.2, 0.0) : VECTOR_ZERO;
        Component component = ParsePlaceholders.parse(entity, HoloMobHealth.damageIndicatorRegenText, gain);
        this.playIndicator(component, location, velocity, false, height);
    }

    public void playIndicator(Component entityNameComponent, final Location location, final Vector velocity, final boolean gravity, final double fallHeight) {
        Scheduler.runTaskAsynchronously(HoloMobHealth.plugin, () -> {
            int entityId;
            try {
                entityId = NMS.getInstance().getNextEntityId().get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            UUID uuid = UUID.randomUUID();
            final Location originalLocation = location.clone();
            List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createSpawnDamageIndicatorPackets(entityId, uuid, entityNameComponent, location, velocity, gravity);
            int range = HoloMobHealth.damageIndicatorVisibleRange;
            final List players = location.getWorld().getPlayers().stream().filter(each -> {
                Location loc = each.getLocation();
                return loc.getWorld().equals((Object)location.getWorld()) && loc.distance(location) <= (double)(range * range) && HoloMobHealth.playersEnabled.contains(each);
            }).collect(Collectors.toList());
            PacketSender.sendServerPackets(players, packets);
            final Vector downwardAccel = new Vector(0.0, -0.05, 0.0);
            new BukkitRunnable(){
                int tick = 0;

                public void run() {
                    ++this.tick;
                    if (!velocity.equals((Object)VECTOR_ZERO) && this.tick < HoloMobHealth.damageIndicatorTimeout && originalLocation.getY() - location.getY() < fallHeight) {
                        Vector drag = velocity.clone().normalize().multiply(-0.03);
                        if (gravity) {
                            velocity.add(downwardAccel);
                        }
                        velocity.add(drag);
                        location.add(velocity);
                        List<PlatformPacket<?>> packet = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createEntityTeleportPackets(entityId, location);
                        PacketSender.sendServerPackets(players, packet);
                    } else if (this.tick >= HoloMobHealth.damageIndicatorTimeout) {
                        this.cancel();
                        List<PlatformPacket<?>> packets = HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().createEntityDestroyPackets(entityId);
                        Scheduler.runTaskLaterAsynchronously(HoloMobHealth.plugin, () -> PacketSender.sendServerPackets(players, packets), 3L);
                    }
                }
            }.runTaskTimerAsynchronously(HoloMobHealth.plugin, 0L, 1L);
        });
    }
}

