/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.modules;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.holomobhealth.modules.RangeModule;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.platform.PlatformPacketListenerPriority;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientEntityMetadataPacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientSpawnEntityLivingPacket;
import com.loohp.holomobhealth.platform.packets.PlatformPlayClientSpawnEntityPacket;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import com.loohp.holomobhealth.utils.ChatColorUtils;
import com.loohp.holomobhealth.utils.CitizensUtils;
import com.loohp.holomobhealth.utils.CustomNameUtils;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.MCVersion;
import com.loohp.holomobhealth.utils.MyPetUtils;
import com.loohp.holomobhealth.utils.MythicMobsUtils;
import com.loohp.holomobhealth.utils.ParsePlaceholders;
import com.loohp.holomobhealth.utils.ShopkeepersUtils;
import com.loohp.holomobhealth.utils.WorldGuardUtils;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class NameTagDisplay {
    public static void entityMetadataPacketListener() {
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientEntityMeta(HoloMobHealth.plugin, PlatformPacketListenerPriority.MONITOR, event -> {
            try {
                Player player = event.getPlayer();
                if (!player.hasPermission("holomobhealth.use") || !HoloMobHealth.playersEnabled.contains(player)) {
                    return;
                }
                PlatformPlayClientEntityMetadataPacket packet = (PlatformPlayClientEntityMetadataPacket)event.getPacket();
                World world = player.getWorld();
                int entityId = packet.getEntityId();
                Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                if (entity == null) {
                    return;
                }
                List<?> watcher = NameTagDisplay.getWatcher(player, entity, world, packet);
                if (watcher != null) {
                    boolean readOnly = event.isReadOnly();
                    event.setReadOnly(false);
                    packet.setEntityDataWatchers(watcher);
                    event.setReadOnly(readOnly);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
        if (HoloMobHealth.version.isOlderThan(MCVersion.V1_19)) {
            HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientSpawnEntityLiving(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
                try {
                    PlatformPlayClientSpawnEntityLivingPacket packet = (PlatformPlayClientSpawnEntityLivingPacket)event.getPacket();
                    Player player = event.getPlayer();
                    World world = player.getWorld();
                    int entityId = packet.getEntityId();
                    Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                    if (entity == null) {
                        return;
                    }
                    Scheduler.runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity), 5L);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            });
        }
        HoloMobHealth.protocolPlatform.getPlatformPacketListenerProvider().listenToPlayClientSpawnEntity(HoloMobHealth.plugin, PlatformPacketListenerPriority.HIGHEST, event -> {
            try {
                PlatformPlayClientSpawnEntityPacket packet = (PlatformPlayClientSpawnEntityPacket)event.getPacket();
                Player player = event.getPlayer();
                World world = player.getWorld();
                int entityId = packet.getEntityId();
                Entity entity = NMS.getInstance().getEntityFromID(world, entityId);
                if (entity == null) {
                    return;
                }
                Scheduler.runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity), 5L);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }

    public static List<?> getWatcher(Player player, Entity entity, World world, PlatformPlayClientEntityMetadataPacket<?> packet) {
        if (entity == null || !EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity))) {
            return null;
        }
        if (HoloMobHealth.disabledMobTypes.contains(EntityTypeUtils.getEntityType(entity))) {
            return null;
        }
        Component customName = CustomNameUtils.getMobCustomName(entity);
        if (HoloMobHealth.rangeEnabled && !RangeModule.isEntityInRangeOfPlayer(player, entity)) {
            return null;
        }
        boolean useIdle = false;
        if (HoloMobHealth.useAlterHealth && !HoloMobHealth.altShowHealth.containsKey(entity.getUniqueId())) {
            if (!HoloMobHealth.idleUse) {
                return null;
            }
            useIdle = true;
        }
        if (!HoloMobHealth.disabledWorlds.contains(world.getName())) {
            if (HoloMobHealth.worldGuardHook && !WorldGuardUtils.checkStateFlag(entity.getLocation(), player, WorldGuardUtils.getHealthDisplayFlag())) {
                return null;
            }
            if (!HoloMobHealth.showCitizens && HoloMobHealth.citizensHook && CitizensUtils.isNPC(entity)) {
                return null;
            }
            if (!HoloMobHealth.showMythicMobs && HoloMobHealth.mythicHook && MythicMobsUtils.isMythicMob(entity)) {
                return null;
            }
            if (!HoloMobHealth.showShopkeepers && HoloMobHealth.shopkeepersHook && ShopkeepersUtils.isShopkeeper(entity)) {
                return null;
            }
            if (!HoloMobHealth.showMyPet && HoloMobHealth.myPetHook && MyPetUtils.isMyPet(entity)) {
                return null;
            }
            if (customName != null) {
                for (String each : HoloMobHealth.disabledMobNamesAbsolute) {
                    if (!LegacyComponentSerializer.legacySection().serialize(customName).equals(ChatColorUtils.translateAlternateColorCodes('&', each))) continue;
                    return null;
                }
                for (String each : HoloMobHealth.disabledMobNamesContains) {
                    if (!PlainTextComponentSerializer.plainText().serialize(customName).toLowerCase().contains(ChatColorUtils.stripColor(ChatColorUtils.translateAlternateColorCodes('&', each).toLowerCase()))) continue;
                    return null;
                }
            }
            if (!HoloMobHealth.applyToNamed && customName != null) {
                return null;
            }
            List<?> watcher = packet.getEntityDataWatchers();
            Component component = ParsePlaceholders.parse(player, (LivingEntity)entity, useIdle ? HoloMobHealth.idleDisplayText.get(0) : HoloMobHealth.displayText.get(0));
            boolean visible = HoloMobHealth.alwaysShow;
            HoloMobHealth.protocolPlatform.getPlatformPacketCreatorProvider().modifyDataWatchers(watcher, component, visible);
            return watcher;
        }
        return null;
    }
}

