/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.holders.DataWatcherField;
import com.loohp.holomobhealth.holders.DataWatcherFieldType;
import com.loohp.holomobhealth.holders.DataWatcherFields;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.holomobhealth.nms.NMSWrapper;
import com.loohp.holomobhealth.utils.BoundingBox;
import com.loohp.holomobhealth.utils.UnsafeAccessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class V1_17
extends NMSWrapper {
    private final Field[] entityMetadataPacketFields;
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field dataWatcherNoGravityField;
    private final Field[] spawnEntityLivingPacketFields;
    private final Field[] entityTeleportPacketFields;

    public V1_17() {
        try {
            this.entityMetadataPacketFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.entityCountField = net.minecraft.world.entity.Entity.class.getDeclaredField("b");
            this.dataWatcherByteField = net.minecraft.world.entity.Entity.class.getDeclaredField("Z");
            this.dataWatcherCustomNameField = net.minecraft.world.entity.Entity.class.getDeclaredField("aJ");
            this.dataWatcherCustomNameVisibleField = net.minecraft.world.entity.Entity.class.getDeclaredField("aK");
            this.dataWatcherSilentField = net.minecraft.world.entity.Entity.class.getDeclaredField("aL");
            this.dataWatcherNoGravityField = net.minecraft.world.entity.Entity.class.getDeclaredField("aM");
            this.spawnEntityLivingPacketFields = PacketPlayOutSpawnEntityLiving.class.getDeclaredFields();
            this.entityTeleportPacketFields = PacketPlayOutEntityTeleport.class.getDeclaredFields();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketContainer[]{V1_17.p(new PacketPlayOutEntityDestroy(entityIds))};
    }

    @Override
    public PacketContainer createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata packet = (PacketPlayOutEntityMetadata)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutEntityMetadata.class);
            this.entityMetadataPacketFields[0].setAccessible(true);
            this.entityMetadataPacketFields[0].setInt(packet, entityId);
            this.entityMetadataPacketFields[1].setAccessible(true);
            this.entityMetadataPacketFields[1].set(packet, dataWatchers);
            return V1_17.p(packet);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createEntityTeleportPacket(int entityId, Location location) {
        try {
            PacketPlayOutEntityTeleport packet = (PacketPlayOutEntityTeleport)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutEntityTeleport.class);
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet, entityId);
            this.entityTeleportPacketFields[1].setDouble(packet, location.getX());
            this.entityTeleportPacketFields[2].setDouble(packet, location.getY());
            this.entityTeleportPacketFields[3].setDouble(packet, location.getZ());
            this.entityTeleportPacketFields[4].setByte(packet, (byte)(location.getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet, (byte)(location.getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet, false);
            return V1_17.p(packet);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        org.bukkit.util.BoundingBox box = entity.getBoundingBox();
        return BoundingBox.of(box.getMin(), box.getMax());
    }

    @Override
    public String getEntityTranslationKey(Entity entity) {
        EntityTypes type = (EntityTypes)EntityTypes.a((String)entity.getType().getName()).orElseThrow(() -> new RuntimeException());
        return type.g();
    }

    @Override
    public Component getEntityName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().getDisplayName();
        return GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Component getEntityCustomName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().getCustomName();
        return customName == null ? null : (Component)GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Component getEntityDisplayName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().getScoreboardDisplayName();
        return GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Future<Integer> getNextEntityId() {
        try {
            this.entityCountField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)this.entityCountField.get(null);
            return CompletableFuture.completedFuture(counter.incrementAndGet());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        return entity.getPassengers();
    }

    @Override
    public int getTropicalFishVariant(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityTropicalFish fish = (EntityTropicalFish)nmsEntity;
        return fish.getVariant();
    }

    @Override
    public Entity getEntityFromID(World world, int id) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)worldServer.G.d().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public Entity getEntityFromUUID(UUID uuid) {
        for (World world : Bukkit.getWorlds()) {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)worldServer.G.d().a(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public double getEntityHeight(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.cs();
        double minY = axisAlignedBB.b;
        double maxY = axisAlignedBB.e;
        return maxY - minY;
    }

    @Override
    public double getEntityWidth(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.cs();
        double minX = axisAlignedBB.a;
        double maxX = axisAlignedBB.d;
        return maxX - minX;
    }

    @Override
    public PacketContainer createUpdateEntityPacket(Entity entity) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.getDataWatcher();
            Optional name = (Optional)watcher.get((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.get((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createUpdateEntityMetadataPacket(Entity entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<?> buildDataWatchers(IHoloMobArmorStand entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherNoGravityField.get(null), (Object)true));
            byte standbitmask = 17;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.bG, (Object)standbitmask));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        try {
            EntityTypes type = (EntityTypes)EntityTypes.a((String)entity.getType().getName()).orElseThrow(() -> new RuntimeException());
            PacketPlayOutSpawnEntityLiving packet1 = (PacketPlayOutSpawnEntityLiving)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutSpawnEntityLiving.class);
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entity.getEntityId());
            this.spawnEntityLivingPacketFields[1].set(packet1, entity.getUniqueId());
            this.spawnEntityLivingPacketFields[2].setInt(packet1, IRegistry.Y.getId((Object)type));
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, entity.getLocation().getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, entity.getLocation().getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, entity.getLocation().getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[7].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[8].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
            PacketContainer packet2 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
            return new PacketContainer[]{V1_17.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet1 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        PacketContainer packet2 = this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation());
        return new PacketContainer[]{packet1, packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return new PacketContainer[]{this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation())};
    }

    @Override
    public PacketContainer[] createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, Location location, Vector velocity, boolean gravity) {
        try {
            EntityTypes type = EntityTypes.c;
            PacketPlayOutSpawnEntityLiving packet1 = (PacketPlayOutSpawnEntityLiving)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutSpawnEntityLiving.class);
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entityId);
            this.spawnEntityLivingPacketFields[1].set(packet1, uuid);
            this.spawnEntityLivingPacketFields[2].setInt(packet1, IRegistry.Y.getId((Object)type));
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, location.getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, location.getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, location.getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, (int)(MathHelper.a((double)velocity.getX(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[7].setInt(packet1, (int)(MathHelper.a((double)velocity.getY(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[8].setInt(packet1, (int)(MathHelper.a((double)velocity.getZ(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)0);
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)true));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherSilentField.get(null), (Object)true));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherNoGravityField.get(null), (Object)(!gravity ? 1 : 0)));
            byte standBitmask = 25;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.bG, (Object)standBitmask));
            PacketContainer packet2 = this.createEntityMetadataPacket(entityId, dataWatcher);
            return new PacketContainer[]{V1_17.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> readDataWatchersFromMetadataPacket(PacketContainer packet) {
        PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
        return nmsPacket.b();
    }

    private <T> void addOrReplaceDataWatcher(List<DataWatcher.Item<?>> dataWatcher, DataWatcher.Item<T> newWatcher) {
        for (int i = 0; i < dataWatcher.size(); ++i) {
            DataWatcher.Item<?> watcher = dataWatcher.get(i);
            if (newWatcher.a().a() != watcher.a().a() || !newWatcher.b().equals(watcher.b())) continue;
            dataWatcher.set(i, newWatcher);
            return;
        }
        dataWatcher.add(newWatcher);
    }

    @Override
    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        try {
            List<DataWatcher.Item<?>> dataWatcher = dataWatchers;
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createModifiedMetadataPacket(PacketContainer packet, List<?> dataWatchers) {
        PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
        return this.createEntityMetadataPacket(nmsPacket.c(), dataWatchers);
    }

    @Override
    public DataWatcherFields getDataWatcherFields() {
        try {
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            return new DataWatcherFields(new DataWatcherField(((DataWatcherObject)this.dataWatcherByteField.get(null)).a(), DataWatcherFieldType.BYTE), new DataWatcherField(((DataWatcherObject)this.dataWatcherCustomNameField.get(null)).a(), DataWatcherFieldType.OPTIONAL_CHAT), new DataWatcherField(((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(((DataWatcherObject)this.dataWatcherSilentField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(((DataWatcherObject)this.dataWatcherNoGravityField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(EntityArmorStand.bG.a(), DataWatcherFieldType.BYTE));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

