/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.holders.DataWatcherField;
import com.loohp.holomobhealth.holders.DataWatcherFieldType;
import com.loohp.holomobhealth.holders.DataWatcherFields;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.holomobhealth.nms.NMSWrapper;
import com.loohp.holomobhealth.utils.BoundingBox;
import com.loohp.holomobhealth.utils.UnsafeAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class V1_20_2
extends NMSWrapper {
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field dataWatcherNoGravityField;
    private final Field[] entityTeleportPacketFields;
    private Method worldServerEntityLookup;

    public V1_20_2() {
        try {
            this.entityCountField = net.minecraft.world.entity.Entity.class.getDeclaredField("d");
            this.dataWatcherByteField = net.minecraft.world.entity.Entity.class.getDeclaredField("ao");
            this.dataWatcherCustomNameField = net.minecraft.world.entity.Entity.class.getDeclaredField("aU");
            this.dataWatcherCustomNameVisibleField = net.minecraft.world.entity.Entity.class.getDeclaredField("aV");
            this.dataWatcherSilentField = net.minecraft.world.entity.Entity.class.getDeclaredField("aW");
            this.dataWatcherNoGravityField = net.minecraft.world.entity.Entity.class.getDeclaredField("aX");
            this.entityTeleportPacketFields = PacketPlayOutEntityTeleport.class.getDeclaredFields();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            this.worldServerEntityLookup = WorldServer.class.getMethod("getEntityLookup", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketContainer[]{V1_20_2.p(new PacketPlayOutEntityDestroy(entityIds))};
    }

    @Override
    public PacketContainer createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        return V1_20_2.p(new PacketPlayOutEntityMetadata(entityId, dataWatchers));
    }

    @Override
    public PacketContainer createEntityTeleportPacket(int entityId, Location location) {
        try {
            PacketPlayOutEntityTeleport packet = (PacketPlayOutEntityTeleport)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutEntityTeleport.class);
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet, entityId);
            this.entityTeleportPacketFields[1].setDouble(packet, location.getX());
            this.entityTeleportPacketFields[2].setDouble(packet, location.getY());
            this.entityTeleportPacketFields[3].setDouble(packet, location.getZ());
            this.entityTeleportPacketFields[4].setByte(packet, (byte)(location.getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet, (byte)(location.getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet, false);
            return V1_20_2.p(packet);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        org.bukkit.util.BoundingBox box = entity.getBoundingBox();
        return BoundingBox.of(box.getMin(), box.getMax());
    }

    @Override
    public String getEntityTranslationKey(Entity entity) {
        return CraftEntityType.bukkitToMinecraft((EntityType)entity.getType()).g();
    }

    @Override
    public Component getEntityName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().ab();
        return GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Component getEntityCustomName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().ad();
        return customName == null ? null : (Component)GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Component getEntityDisplayName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().N_();
        return GsonComponentSerializer.gson().deserialize(CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    @Override
    public Future<Integer> getNextEntityId() {
        try {
            this.entityCountField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)this.entityCountField.get(null);
            return CompletableFuture.completedFuture(counter.incrementAndGet());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        return entity.getPassengers();
    }

    @Override
    public int getTropicalFishVariant(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityTropicalFish fish = (EntityTropicalFish)nmsEntity;
        return fish.gp();
    }

    private LevelEntityGetter<net.minecraft.world.entity.Entity> getLevelEntityGetter(World world) {
        try {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            if (this.worldServerEntityLookup == null) {
                return worldServer.M.d();
            }
            return (LevelEntityGetter)this.worldServerEntityLookup.invoke((Object)worldServer, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Entity getEntityFromID(World world, int id) {
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.getLevelEntityGetter(world).a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public Entity getEntityFromUUID(UUID uuid) {
        for (World world : Bukkit.getWorlds()) {
            net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.getLevelEntityGetter(world).a(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public double getEntityHeight(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.cG();
        double minY = axisAlignedBB.b;
        double maxY = axisAlignedBB.e;
        return maxY - minY;
    }

    @Override
    public double getEntityWidth(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.cG();
        double minX = axisAlignedBB.a;
        double maxX = axisAlignedBB.d;
        return maxX - minX;
    }

    @Override
    public PacketContainer createUpdateEntityPacket(Entity entity) {
        try {
            ArrayList<DataWatcher.b> dataWatcher = new ArrayList<DataWatcher.b>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.al();
            Optional name = (Optional)watcher.b((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.b((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), (Object)name));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createUpdateEntityMetadataPacket(Entity entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.b> dataWatcher = new ArrayList<DataWatcher.b>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<?> buildDataWatchers(IHoloMobArmorStand entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.b> dataWatcher = new ArrayList<DataWatcher.b>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherByteField.get(null)), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherNoGravityField.get(null)), (Object)true));
            byte standbitmask = 17;
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)EntityArmorStand.bC, (Object)standbitmask));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer[] createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        EntityTypes type = CraftEntityType.bukkitToMinecraft((EntityType)entity.getType());
        Vec3D velocity = Vec3D.b;
        PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entity.getEntityId(), entity.getUniqueId(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getPitch(), entity.getLocation().getYaw(), type, 0, velocity, (double)entity.getLocation().getYaw());
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet2 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        return new PacketContainer[]{V1_20_2.p(packet1), packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet1 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        PacketContainer packet2 = this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation());
        return new PacketContainer[]{packet1, packet2};
    }

    @Override
    public PacketContainer[] createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return new PacketContainer[]{this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation())};
    }

    @Override
    public PacketContainer[] createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, Location location, Vector velocity, boolean gravity) {
        try {
            EntityTypes type = EntityTypes.d;
            Vec3D vec = new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ());
            PacketPlayOutSpawnEntity packet1 = new PacketPlayOutSpawnEntity(entityId, uuid, location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, type, 0, vec, 0.0);
            ArrayList<DataWatcher.b> dataWatcher = new ArrayList<DataWatcher.b>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherByteField.get(null)), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)true));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherSilentField.get(null)), (Object)true));
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherNoGravityField.get(null)), (Object)(!gravity ? 1 : 0)));
            byte standBitmask = 25;
            dataWatcher.add(DataWatcher.b.a((DataWatcherObject)EntityArmorStand.bC, (Object)standBitmask));
            PacketContainer packet2 = this.createEntityMetadataPacket(entityId, dataWatcher);
            return new PacketContainer[]{V1_20_2.p(packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.b<?>> readDataWatchersFromMetadataPacket(PacketContainer packet) {
        PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
        return nmsPacket.d();
    }

    private <T> void addOrReplaceDataWatcher(List<DataWatcher.b<?>> dataWatcher, DataWatcher.b<T> newWatcher) {
        for (int i = 0; i < dataWatcher.size(); ++i) {
            DataWatcher.b<?> watcher = dataWatcher.get(i);
            if (newWatcher.a() != watcher.a() || !newWatcher.b().equals((Object)watcher.b())) continue;
            dataWatcher.set(i, newWatcher);
            return;
        }
        dataWatcher.add(newWatcher);
    }

    @Override
    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        try {
            List<DataWatcher.b<?>> dataWatcher = dataWatchers;
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            this.addOrReplaceDataWatcher(dataWatcher, DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameField.get(null)), name));
            this.addOrReplaceDataWatcher(dataWatcher, DataWatcher.b.a((DataWatcherObject)((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)), (Object)visible));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PacketContainer createModifiedMetadataPacket(PacketContainer packet, List<?> dataWatchers) {
        PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
        return this.createEntityMetadataPacket(nmsPacket.a(), dataWatchers);
    }

    @Override
    public DataWatcherFields getDataWatcherFields() {
        try {
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            return new DataWatcherFields(new DataWatcherField(((DataWatcherObject)this.dataWatcherByteField.get(null)).a(), DataWatcherFieldType.BYTE), new DataWatcherField(((DataWatcherObject)this.dataWatcherCustomNameField.get(null)).a(), DataWatcherFieldType.OPTIONAL_CHAT), new DataWatcherField(((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(((DataWatcherObject)this.dataWatcherSilentField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(((DataWatcherObject)this.dataWatcherNoGravityField.get(null)).a(), DataWatcherFieldType.BOOLEAN), new DataWatcherField(EntityArmorStand.bC.a(), DataWatcherFieldType.BYTE));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

