/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.registries;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.libs.org.apache.commons.lang3.JavaVersion;
import com.loohp.holomobhealth.libs.org.apache.commons.lang3.SystemUtils;
import com.loohp.holomobhealth.libs.org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;
import com.loohp.holomobhealth.utils.CustomNameUtils;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class CustomPlaceholderScripts {
    private static final Map<String, JavaScriptPlaceholder> scripts = new ConcurrentHashMap<String, JavaScriptPlaceholder>();
    private static final Map<String, Class<?>> scriptDataTypes = new ConcurrentHashMap();
    private static ScriptEngineFactory scriptEngineFactory;

    public static void loadScriptsFromFolder(File folder) {
        File index = new File(folder, "scripts.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)index);
        File scriptFolder = new File(folder, "scripts");
        for (String placeholder : config.getValues(false).keySet()) {
            String fileName = config.getString(placeholder + ".file");
            File file = new File(scriptFolder, fileName);
            if (file.exists()) {
                try {
                    CustomPlaceholderScripts.loadScripts(file, "{" + placeholder + "}");
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to load custom placeholder script from " + file.getName());
                    e.printStackTrace();
                }
                continue;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to load custom placeholder script from " + file.getName() + " because it does not exist!");
        }
    }

    public static void loadScripts(File file, String placeholder) throws Exception {
        ScriptEngine engine = scriptEngineFactory.getScriptEngine();
        if (engine == null) {
            throw new RuntimeException("JavaScript ScriptEngine isn't supported on your JVM! Is your version of Java too new?");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        String script = reader.lines().collect(Collectors.joining("\n"));
        reader.close();
        engine.put("BukkitServer", Bukkit.getServer());
        engine.put("Placeholder", placeholder);
        scripts.put(placeholder, new JavaScriptPlaceholder(engine, placeholder, script));
    }

    public static void clearScripts() {
        scripts.clear();
    }

    public static String evaluate(String text, Double health, Double maxhealth, Double healthchange, String customname, String mobtype, LivingEntity entity, String placeholder, ScriptEngine engine, String script) {
        try {
            engine.put("DisplayText", text);
            engine.put("Health", health);
            engine.put("MaxHealth", maxhealth);
            engine.put("HealthChange", healthchange);
            engine.put("CustomName", customname);
            engine.put("MobType", mobtype);
            engine.put("LivingEntity", entity);
            for (Map.Entry<String, Class<?>> entry : scriptDataTypes.entrySet()) {
                engine.put(entry.getKey(), entry.getValue());
            }
            Object result = engine.eval(script);
            return result != null ? result.toString() : "";
        }
        catch (ScriptException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] An error occurred while executing the script '" + placeholder + "':\n\t" + e.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Argument out of bound while executing script '" + placeholder + "':\n\t" + e.getMessage());
        }
        scripts.remove(placeholder);
        return "Script error (check console)";
    }

    public static String runScripts(String text, LivingEntity entity, double healthchange) {
        double health = entity.getHealth();
        double maxhealth = 0.0;
        maxhealth = !HoloMobHealth.version.isLegacy() ? entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() : entity.getMaxHealth();
        Component customnameComponent = CustomNameUtils.getMobCustomName((Entity)entity);
        String customname = customnameComponent == null ? null : LegacyComponentSerializer.legacySection().serialize(customnameComponent);
        String mobtype = EntityTypeUtils.getEntityType((Entity)entity).toString();
        for (Map.Entry<String, JavaScriptPlaceholder> entry : scripts.entrySet()) {
            String placeholder = entry.getKey();
            if (!text.contains(placeholder)) continue;
            JavaScriptPlaceholder script = entry.getValue();
            String replaceText = CustomPlaceholderScripts.evaluate(text, health, maxhealth, healthchange, customname, mobtype, entity, placeholder, script.getEngine(), script.getScript());
            text = text.replace(placeholder, replaceText);
        }
        return text;
    }

    public static int getScriptsCount() {
        return scripts.size();
    }

    public static void registerClass(String identifier, Class<?> clazz) {
        scriptDataTypes.put(identifier, clazz);
    }

    public static boolean containsClass(String identifier) {
        return scriptDataTypes.containsKey(identifier);
    }

    public static boolean containsClass(Class<?> clazz) {
        return scriptDataTypes.containsValue(clazz);
    }

    static {
        if (SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_15)) {
            scriptEngineFactory = new NashornScriptEngineFactory();
        } else {
            try {
                scriptEngineFactory = (ScriptEngineFactory)Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class JavaScriptPlaceholder {
        private final ScriptEngine engine;
        private final String placeholder;
        private final String script;

        public JavaScriptPlaceholder(ScriptEngine engine, String placeholder, String script) {
            this.engine = engine;
            this.placeholder = placeholder;
            this.script = script;
        }

        public ScriptEngine getEngine() {
            return this.engine;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public String getScript() {
            return this.script;
        }
    }
}

