/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.updater;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.event.ClickEvent;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.event.HoverEvent;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.format.StyleSetter;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.updater.Version;
import com.loohp.holomobhealth.utils.HTTPRequestUtils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.json.simple.JSONObject;

public class Updater
implements Listener {
    public static final String PLUGIN_NAME = "HoloMobHealth";

    public static void sendUpdateMessage(CommandSender sender, String version, int spigotPluginId) {
        Updater.sendUpdateMessage(sender, version, spigotPluginId, false);
    }

    public static void sendUpdateMessage(CommandSender sender, String version, int spigotPluginId, boolean devbuild) {
        if (!version.equals("error")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (!devbuild) {
                    player.sendMessage(ChatColor.YELLOW + "[HoloMobHealth] A new version is available on SpigotMC: " + version);
                    StyleSetter<Component> url = LegacyComponentSerializer.legacySection().deserialize(ChatColor.GOLD + "https://www.spigotmc.org/resources/" + spigotPluginId);
                    url = url.hoverEvent(HoverEvent.showText(Component.text("Click me!").color(NamedTextColor.AQUA)));
                    url = url.clickEvent(ClickEvent.openUrl("https://www.spigotmc.org/resources/" + spigotPluginId));
                    HoloMobHealth.sendMessage((CommandSender)player, url);
                } else {
                    sender.sendMessage(ChatColor.GREEN + "[HoloMobHealth] You are running the latest release!");
                    StyleSetter<Component> url = LegacyComponentSerializer.legacySection().deserialize(ChatColor.YELLOW + "[InteractiveChat] However, a new Development Build is available if you want to try that!");
                    url = url.hoverEvent(HoverEvent.showText(Component.text("Click me!").color(NamedTextColor.AQUA)));
                    url = url.clickEvent(ClickEvent.openUrl("https://ci.loohpjames.com/job/HoloMobHealth"));
                    HoloMobHealth.sendMessage((CommandSender)player, url);
                }
            } else if (!devbuild) {
                sender.sendMessage(ChatColor.YELLOW + "[HoloMobHealth] A new version is available on SpigotMC: " + version);
                sender.sendMessage(ChatColor.GOLD + "Download: https://www.spigotmc.org/resources/" + spigotPluginId);
            } else {
                sender.sendMessage(ChatColor.GREEN + "[HoloMobHealth] You are running the latest release!");
                sender.sendMessage(ChatColor.YELLOW + "[HoloMobHealth] However, a new Development Build is available if you want to try that!");
            }
        }
    }

    public static UpdaterResponse checkUpdate() {
        try {
            String localPluginVersion = HoloMobHealth.plugin.getDescription().getVersion();
            JSONObject response = (JSONObject)HTTPRequestUtils.getJSONResponse("https://api.loohpjames.com/spigot/data").get((Object)PLUGIN_NAME);
            String spigotPluginVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"release");
            String devBuildVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"devbuild");
            int spigotPluginId = (int)((Long)((JSONObject)response.get((Object)"spigotmc")).get((Object)"pluginid")).longValue();
            int posOfThirdDot = localPluginVersion.indexOf(".", localPluginVersion.indexOf(".", localPluginVersion.indexOf(".") + 1) + 1);
            Version currentDevBuild = new Version(localPluginVersion);
            Version currentRelease = new Version(localPluginVersion.substring(0, posOfThirdDot >= 0 ? posOfThirdDot : localPluginVersion.length()));
            Version spigotmc = new Version(spigotPluginVersion);
            Version devBuild = new Version(devBuildVersion);
            if (currentRelease.compareTo(spigotmc) < 0) {
                return new UpdaterResponse(spigotPluginVersion, spigotPluginId, currentDevBuild.compareTo(devBuild) >= 0);
            }
            return new UpdaterResponse("latest", spigotPluginId, currentDevBuild.compareTo(devBuild) >= 0);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Failed to check against \"api.loohpjames.com\" for the latest version.. It could be an internet issue or \"api.loohpjames.com\" is down. If you want disable the update checker, you can disable in config.yml, but we still highly-recommend you to keep your plugin up to date!");
            return new UpdaterResponse("error", -1, false);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Scheduler.runTaskLaterAsynchronously(HoloMobHealth.plugin, () -> {
            UpdaterResponse version;
            Player player;
            if (HoloMobHealth.updaterEnabled && (player = event.getPlayer()).hasPermission("HoloMobHealth.update") && !(version = Updater.checkUpdate()).getResult().equals("latest")) {
                Updater.sendUpdateMessage((CommandSender)player, version.getResult(), version.getSpigotPluginId());
            }
        }, 100L);
    }

    public static class UpdaterResponse {
        private final String result;
        private final int spigotPluginId;
        private final boolean devBuildIsLatest;

        public UpdaterResponse(String result, int spigotPluginId, boolean devBuildIsLatest) {
            this.result = result;
            this.spigotPluginId = spigotPluginId;
            this.devBuildIsLatest = devBuildIsLatest;
        }

        public String getResult() {
            return this.result;
        }

        public int getSpigotPluginId() {
            return this.spigotPluginId;
        }

        public boolean isDevBuildLatest() {
            return this.devBuildIsLatest;
        }
    }
}

