/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.utils.MCVersion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ChatColorUtils {
    private static final Set<Character> colors = new HashSet<Character>();
    private static final Pattern colorFormating = Pattern.compile("(?=(?<!\\\\)|(?<=\\\\\\\\))\\[[^\\]]*?color=#[0-9a-fA-F]{6}[^\\[]*?\\]");
    private static final Pattern colorEscape = Pattern.compile("\\\\\\[ *?color=#[0-9a-fA-F]{6} *?\\]");
    private static final String validColorHex = "^#[0-9a-fA-F]{6}$";

    public static String stripColor(String string) {
        return string.replaceAll("\u00a7[0-9A-Fa-fk-orx]", "");
    }

    public static String filterIllegalColorCodes(String string) {
        return HoloMobHealth.version.isNewerOrEqualTo(MCVersion.V1_16) ? string.replaceAll("\u00a7[^0-9A-Fa-fk-orx]", "") : string.replaceAll("\u00a7[^0-9a-fk-or]", "");
    }

    public static String getLastColors(String input) {
        String result = "";
        for (int i = input.length() - 1; i > 0; --i) {
            if (input.charAt(i - 1) != '\u00a7') continue;
            String color = String.valueOf(input.charAt(i - 1)) + input.charAt(i);
            if (i - 13 >= 0 && input.charAt(i - 12) == 'x' && input.charAt(i - 13) == '\u00a7') {
                color = input.substring(i - 13, i + 1);
                i -= 13;
            }
            if (!ChatColorUtils.isLegal(color)) continue;
            result = color + result;
            if (color.charAt(1) == 'x' || ChatColorUtils.isColor(ChatColor.getByChar((char)input.charAt(i))) || ChatColor.getByChar((char)input.charAt(i)).equals((Object)ChatColor.RESET)) break;
        }
        return result;
    }

    public static String getFirstColors(String input) {
        String result = "";
        boolean found = false;
        if (input.length() < 2) {
            return "";
        }
        String color = "";
        for (int i = 1; i < input.length(); ++i) {
            color = String.valueOf(input.charAt(i - 1)) + input.charAt(i);
            if (input.charAt(i - 1) == '\u00a7' && input.charAt(i) == 'x' && input.length() > i + 13) {
                color = input.substring(i - 1, i + 13);
                i += 13;
            }
            if (ChatColorUtils.isLegal(color)) {
                if (!found) {
                    found = true;
                    result = color;
                } else {
                    result = color.charAt(1) == 'x' || ChatColorUtils.isColor(ChatColor.getByChar((char)color.charAt(1))) ? color : result + color;
                }
                ++i;
                continue;
            }
            if (found) break;
        }
        return result;
    }

    public static boolean isColor(ChatColor color) {
        ArrayList<ChatColor> format = new ArrayList<ChatColor>();
        format.add(ChatColor.MAGIC);
        format.add(ChatColor.BOLD);
        format.add(ChatColor.ITALIC);
        format.add(ChatColor.UNDERLINE);
        format.add(ChatColor.STRIKETHROUGH);
        return !format.contains(color) && !color.equals((Object)ChatColor.RESET);
    }

    public static boolean isLegal(String color) {
        if (color.charAt(0) != '\u00a7') {
            return false;
        }
        if (color.matches("\u00a7[0-9a-fk-or]")) {
            return true;
        }
        return color.matches("\u00a7x\u00a7[0-9A-F]\u00a7[0-9A-F]\u00a7[0-9A-F]\u00a7[0-9A-F]\u00a7[0-9A-F]\u00a7[0-9A-F]");
    }

    public static String addColorToEachWord(String text, String leadingColor) {
        StringBuilder sb = new StringBuilder();
        text = leadingColor + text;
        do {
            int pos;
            pos = (pos = text.indexOf(" ") + 1) <= 0 ? text.length() : pos;
            String before = leadingColor + text.substring(0, pos);
            sb.append(before);
            text = text.substring(pos);
            leadingColor = ChatColorUtils.getLastColors(before);
        } while (text.length() > 0 && !text.equals(leadingColor));
        return sb.toString();
    }

    public static String hexToColorCode(String hex) {
        if ((hex = hex.toUpperCase()) == null) {
            return hex;
        }
        int pos = hex.indexOf("#");
        if (!hex.matches(validColorHex) || pos < 0 || hex.length() < pos + 7) {
            return "\u00a7x\u00a7F\u00a7F\u00a7F\u00a7F\u00a7F\u00a7F";
        }
        return "\u00a7x\u00a7" + hex.charAt(1) + "\u00a7" + hex.charAt(2) + "\u00a7" + hex.charAt(3) + "\u00a7" + hex.charAt(4) + "\u00a7" + hex.charAt(5) + "\u00a7" + hex.charAt(6);
    }

    public static String translatePluginColorFormatting(String text) {
        Matcher matcher;
        while ((matcher = colorFormating.matcher(text)).find()) {
            String foramtedColor = matcher.group().toLowerCase();
            int start = matcher.start();
            int pos = foramtedColor.indexOf("color");
            int absPos = text.indexOf("color", start);
            int end = matcher.end();
            if (pos < 0) continue;
            String colorCode = ChatColorUtils.hexToColorCode(foramtedColor.substring(pos + 6, pos + 13));
            StringBuilder sb = new StringBuilder(text);
            sb.insert(end, colorCode);
            sb.delete(absPos, absPos + 13);
            while (sb.charAt(absPos) == ',' || sb.charAt(absPos) == ' ') {
                sb.deleteCharAt(absPos);
            }
            while (sb.charAt(absPos - 1) == ',' || sb.charAt(absPos - 1) == ' ') {
                sb.deleteCharAt(absPos - 1);
                --absPos;
            }
            if (sb.charAt(absPos) == ']' && sb.charAt(absPos - 1) == '[') {
                sb.deleteCharAt(absPos - 1);
                sb.deleteCharAt(absPos - 1);
                if (absPos > 2 && sb.charAt(absPos - 2) == '\\' && sb.charAt(absPos - 3) == '\\') {
                    sb.deleteCharAt(absPos - 2);
                }
            }
            text = sb.toString();
        }
        while ((matcher = colorEscape.matcher(text)).find()) {
            StringBuilder sb = new StringBuilder(text);
            sb.deleteCharAt(matcher.start());
            text = sb.toString();
        }
        return text;
    }

    public static String translateAlternateColorCodes(char code, String text) {
        if (text == null) {
            return text;
        }
        if (text.length() < 2) {
            return text;
        }
        if (HoloMobHealth.version.isNewerOrEqualTo(MCVersion.V1_16)) {
            text = ChatColorUtils.translatePluginColorFormatting(text);
        }
        for (int i = 0; i < text.length() - 1; ++i) {
            if (text.charAt(i) != code) continue;
            if (text.charAt(i + 1) == 'x' && text.length() > i + 14) {
                String section = text.substring(i, i + 14);
                String translated = section.replace(code, '\u00a7');
                text = text.replace(section, translated);
                continue;
            }
            if (!colors.contains(Character.valueOf(text.charAt(i + 1)))) continue;
            StringBuilder sb = new StringBuilder(text);
            sb.setCharAt(i, '\u00a7');
            text = sb.toString();
        }
        return text;
    }

    static {
        colors.add(Character.valueOf('0'));
        colors.add(Character.valueOf('1'));
        colors.add(Character.valueOf('2'));
        colors.add(Character.valueOf('3'));
        colors.add(Character.valueOf('4'));
        colors.add(Character.valueOf('5'));
        colors.add(Character.valueOf('6'));
        colors.add(Character.valueOf('7'));
        colors.add(Character.valueOf('8'));
        colors.add(Character.valueOf('9'));
        colors.add(Character.valueOf('a'));
        colors.add(Character.valueOf('b'));
        colors.add(Character.valueOf('c'));
        colors.add(Character.valueOf('d'));
        colors.add(Character.valueOf('e'));
        colors.add(Character.valueOf('f'));
        colors.add(Character.valueOf('k'));
        colors.add(Character.valueOf('l'));
        colors.add(Character.valueOf('m'));
        colors.add(Character.valueOf('n'));
        colors.add(Character.valueOf('o'));
        colors.add(Character.valueOf('r'));
    }
}

