/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.utils.MCVersion;
import com.loohp.holomobhealth.utils.MythicMobsUtils;
import com.nisovin.shopkeepers.api.ShopkeepersAPI;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import de.Keyle.MyPet.api.entity.MyPet;
import de.Keyle.MyPet.api.entity.MyPetBukkitEntity;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;

public class CustomNameUtils {
    public static Component getMobCustomName(Entity entity) {
        Shopkeeper keeper;
        NPC npc;
        if (HoloMobHealth.mythicHook) {
            String customName = MythicMobsUtils.getMobCustomName(entity);
            Component vanillaCustomName = CustomNameUtils.getMinecraftCustomName(entity);
            if (HoloMobHealth.useMythicMobCustomNamesFirst) {
                return customName == null || customName.isEmpty() ? vanillaCustomName : LegacyComponentSerializer.legacySection().deserialize(customName);
            }
            return vanillaCustomName == null || PlainTextComponentSerializer.plainText().serialize(vanillaCustomName).isEmpty() ? LegacyComponentSerializer.legacySection().deserialize(customName) : vanillaCustomName;
        }
        if (HoloMobHealth.citizensHook && (npc = CitizensAPI.getNPCRegistry().getNPC(entity)) != null) {
            try {
                return LegacyComponentSerializer.legacySection().deserialize(npc.getFullName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (HoloMobHealth.shopkeepersHook && (keeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperByEntity(entity)) != null) {
            return LegacyComponentSerializer.legacySection().deserialize(keeper.getName());
        }
        if (HoloMobHealth.myPetHook && entity instanceof MyPetBukkitEntity) {
            MyPet mypet = ((MyPetBukkitEntity)entity).getMyPet();
            return LegacyComponentSerializer.legacySection().deserialize(mypet.getPetName());
        }
        Component bukkitCustomName = CustomNameUtils.getMinecraftCustomName(entity);
        if (bukkitCustomName == null || PlainTextComponentSerializer.plainText().serialize(bukkitCustomName).isEmpty()) {
            return null;
        }
        return bukkitCustomName;
    }

    private static Component getMinecraftCustomName(Entity entity) {
        if (HoloMobHealth.version.isNewerOrEqualTo(MCVersion.V1_13)) {
            return NMS.getInstance().getEntityName(entity);
        }
        return NMS.getInstance().getEntityCustomName(entity);
    }
}

