/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomStringUtils {
    public static String replaceFromTo(String stringToReplace, int from, int to, String withString) {
        StringBuilder sb = new StringBuilder(stringToReplace);
        sb.delete(from, to);
        sb.insert(from, withString);
        return sb.toString();
    }

    public static List<String> getAllMatches(String regex, String str) {
        LinkedList<String> allMatches = new LinkedList<String>();
        Matcher m = Pattern.compile(regex).matcher(str);
        while (m.find()) {
            allMatches.add(m.group());
        }
        return allMatches;
    }

    public static int ordinalIndexOf(String str, String substr, int n) {
        int pos = str.indexOf(substr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(substr, pos + 1);
        }
        return pos;
    }

    public static int occurrencesOfSubstring(String str, String findStr) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = str.indexOf(findStr, lastIndex)) == -1) continue;
            ++count;
            lastIndex += findStr.length();
        }
        return count;
    }

    public static double similarity(String s1, String s2) {
        int longerLength;
        String longer = s1;
        String shorter = s2;
        if (s1.length() < s2.length()) {
            longer = s2;
            shorter = s1;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0;
        }
        return (double)(longerLength - CustomStringUtils.editDistance(longer, shorter)) / (double)longerLength;
    }

    public static int editDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }

    public static String escapeMetaCharacters(String inputString) {
        String[] metaCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", ".", "*", "+", "?", "|", "<", ">", "-", "&", "%"};
        for (int i = 0; i < metaCharacters.length; ++i) {
            if (!inputString.contains(metaCharacters[i])) continue;
            inputString = inputString.replace(metaCharacters[i], "\\" + metaCharacters[i]);
        }
        return inputString;
    }

    public static String[] splitStringEvery(String s, int interval) {
        int arrayLength = (int)Math.ceil((double)s.length() / (double)interval);
        String[] result = new String[arrayLength];
        int j = 0;
        int lastIndex = result.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            result[i] = s.substring(j, j + interval);
            j += interval;
        }
        result[lastIndex] = s.substring(j);
        return result;
    }

    public static String getIgnoreColorCodeRegex(String input) {
        return input.replaceAll("(?<!^)(?=(?<!\u00a7.).)(?=(?<!\u00a7).)(?=(?<!\\\\).)", "(\u00a7.)*?");
    }

    public static String insert(String bag, String marble, int index) {
        String bagBegin = bag.substring(0, index);
        String bagEnd = bag.substring(index);
        return bagBegin + marble + bagEnd;
    }
}

