/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.nms;

import com.loohp.imageframe.nms.NMSWrapper;
import com.loohp.imageframe.objectholders.CombinedMapItemInfo;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.utils.ReflectionUtils;
import com.loohp.imageframe.utils.UUIDUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R3.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_21_4
extends NMSWrapper {
    private final Field craftMapViewWorldMapField;
    private final Field persistentIdCountsUsedAuxIdsField;

    public V1_21_4() {
        try {
            this.craftMapViewWorldMapField = CraftMapView.class.getDeclaredField("worldMap");
            this.persistentIdCountsUsedAuxIdsField = ReflectionUtils.findDeclaredField(PersistentIdCounts.class, Object2IntMap.class, (String[])new String[]{"usedAuxIds", "b"});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public WorldMap getWorldMap(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewWorldMapField.setAccessible(true);
            return (WorldMap)this.craftMapViewWorldMapField.get(craftMapView);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setColors(MapView mapView, byte[] colors) {
        if (colors.length != 16384) {
            throw new IllegalArgumentException("colors array length must be 16384");
        }
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        nmsWorldMap.g = colors;
    }

    public Set<Player> getViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.p;
        return humansMap.keySet().stream().map(e -> (Player)e.getBukkitEntity()).collect(Collectors.toSet());
    }

    public MapIcon toNMSMapIcon(MapCursor mapCursor) {
        Holder<MapDecorationType> decorationTypeHolder = this.toNMSMapIconType(mapCursor.getType());
        IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)mapCursor.getCaption());
        return new MapIcon(decorationTypeHolder, mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), Optional.ofNullable(iChat));
    }

    public Holder<MapDecorationType> toNMSMapIconType(MapCursor.Type type) {
        return CraftMapCursor.CraftType.bukkitToMinecraftHolder((MapCursor.Type)type);
    }

    public boolean isRenderOnFrame(MapCursor.Type type) {
        Holder<MapDecorationType> decorationTypeHolder = this.toNMSMapIconType(type);
        return ((MapDecorationType)decorationTypeHolder.a()).c();
    }

    public MapView getMapOrCreateMissing(World world, int id) {
        try {
            MapView mapView = Bukkit.getMap((int)id);
            if (mapView != null) {
                return mapView;
            }
            this.persistentIdCountsUsedAuxIdsField.setAccessible(true);
            Location spawnLocation = world.getSpawnLocation();
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            ResourceKey worldTypeKey = worldServer.ai();
            WorldMap worldMap = WorldMap.a((double)spawnLocation.getX(), (double)spawnLocation.getZ(), (byte)3, (boolean)false, (boolean)false, (ResourceKey)worldTypeKey);
            MapId mapId = new MapId(id);
            worldServer.a(mapId, worldMap);
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.p().J().w().a(PersistentIdCounts.a(), "idcounts");
            Object2IntMap usedAuxIds = (Object2IntMap)this.persistentIdCountsUsedAuxIdsField.get(persistentIdCounts);
            int freeAuxValue = usedAuxIds.getInt((Object)"map");
            if (freeAuxValue < id) {
                usedAuxIds.put((Object)"map", id);
                persistentIdCounts.c();
            }
            return Bukkit.getMap((int)id);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public MutablePair<byte[], ArrayList<MapCursor>> bukkitRenderMap(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        RenderData renderData = craftMapView.render(craftPlayer);
        return new MutablePair((Object)renderData.buffer, (Object)renderData.cursors);
    }

    public Set<Player> getEntityTrackers(Entity entity) {
        return new HashSet<Player>(entity.getTrackedBy());
    }

    public PacketPlayOutMap createMapPacket(int mapId, byte[] colors, Collection<MapCursor> cursors) {
        List mapIcons = cursors == null ? null : cursors.stream().map(this::toNMSMapIcon).collect(Collectors.toList());
        WorldMap.c c2 = colors == null ? null : new WorldMap.c(0, 0, 128, 128, colors);
        return new PacketPlayOutMap(new MapId(mapId), 0, false, Optional.ofNullable(mapIcons), Optional.ofNullable(c2));
    }

    public PacketPlayOutEntityMetadata createItemFrameItemChangePacket(int entityId, ItemStack itemStack) {
        List<DataWatcher.c> dataWatchers = Collections.singletonList(DataWatcher.c.a((DataWatcherObject)EntityItemFrame.e, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
        return new PacketPlayOutEntityMetadata(entityId, dataWatchers);
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().f.sendPacket((Packet)packet);
    }

    public CombinedMapItemInfo getCombinedMapItemInfo(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        CustomData customData = (CustomData)nmsItemStack.a(DataComponents.b);
        if (customData == null) {
            return null;
        }
        NBTTagCompound tag = customData.d();
        if (!tag.e("CombinedImageMap")) {
            return null;
        }
        int imageMapIndex = tag.h("CombinedImageMap");
        if (!tag.e("CombinedImageMapPlacementUUID") || !tag.e("CombinedImageMapPlacementYaw")) {
            return new CombinedMapItemInfo(imageMapIndex);
        }
        float yaw = tag.j("CombinedImageMapPlacementYaw");
        UUID uuid = UUIDUtils.fromIntArray((int[])tag.n("CombinedImageMapPlacementUUID"));
        return new CombinedMapItemInfo(imageMapIndex, new CombinedMapItemInfo.PlacementInfo(yaw, uuid));
    }

    public ItemStack withCombinedMapItemInfo(ItemStack itemStack, CombinedMapItemInfo combinedMapItemInfo) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        CustomData customData = (CustomData)nmsItemStack.a(DataComponents.b, (Object)CustomData.a);
        NBTTagCompound tag = customData.d();
        tag.a("CombinedImageMap", combinedMapItemInfo.getImageMapIndex());
        if (combinedMapItemInfo.hasPlacement()) {
            CombinedMapItemInfo.PlacementInfo placement = combinedMapItemInfo.getPlacement();
            tag.a("CombinedImageMapPlacementYaw", placement.getYaw());
            tag.a("CombinedImageMapPlacementUUID", UUIDUtils.toIntArray((UUID)placement.getUniqueId()));
        }
        nmsItemStack.b(DataComponentPatch.a().a(DataComponents.b, (Object)CustomData.a((NBTTagCompound)tag)).a());
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
    }
}

