/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.nms;

import com.google.common.collect.Collections2;
import com.loohp.imageframe.nms.NMSWrapper;
import com.loohp.imageframe.objectholders.CombinedMapItemInfo;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.utils.ReflectionUtils;
import com.loohp.imageframe.utils.UUIDUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_21_9
extends NMSWrapper {
    private final Field nmsEntityByteDataWatcherField;
    private final Field craftMapViewWorldMapField;
    private final Field persistentIdCountsLastMapIdField;
    private final Field renderDataCursorsField;

    public V1_21_9() {
        try {
            Field persistentIdCountsLastMapIdField0;
            this.nmsEntityByteDataWatcherField = ReflectionUtils.findDeclaredField(net.minecraft.world.entity.Entity.class, DataWatcherObject.class, (String[])new String[]{"DATA_SHARED_FLAGS_ID", "aA"});
            this.craftMapViewWorldMapField = CraftMapView.class.getDeclaredField("worldMap");
            try {
                persistentIdCountsLastMapIdField0 = ReflectionUtils.findDeclaredField(PersistentIdCounts.class, Integer.TYPE, (String[])new String[]{"lastMapId", "d"});
            }
            catch (NoSuchFieldException e) {
                persistentIdCountsLastMapIdField0 = ReflectionUtils.findDeclaredField(PersistentIdCounts.class, AtomicInteger.class, (String[])new String[]{"lastMapId", "d"});
            }
            this.persistentIdCountsLastMapIdField = persistentIdCountsLastMapIdField0;
            this.renderDataCursorsField = RenderData.class.getField("cursors");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public WorldMap getWorldMap(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewWorldMapField.setAccessible(true);
            return (WorldMap)this.craftMapViewWorldMapField.get(craftMapView);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setColors(MapView mapView, byte[] colors) {
        if (colors.length != 16384) {
            throw new IllegalArgumentException("colors array length must be 16384");
        }
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        nmsWorldMap.h = colors;
    }

    public Collection<Player> getViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.q;
        return Collections2.transform(humansMap.keySet(), e -> (Player)e.getBukkitEntity());
    }

    public boolean hasViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.q;
        return !humansMap.isEmpty();
    }

    public MapIcon toNMSMapIcon(MapCursor mapCursor) {
        Holder<MapDecorationType> decorationTypeHolder = this.toNMSMapIconType(mapCursor.getType());
        IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)mapCursor.getCaption());
        return new MapIcon(decorationTypeHolder, mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), Optional.ofNullable(iChat));
    }

    public Holder<MapDecorationType> toNMSMapIconType(MapCursor.Type type) {
        return CraftMapCursor.CraftType.bukkitToMinecraftHolder((MapCursor.Type)type);
    }

    public boolean isRenderOnFrame(MapCursor.Type type) {
        Holder<MapDecorationType> decorationTypeHolder = this.toNMSMapIconType(type);
        return ((MapDecorationType)decorationTypeHolder.a()).c();
    }

    public int getNextAvailableMapId(World world) {
        try {
            this.persistentIdCountsLastMapIdField.setAccessible(true);
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.q().O().y().a(PersistentIdCounts.b);
            if (this.persistentIdCountsLastMapIdField.getType().equals(AtomicInteger.class)) {
                AtomicInteger atomicInteger = (AtomicInteger)this.persistentIdCountsLastMapIdField.get(persistentIdCounts);
                return atomicInteger.get() + 1;
            }
            return this.persistentIdCountsLastMapIdField.getInt(persistentIdCounts) + 1;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public MapView getMapOrCreateMissing(World world, int id) {
        try {
            MapView mapView = Bukkit.getMap((int)id);
            if (mapView != null) {
                return mapView;
            }
            this.persistentIdCountsLastMapIdField.setAccessible(true);
            Location spawnLocation = world.getSpawnLocation();
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            ResourceKey worldTypeKey = worldServer.al();
            WorldMap worldMap = WorldMap.a((double)spawnLocation.getX(), (double)spawnLocation.getZ(), (byte)3, (boolean)false, (boolean)false, (ResourceKey)worldTypeKey);
            MapId mapId = new MapId(id);
            worldServer.a(mapId, worldMap);
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.q().O().y().a(PersistentIdCounts.b);
            if (this.persistentIdCountsLastMapIdField.getType().equals(AtomicInteger.class)) {
                AtomicInteger atomicInteger = (AtomicInteger)this.persistentIdCountsLastMapIdField.get(persistentIdCounts);
                atomicInteger.getAndUpdate(lastMapId -> Math.max(lastMapId, id));
            } else {
                int lastMapId2 = this.persistentIdCountsLastMapIdField.getInt(persistentIdCounts);
                this.persistentIdCountsLastMapIdField.setInt(persistentIdCounts, Math.max(lastMapId2, id));
            }
            persistentIdCounts.t();
            return Bukkit.getMap((int)id);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public MutablePair<byte[], List<MapCursor>> bukkitRenderMap(MapView mapView, Player player) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            CraftPlayer craftPlayer = (CraftPlayer)player;
            RenderData renderData = craftMapView.render(craftPlayer);
            return new MutablePair((Object)renderData.buffer, (Object)((List)this.renderDataCursorsField.get(renderData)));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Player> getEntityTrackers(Entity entity) {
        return new HashSet<Player>(entity.getTrackedBy());
    }

    public PacketPlayOutMap createMapPacket(int mapId, byte[] colors, Collection<MapCursor> cursors) {
        List mapIcons = cursors == null ? null : cursors.stream().map(this::toNMSMapIcon).collect(Collectors.toList());
        WorldMap.c c2 = colors == null ? null : new WorldMap.c(0, 0, 128, 128, colors);
        return new PacketPlayOutMap(new MapId(mapId), 0, false, Optional.ofNullable(mapIcons), Optional.ofNullable(c2));
    }

    public PacketPlayOutEntityMetadata createItemFrameItemChangePacket(int entityId, ItemStack itemStack) {
        List<DataWatcher.c> dataWatchers = Collections.singletonList(DataWatcher.c.a((DataWatcherObject)EntityItemFrame.c, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
        return new PacketPlayOutEntityMetadata(entityId, dataWatchers);
    }

    public Object createEntityFlagsPacket(Entity entity, Boolean invisible, Boolean glowing) {
        try {
            int entityId = entity.getEntityId();
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            this.nmsEntityByteDataWatcherField.setAccessible(true);
            DataWatcher watcher = nmsEntity.aC();
            DataWatcherObject byteField = (DataWatcherObject)this.nmsEntityByteDataWatcherField.get(null);
            byte value = (Byte)watcher.a(byteField);
            if (invisible != null) {
                value = invisible != false ? (byte)(value | 0x20) : (byte)(value & 0xFFFFFFDF);
            }
            if (glowing != null) {
                value = glowing != false ? (byte)(value | 0x40) : (byte)(value & 0xFFFFFFBF);
            }
            List<DataWatcher.c> dataWatchers = Collections.singletonList(DataWatcher.c.a((DataWatcherObject)byteField, (Object)value));
            return new PacketPlayOutEntityMetadata(entityId, dataWatchers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().g.b((Packet)packet);
    }

    public CombinedMapItemInfo getCombinedMapItemInfo(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        CustomData customData = (CustomData)nmsItemStack.a(DataComponents.b);
        if (customData == null) {
            return null;
        }
        NBTTagCompound tag = customData.b();
        if (!tag.b("CombinedImageMap")) {
            return null;
        }
        int imageMapIndex = tag.b("CombinedImageMap", -1);
        if (!tag.b("CombinedImageMapPlacementUUID") || !tag.b("CombinedImageMapPlacementYaw")) {
            return new CombinedMapItemInfo(imageMapIndex);
        }
        float yaw = tag.b("CombinedImageMapPlacementYaw", 0.0f);
        UUID uuid = UUIDUtils.fromIntArray((int[])((int[])tag.k("CombinedImageMapPlacementUUID").get()));
        return new CombinedMapItemInfo(imageMapIndex, new CombinedMapItemInfo.PlacementInfo(yaw, uuid));
    }

    public ItemStack withCombinedMapItemInfo(ItemStack itemStack, CombinedMapItemInfo combinedMapItemInfo) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        CustomData customData = (CustomData)nmsItemStack.a(DataComponents.b, (Object)CustomData.a);
        NBTTagCompound tag = customData.b();
        tag.a("CombinedImageMap", combinedMapItemInfo.getImageMapIndex());
        if (combinedMapItemInfo.hasPlacement()) {
            CombinedMapItemInfo.PlacementInfo placement = combinedMapItemInfo.getPlacement();
            tag.a("CombinedImageMapPlacementYaw", placement.getYaw());
            tag.a("CombinedImageMapPlacementUUID", UUIDUtils.toIntArray((UUID)placement.getUniqueId()));
        }
        nmsItemStack.b(DataComponentPatch.a().a(DataComponents.b, (Object)CustomData.a((NBTTagCompound)tag)).a());
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public ItemStack withInvisibleItemFrameMeta(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return itemStack;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        ItemLore itemLore = (ItemLore)nmsItemStack.a(DataComponents.j, (Object)ItemLore.a);
        ArrayList<IChatMutableComponent> loreLines = new ArrayList<IChatMutableComponent>(itemLore.a());
        loreLines.add(0, IChatBaseComponent.c((String)"effect.minecraft.invisibility").c(ChatModifier.a.c(EnumChatFormat.h).b(Boolean.valueOf(false))));
        nmsItemStack.b(DataComponentPatch.a().a(DataComponents.j, (Object)new ItemLore(loreLines)).a());
        CraftItemStack modified = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
        ItemMeta itemMeta = modified.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        modified.setItemMeta(itemMeta);
        return modified;
    }

    public List<ItemStack> giveItems(Player player, List<ItemStack> itemStacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory inventory = nmsPlayer.gB();
        for (ItemStack itemStack : itemStacks) {
            net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            boolean added = inventory.g(nmsItemStack);
            if (added && nmsItemStack.f()) continue;
            leftovers.add(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
        }
        nmsPlayer.cl.d();
        return leftovers;
    }

    public Key getWorldNamespacedKey(World world) {
        NamespacedKey key = world.getKey();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }
}

