/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.migration;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.file.YamlConfiguration;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.serialization.ConfigurationSerializable;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.serialization.ConfigurationSerialization;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.serialization.SerializableAs;
import com.loohp.imageframe.migration.ExternalPluginMigration;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.NonUpdatableStaticImageMap;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class ImageMapMigration
implements ExternalPluginMigration {
    public static final String PLUGIN_NAME = "ImageMaps";

    @Override
    public String externalPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requirePlayer() {
        return true;
    }

    @Override
    public void migrate(UUID owner) {
        if (Bukkit.getPluginManager().isPluginEnabled(PLUGIN_NAME)) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] ImageMaps must be disabled for migration to begin");
            return;
        }
        File migrationMarker = new File(ImageFrame.plugin.getDataFolder().getParent() + "/ImageMaps/imageframe-migrated.bin");
        if (migrationMarker.exists()) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[ImageFrame] ImageMaps data already marked as migrated");
            return;
        }
        File folder = new File(ImageFrame.plugin.getDataFolder().getParent() + "/ImageMaps/images");
        if (!folder.exists() || !folder.isDirectory()) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] ImageMaps plugin data folder not found");
            return;
        }
        try {
            ConfigurationSerialization.registerClass(ImageMap.class);
            YamlConfiguration mapConfig = YamlConfiguration.loadConfiguration(new File(ImageFrame.plugin.getDataFolder().getParent() + "/ImageMaps/maps.yml"));
            World world = MapUtils.getMainWorld();
            for (Map.Entry<String, Object> entry : mapConfig.getConfigurationSection("maps").getValues(false).entrySet()) {
                String key = entry.getKey();
                try {
                    int mapId = Integer.parseInt(key);
                    ImageMap data = (ImageMap)entry.getValue();
                    String fileName = data.getFilename();
                    BufferedImage[] images = new BufferedImage[]{MapUtils.getSubImage(ImageIO.read(new File(folder, fileName)), data.getX(), data.getY())};
                    String name = "ImageMaps_" + mapId;
                    NonUpdatableStaticImageMap imageMap = NonUpdatableStaticImageMap.create(ImageFrame.imageMapManager, name, images, Collections.singletonList(mapId), 1, 1, DitheringType.NEAREST_COLOR, owner).get();
                    ImageFrame.imageMapManager.addMap(imageMap);
                    Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Migrated ImageMaps " + key + " to " + name);
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to migrate ImageMaps " + key);
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            migrationMarker.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] ImageMaps migration complete!");
    }

    @SerializableAs(value="ImageMaps.Map")
    public static class ImageMap
    implements ConfigurationSerializable {
        private String filename;
        private int x;
        private int y;
        private double scale;

        public ImageMap(String filename, int x, int y, double scale) {
            this.filename = filename;
            this.x = x;
            this.y = y;
            this.scale = scale;
        }

        public ImageMap(Map<?, ?> map) {
            this.filename = map.get("image").toString();
            this.x = (Integer)map.get("x");
            this.y = (Integer)map.get("y");
            this.scale = (Double)map.get("scale");
        }

        @Override
        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", this.filename);
            map.put("x", this.x);
            map.put("y", this.y);
            map.put("scale", this.scale);
            return map;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public double getScale() {
            return this.scale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            long temp = Double.doubleToLongBits(this.scale);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ImageMap)) {
                return false;
            }
            ImageMap other = (ImageMap)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            if (Double.doubleToLongBits(this.scale) != Double.doubleToLongBits(other.scale)) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }
    }
}

