/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.hooks.viaversion.ViaHook;
import com.loohp.imageframe.nms.NMS;
import com.loohp.imageframe.objectholders.BooleanState;
import com.loohp.imageframe.objectholders.IFPlayerPreference;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.MapMarkerEditManager;
import com.loohp.imageframe.utils.FakeItemUtils;
import com.loohp.imageframe.utils.MapUtils;
import com.loohp.imageframe.utils.ModernEventsUtils;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.platform.folia.FoliaScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class AnimatedFakeMapManager
implements Listener,
Runnable {
    private final Map<UUID, TrackedItemFrameData> itemFrames = new ConcurrentHashMap<UUID, TrackedItemFrameData>();
    private final Map<Player, Set<Integer>> knownMapIds = new ConcurrentHashMap<Player, Set<Integer>>();
    private final Map<Player, Set<Integer>> pendingKnownMapIds = new ConcurrentHashMap<Player, Set<Integer>>();

    public AnimatedFakeMapManager() {
        Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, this, 0L, 1L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
        if (ModernEventsUtils.modernEventsExists()) {
            Bukkit.getPluginManager().registerEvents((Listener)new ModernEvents(), (Plugin)ImageFrame.plugin);
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                this.handleEntity(entity);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.knownMapIds.put(player, ConcurrentHashMap.newKeySet());
            this.pendingKnownMapIds.put(player, ConcurrentHashMap.newKeySet());
        }
    }

    private Map<UUID, CompletableFuture<ItemFrameInfo>> collectItemFramesInfo(boolean async) {
        boolean isFolia = Scheduler.getPlatform() instanceof FoliaScheduler;
        HashMap<UUID, CompletableFuture<ItemFrameInfo>> futures = new HashMap<UUID, CompletableFuture<ItemFrameInfo>>();
        for (Map.Entry<UUID, TrackedItemFrameData> entry : this.itemFrames.entrySet()) {
            UUID uuid = entry.getKey();
            ItemFrame itemFrame = entry.getValue().getItemFrame();
            CompletableFuture future = new CompletableFuture();
            Runnable task = () -> {
                try {
                    if (itemFrame.isValid()) {
                        Set<Player> trackedPlayers;
                        if (isFolia) {
                            try {
                                trackedPlayers = itemFrame.getTrackedPlayers();
                            }
                            catch (Throwable e) {
                                trackedPlayers = NMS.getInstance().getEntityTrackers((Entity)itemFrame);
                            }
                        } else {
                            trackedPlayers = NMS.getInstance().getEntityTrackers((Entity)itemFrame);
                        }
                        future.complete(new ItemFrameInfo(itemFrame.getEntityId(), trackedPlayers, itemFrame.getItem()));
                    } else {
                        future.complete(null);
                    }
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            };
            if (async && !isFolia) {
                task.run();
            } else {
                Scheduler.executeOrScheduleSync((Plugin)ImageFrame.plugin, task, (Entity)itemFrame);
            }
            futures.put(uuid, future);
        }
        return futures;
    }

    @Override
    public void run() {
        Map<UUID, CompletableFuture<ItemFrameInfo>> entityTrackers = this.collectItemFramesInfo(!ImageFrame.handleAnimatedMapsOnMainThread);
        HashMap updateData = new HashMap();
        long deadline = System.currentTimeMillis() + 2000L;
        for (Map.Entry<UUID, CompletableFuture<ItemFrameInfo>> entry : entityTrackers.entrySet()) {
            FakeItemUtils.ItemFrameUpdateData itemFrameUpdateData;
            Object map;
            ItemFrameInfo frameInfo;
            UUID uuid = entry.getKey();
            try {
                frameInfo = entry.getValue().get(Math.max(0L, deadline - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                frameInfo = null;
            }
            if (frameInfo == null) {
                this.itemFrames.remove(uuid);
                continue;
            }
            int entityId = frameInfo.getEntityId();
            Set<Player> players = frameInfo.getTrackedPlayers();
            ItemStack itemStack = frameInfo.getItemStack();
            TrackedItemFrameData data = this.itemFrames.get(uuid);
            if (data == null) continue;
            AnimationData animationData = data.getAnimationData();
            MapView mapView = MapUtils.getItemMapView(itemStack);
            if (mapView == null) {
                data.setAnimationData(AnimationData.EMPTY);
                continue;
            }
            if (animationData.isEmpty() || !animationData.getMapView().equals((Object)mapView)) {
                map = ImageFrame.imageMapManager.getFromMapView(mapView);
                if (map == null || !((ImageMap)map).requiresAnimationService()) {
                    if (animationData.isEmpty()) continue;
                    data.setAnimationData(AnimationData.EMPTY);
                    continue;
                }
                animationData = new AnimationData((ImageMap)map, mapView, ((ImageMap)map).getMapViews().indexOf(mapView));
                data.setAnimationData(animationData);
            } else if (!animationData.isEmpty() && !animationData.getImageMap().isValid()) {
                map = players.iterator();
                while (map.hasNext()) {
                    Player player = (Player)map.next();
                    FakeItemUtils.sendFakeItemChange(player, entityId, itemStack);
                }
                data.setAnimationData(AnimationData.EMPTY);
                continue;
            }
            ImageMap imageMap = animationData.getImageMap();
            if (!imageMap.requiresAnimationService()) {
                data.setAnimationData(AnimationData.EMPTY);
                continue;
            }
            int index = animationData.getIndex();
            int currentPosition = imageMap.getCurrentPositionInSequenceWithOffset();
            int mapId = imageMap.getAnimationFakeMapId(currentPosition, index, imageMap.isAnimationPaused());
            if (mapId < 0) continue;
            HashSet<Player> requiresSending = new HashSet<Player>();
            HashSet<Player> needReset = new HashSet<Player>();
            Iterator itr = players.iterator();
            while (itr.hasNext()) {
                Set<Integer> fakeMapIds;
                Player player = (Player)itr.next();
                MapMarkerEditManager.MapMarkerEditData edit = ImageFrame.mapMarkerEditManager.getActiveEditing(player);
                if (edit != null && Objects.equals(edit.getImageMap(), imageMap)) {
                    needReset.add(player);
                    itr.remove();
                    continue;
                }
                Set<Integer> knownIds = this.knownMapIds.get(player);
                Set<Integer> pendingKnownIds = this.pendingKnownMapIds.get(player);
                if (knownIds == null || knownIds.contains(mapId)) continue;
                if (pendingKnownIds != null && !pendingKnownIds.contains(mapId) && (fakeMapIds = imageMap.getFakeMapIds()) != null) {
                    pendingKnownIds.addAll(fakeMapIds);
                    requiresSending.add(player);
                }
                itr.remove();
            }
            if (!requiresSending.isEmpty()) {
                imageMap.sendAnimationFakeMaps(requiresSending, (p, i, r) -> {
                    Set<Integer> knownIds;
                    Set<Integer> pendingKnownIds = this.pendingKnownMapIds.get(p);
                    if (pendingKnownIds != null && pendingKnownIds.remove(i) && r && (knownIds = this.knownMapIds.get(p)) != null) {
                        knownIds.add(i);
                    }
                });
            }
            if (!needReset.isEmpty()) {
                itemFrameUpdateData = new FakeItemUtils.ItemFrameUpdateData(entityId, itemStack, mapView.getId(), mapView, currentPosition);
                needReset.forEach(p -> updateData.computeIfAbsent(p, k -> new ArrayList()).add(itemFrameUpdateData));
            }
            itemFrameUpdateData = new FakeItemUtils.ItemFrameUpdateData(entityId, this.getMapItem(mapId), mapView.getId(), mapView, currentPosition);
            players.forEach(p -> updateData.computeIfAbsent(p, k -> new ArrayList()).add(itemFrameUpdateData));
        }
        HashMap<Player, List> sendingTasks = new HashMap<Player, List>();
        for (Map.Entry entry : updateData.entrySet()) {
            Player player = (Player)entry.getKey();
            if (!ImageFrame.ifPlayerManager.getIFPlayer(player.getUniqueId()).getPreference(IFPlayerPreference.VIEW_ANIMATED_MAPS, BooleanState.class).getCalculatedValue(() -> ImageFrame.getPreferenceUnsetValue(player, IFPlayerPreference.VIEW_ANIMATED_MAPS).getRawValue(true))) continue;
            if (ImageFrame.viaHook && ViaHook.isPlayerLegacy(player)) {
                if (ImageFrame.viaDisableSmoothAnimationForLegacyPlayers) continue;
                List list = (List)entry.getValue();
                for (FakeItemUtils.ItemFrameUpdateData data : list) {
                    sendingTasks.computeIfAbsent(player, k -> new ArrayList()).add(() -> MapUtils.sendImageMap(data.getRealMapId(), data.getMapView(), data.getCurrentPosition(), Collections.singleton(player), true));
                }
                continue;
            }
            sendingTasks.computeIfAbsent(player, k -> new ArrayList()).add(() -> FakeItemUtils.sendFakeItemChange(player, (List)entry.getValue()));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            ImageMap offHandMap;
            ImageMap mainHandMap;
            if (!ImageFrame.ifPlayerManager.getIFPlayer(player.getUniqueId()).getPreference(IFPlayerPreference.VIEW_ANIMATED_MAPS, BooleanState.class).getCalculatedValue(() -> ImageFrame.getPreferenceUnsetValue(player, IFPlayerPreference.VIEW_ANIMATED_MAPS).getRawValue(true))) continue;
            ItemStack mainhand = player.getEquipment().getItemInMainHand();
            ItemStack offhand = player.getEquipment().getItemInOffHand();
            MapView mainHandView = MapUtils.getItemMapView(mainhand);
            MapView offhandView = MapUtils.getItemMapView(offhand);
            if (mainHandView != null && (mainHandMap = ImageFrame.imageMapManager.getFromMapView(mainHandView)) != null && mainHandMap.requiresAnimationService()) {
                sendingTasks.computeIfAbsent(player, k -> new ArrayList()).add(() -> mainHandMap.send(player));
            }
            if (offhandView == null || offhandView.equals((Object)mainHandView) || (offHandMap = ImageFrame.imageMapManager.getFromMapView(offhandView)) == null || !offHandMap.requiresAnimationService()) continue;
            sendingTasks.computeIfAbsent(player, k -> new ArrayList()).add(() -> offHandMap.send(player));
        }
        if (ImageFrame.sendAnimatedMapsOnMainThread) {
            for (Map.Entry entry : sendingTasks.entrySet()) {
                Scheduler.runTask((Plugin)ImageFrame.plugin, () -> ((List)entry.getValue()).forEach(Runnable::run), (Entity)entry.getKey());
            }
        } else {
            sendingTasks.values().forEach(l -> l.forEach(Runnable::run));
        }
    }

    private ItemStack getMapItem(int mapId) {
        ItemStack itemStack = new ItemStack(Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)itemStack.getItemMeta();
        mapMeta.setMapId(mapId);
        itemStack.setItemMeta((ItemMeta)mapMeta);
        return itemStack;
    }

    private void handleEntity(Entity entity) {
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        UUID uuid = itemFrame.getUniqueId();
        if (this.itemFrames.containsKey(uuid)) {
            return;
        }
        MapView mapView = MapUtils.getItemMapView(itemFrame.getItem());
        if (mapView == null) {
            this.itemFrames.put(uuid, new TrackedItemFrameData(itemFrame, AnimationData.EMPTY));
            return;
        }
        ImageMap map = ImageFrame.imageMapManager.getFromMapView(mapView);
        if (map == null || !map.requiresAnimationService()) {
            this.itemFrames.put(uuid, new TrackedItemFrameData(itemFrame, AnimationData.EMPTY));
            return;
        }
        this.itemFrames.put(uuid, new TrackedItemFrameData(itemFrame, new AnimationData(map, mapView, map.getMapViews().indexOf(mapView))));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        Scheduler.executeOrScheduleSync((Plugin)ImageFrame.plugin, () -> {
            for (Entity entity : chunk.getEntities()) {
                this.handleEntity(entity);
            }
        }, chunk);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        this.handleEntity((Entity)event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        this.handleEntity(event.getRightClicked());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> {
            if (player.isOnline()) {
                this.knownMapIds.put(player, ConcurrentHashMap.newKeySet());
                this.pendingKnownMapIds.put(player, ConcurrentHashMap.newKeySet());
            }
        }, 20L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.knownMapIds.remove(player);
        this.pendingKnownMapIds.remove(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemFrame) {
            UUID uuid = entity.getUniqueId();
            Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                TrackedItemFrameData data = this.itemFrames.remove(uuid);
                if (data != null) {
                    this.itemFrames.put(uuid, data);
                }
            });
        }
    }

    @EventHandler
    public void onImageMapUpdate(ImageMapUpdatedEvent event) {
        ImageMap imageMap = event.getImageMap();
        if (!imageMap.requiresAnimationService()) {
            return;
        }
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
            Set<Integer> ids = imageMap.getFakeMapIds();
            if (ids != null) {
                for (Set<Integer> knownIds : this.knownMapIds.values()) {
                    knownIds.removeAll(ids);
                }
                for (Set<Integer> pendingKnownIds : this.pendingKnownMapIds.values()) {
                    pendingKnownIds.removeAll(ids);
                }
            }
        });
    }

    public class ModernEvents
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onEntityLoad(EntitiesLoadEvent event) {
            for (Entity entity : event.getEntities()) {
                AnimatedFakeMapManager.this.handleEntity(entity);
            }
        }
    }

    public static class TrackedItemFrameData {
        private final ItemFrame itemFrame;
        private AnimationData animationData;

        public TrackedItemFrameData(ItemFrame itemFrame, AnimationData animationData) {
            this.itemFrame = itemFrame;
            this.animationData = animationData;
        }

        public ItemFrame getItemFrame() {
            return this.itemFrame;
        }

        public AnimationData getAnimationData() {
            return this.animationData;
        }

        public void setAnimationData(AnimationData animationData) {
            this.animationData = animationData;
        }
    }

    public static class ItemFrameInfo {
        private final int entityId;
        private final Set<Player> trackedPlayers;
        private final ItemStack itemStack;

        public ItemFrameInfo(int entityId, Set<Player> trackedPlayers, ItemStack itemStack) {
            this.entityId = entityId;
            this.trackedPlayers = trackedPlayers;
            this.itemStack = itemStack;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public Set<Player> getTrackedPlayers() {
            return this.trackedPlayers;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }

    public static class AnimationData {
        public static final AnimationData EMPTY = new AnimationData(null, null, -1);
        private final ImageMap imageMap;
        private final MapView mapView;
        private final int index;

        public AnimationData(ImageMap imageMap, MapView mapView, int index) {
            this.imageMap = imageMap;
            this.mapView = mapView;
            this.index = index;
        }

        public boolean isEmpty() {
            return this.imageMap == null;
        }

        public ImageMap getImageMap() {
            return this.imageMap;
        }

        public MapView getMapView() {
            return this.mapView;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

