/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.loohp.imageframe.libs.com.madgag.gif.fmsware.GifDecoder;
import com.loohp.imageframe.utils.SizeLimitedByteArrayOutputStream;
import com.loohp.imageframe.utils.ThrowingSupplier;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.plugin.Plugin;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GifReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<List<ImageFrame>> readGif(InputStream stream, long sizeLimit) throws IOException {
        SizeLimitedByteArrayOutputStream buffer = new SizeLimitedByteArrayOutputStream(sizeLimit);
        try {
            int nRead;
            byte[] data = new byte[4096];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                ((ByteArrayOutputStream)buffer).write(data, 0, nRead);
            }
        }
        finally {
            stream.close();
        }
        byte[] targetArray = buffer.toByteArray();
        CompletableFuture<List<ImageFrame>> future = new CompletableFuture<List<ImageFrame>>();
        Scheduler.runTaskAsynchronously((Plugin)com.loohp.imageframe.ImageFrame.plugin, () -> {
            ArrayList<ThrowingSupplier<List>> tries = new ArrayList<ThrowingSupplier<List>>(3);
            tries.add(() -> GifReader.readGifMethodMadgag(new ByteArrayInputStream(targetArray)));
            tries.add(() -> GifReader.readGifMethodJavaX(new ByteArrayInputStream(targetArray)));
            tries.add(() -> GifReader.readGifMethodFallback(new ByteArrayInputStream(targetArray)));
            Throwable firstThrowable = null;
            for (ThrowingSupplier throwingSupplier : tries) {
                try {
                    future.complete((List)throwingSupplier.get());
                    return;
                }
                catch (Throwable e) {
                    if (firstThrowable != null) continue;
                    firstThrowable = e;
                }
            }
            future.completeExceptionally(firstThrowable);
        });
        return future;
    }

    private static List<ImageFrame> readGifMethodMadgag(InputStream stream) throws IOException {
        GifDecoder reader = new GifDecoder();
        if (reader.read(stream) == 0) {
            ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(reader.getFrameCount());
            for (int i = 0; i < reader.getFrameCount(); ++i) {
                BufferedImage image = reader.getFrame(i);
                int delay = reader.getDelay(i);
                frames.add(new ImageFrame(image, delay, ""));
            }
            return frames;
        }
        throw new IOException("Unable to read Gif");
    }

    private static List<ImageFrame> readGifMethodJavaX(InputStream input) throws IOException {
        IIOMetadataNode screenDescriptor;
        IIOMetadataNode globalRoot;
        NodeList globalScreenDescriptor;
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        reader.setInput(stream);
        LinkedList<ImageFrame> frames = new LinkedList<ImageFrame>();
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null && (globalScreenDescriptor = (globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("LogicalScreenDescriptor")) != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            int delay = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
                }
            }
            masterGraphics.drawImage((Image)image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            frames.add(new ImageFrame(copy, delay, disposal));
            if (disposal.equals("restoreToPrevious")) {
                BufferedImage from = null;
                for (int i = frameIndex - 1; i >= 0; --i) {
                    if (((ImageFrame)frames.get(i)).getDisposal().equals("restoreToPrevious") && frameIndex != 0) continue;
                    from = ((ImageFrame)frames.get(i)).getImage();
                    break;
                }
                master = new BufferedImage(from.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else if (disposal.equals("restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
        reader.dispose();
        return frames;
    }

    private static List<ImageFrame> readGifMethodFallback(InputStream input) throws IOException {
        return Collections.singletonList(new ImageFrame(ImageIO.read(input)));
    }

    public static int getFrameAt(Collection<ImageFrame> frames, int ms) {
        int current = 0;
        int i = 0;
        for (ImageFrame frame : frames) {
            if ((current += frame.getDelay()) >= ms) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class ImageFrame {
        private final int delay;
        private final BufferedImage image;
        private final String disposal;

        public ImageFrame(BufferedImage image, int delay, String disposal) {
            this.image = image;
            this.delay = delay;
            this.disposal = disposal;
        }

        public ImageFrame(BufferedImage image, int delay) {
            this(image, delay, "");
        }

        public ImageFrame(BufferedImage image) {
            this(image, 0, "");
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getDelay() {
            return this.delay;
        }

        public String getDisposal() {
            return this.disposal;
        }
    }
}

