/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.migration;

import com.loohp.imageframe.migration.DrMapMigration;
import com.loohp.imageframe.migration.ExternalPluginMigration;
import com.loohp.imageframe.migration.ImageMapMigration;
import com.loohp.imageframe.migration.ImageOnMapMigration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PluginMigrationRegistry {
    private static final Map<String, ExternalPluginMigration> REGISTERED_MIGRATIONS = new ConcurrentHashMap<String, ExternalPluginMigration>();

    public static Set<String> getPluginNames() {
        return REGISTERED_MIGRATIONS.keySet();
    }

    public static ExternalPluginMigration getMigration(String plugin) {
        ExternalPluginMigration migration = REGISTERED_MIGRATIONS.get(plugin);
        if (migration != null) {
            return migration;
        }
        return REGISTERED_MIGRATIONS.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(plugin)).findFirst().map(e -> (ExternalPluginMigration)e.getValue()).orElse(null);
    }

    public static void register(ExternalPluginMigration migration) {
        REGISTERED_MIGRATIONS.put(migration.externalPluginName(), migration);
    }

    static {
        PluginMigrationRegistry.register(new DrMapMigration());
        PluginMigrationRegistry.register(new ImageOnMapMigration());
        PluginMigrationRegistry.register(new ImageMapMigration());
    }
}

