/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.nms.NMS;
import com.loohp.imageframe.objectholders.CombinedMapItemInfo;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ItemFrameSelectionManager;
import com.loohp.imageframe.utils.ItemFrameUtils;
import com.loohp.imageframe.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class CombinedMapItemHandler
implements Listener,
AutoCloseable {
    private final Set<Player> entityInteractionChecking = new HashSet<Player>();
    private final Set<Player> entityDamageChecking = new HashSet<Player>();

    public CombinedMapItemHandler() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
    }

    public ItemStack getCombinedMap(ImageMap imageMap) {
        ItemStack itemStack = new ItemStack(Material.PAPER);
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(ImageFrame.combinedMapItemNameFormat.replace("{ImageID}", imageMap.getImageIndex() + "").replace("{Name}", imageMap.getName()).replace("{Width}", imageMap.getWidth() + "").replace("{Height}", imageMap.getHeight() + "").replace("{DitheringType}", imageMap.getDitheringType().getName()).replace("{CreatorName}", imageMap.getCreatorName()).replace("{CreatorUUID}", imageMap.getCreator().toString()).replace("{TimeCreated}", ImageFrame.dateFormat.format(new Date(imageMap.getCreationTime()))));
        meta.setLore(ImageFrame.combinedMapItemLoreFormat.stream().map(each -> each.replace("{ImageID}", imageMap.getImageIndex() + "").replace("{Name}", imageMap.getName()).replace("{Width}", imageMap.getWidth() + "").replace("{Height}", imageMap.getHeight() + "").replace("{DitheringType}", imageMap.getDitheringType().getName()).replace("{CreatorName}", imageMap.getCreatorName()).replace("{CreatorUUID}", imageMap.getCreator().toString()).replace("{TimeCreated}", ImageFrame.dateFormat.format(new Date(imageMap.getCreationTime())))).collect(Collectors.toList()));
        itemStack.setItemMeta(meta);
        return NMS.getInstance().withCombinedMapItemInfo(itemStack, new CombinedMapItemInfo(imageMap.getImageIndex()));
    }

    public void giveCombinedMap(ImageMap imageMap, Player player) {
        this.giveCombinedMap(imageMap, Collections.singleton(player));
    }

    public void giveCombinedMap(ImageMap imageMap, Collection<? extends Player> players) {
        ItemStack map = this.getCombinedMap(imageMap);
        for (Player player : players) {
            PlayerUtils.giveItem(player, map.clone());
        }
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }

    public ItemFrameSelectionManager.SelectedItemFrameResult findItemFrames(ItemFrame itemFrame, float yaw, int width, int height, Predicate<ItemStack> itemCheck) {
        Vector left;
        Vector up;
        BlockFace facing = itemFrame.getFacing();
        if (ItemFrameUtils.isOnWalls(itemFrame)) {
            up = new Vector(0, 1, 0);
            left = facing.getDirection().rotateAroundY(Math.toRadians(-90.0));
        } else if (ItemFrameUtils.isOnCeiling(itemFrame)) {
            up = ItemFrameUtils.getClosestCardinalDirection(yaw + 180.0f);
            left = up.clone().rotateAroundY(Math.toRadians(-90.0));
        } else {
            up = ItemFrameUtils.getClosestCardinalDirection(yaw);
            left = up.clone().rotateAroundY(Math.toRadians(90.0));
        }
        List<Location> checkingLocations = this.getCheckingLocations(itemFrame.getLocation(), up, left, width, height);
        block0: for (Location location : checkingLocations) {
            List<ItemFrame> selectedFrames;
            ItemFrameSelectionManager.SelectedItemFrameResult result;
            ItemFrame opposite;
            itemFrame = this.getItemFrame(location, facing);
            if (itemFrame == null || (opposite = this.getOppositeItemFrameCorner(itemFrame, up, left, width, height)) == null || (result = ImageFrame.itemFrameSelectionManager.getSelectedItemFrames(yaw, itemFrame, opposite)) == null || (selectedFrames = result.getItemFrames()).size() != width * height) continue;
            for (ItemFrame frame : selectedFrames) {
                ItemStack item = frame.getItem();
                if (itemCheck.test(item)) continue;
                continue block0;
            }
            return result;
        }
        return null;
    }

    public ItemFrame getOppositeItemFrameCorner(ItemFrame itemFrame, Vector up, Vector left, int width, int height) {
        Location location = itemFrame.getLocation().add(left.clone().multiply(-(width - 1))).add(up.clone().multiply(-(height - 1)));
        BoundingBox boundingBox = BoundingBox.of((Block)location.getBlock(), (Block)location.getBlock());
        Collection entities = location.getWorld().getNearbyEntities(boundingBox, e -> e instanceof ItemFrame);
        for (Entity entity : entities) {
            if (!itemFrame.getFacing().equals((Object)entity.getFacing())) continue;
            return (ItemFrame)entity;
        }
        return null;
    }

    public ItemFrame getItemFrame(Location location, BlockFace facing) {
        BoundingBox boundingBox = BoundingBox.of((Block)location.getBlock(), (Block)location.getBlock());
        Collection entities = location.getWorld().getNearbyEntities(boundingBox, e -> e instanceof ItemFrame);
        for (Entity entity : entities) {
            if (!facing.equals((Object)entity.getFacing())) continue;
            return (ItemFrame)entity;
        }
        return null;
    }

    public List<Location> getCheckingLocations(Location origin, Vector up, Vector left, int width, int height) {
        ArrayList<Location> locations = new ArrayList<Location>(width * height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                locations.add(origin.clone().add(up.clone().multiply(y)).add(left.clone().multiply(x)));
            }
        }
        locations.sort(Comparator.comparing(each -> each.distanceSquared(origin)));
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (!this.entityInteractionChecking.add(player)) {
            return;
        }
        try {
            EquipmentSlot slot = event.getHand();
            ItemStack itemStack = player.getEquipment().getItem(slot);
            if (itemStack == null || !itemStack.getType().equals((Object)Material.PAPER)) {
                return;
            }
            CombinedMapItemInfo mapItemInfo = NMS.getInstance().getCombinedMapItemInfo(itemStack);
            if (mapItemInfo == null) {
                return;
            }
            Entity entity = event.getRightClicked();
            if (!(entity instanceof ItemFrame)) {
                event.setCancelled(true);
                return;
            }
            ItemFrame itemFrame = (ItemFrame)entity;
            int id = mapItemInfo.getImageMapIndex();
            ImageMap imageMap = ImageFrame.imageMapManager.getFromImageId(id);
            if (imageMap == null) {
                player.sendMessage(ImageFrame.messageInvalidImageMap);
                event.setCancelled(true);
                return;
            }
            float yaw = player.getLocation().getYaw();
            ItemFrameSelectionManager.SelectedItemFrameResult selection = this.findItemFrames(itemFrame, yaw, imageMap.getWidth(), imageMap.getHeight(), item -> item == null || item.getType().equals((Object)Material.AIR));
            if (selection == null) {
                event.setCancelled(true);
                player.sendMessage(ImageFrame.messageNotEnoughSpace);
                return;
            }
            List<ItemFrame> selectedFrames = selection.getItemFrames();
            for (ItemFrame frame2 : selectedFrames) {
                ItemStack item2 = frame2.getItem();
                if ((item2 == null || item2.getType().equals((Object)Material.AIR)) && PlayerUtils.isInteractionAllowed(player, (Entity)frame2)) continue;
                event.setCancelled(true);
                player.sendMessage(ImageFrame.messageItemFrameOccupied);
                return;
            }
            UUID uuid = UUID.randomUUID();
            imageMap.fillItemFrames(selectedFrames, selection.getRotation(), (frame, item) -> true, (frame, item) -> {}, ImageFrame.mapItemFormat, item -> {
                CombinedMapItemInfo newInfo = new CombinedMapItemInfo(imageMap.getImageIndex(), new CombinedMapItemInfo.PlacementInfo(yaw, uuid));
                return NMS.getInstance().withCombinedMapItemInfo((ItemStack)item, newInfo);
            });
        }
        finally {
            this.entityInteractionChecking.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamageHanging(EntityDamageEvent event) {
        EntityDamageByEntityEvent entityDamageByEntityEvent;
        Entity damager;
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        Player player = null;
        if (event instanceof EntityDamageByEntityEvent && (damager = (entityDamageByEntityEvent = (EntityDamageByEntityEvent)event).getDamager()) instanceof Player) {
            player = (Player)damager;
        }
        this.handleItemFrameBreak(player, itemFrame);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRemoveHanging(HangingBreakEvent event) {
        Hanging entity = event.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        this.handleItemFrameBreak(null, itemFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleItemFrameBreak(Player player, ItemFrame itemFrame) {
        if (player != null && !this.entityDamageChecking.add(player)) {
            return;
        }
        try {
            ItemStack itemStack = itemFrame.getItem();
            if (itemStack == null || !itemStack.getType().equals((Object)Material.FILLED_MAP)) {
                return;
            }
            CombinedMapItemInfo mapItemInfo = NMS.getInstance().getCombinedMapItemInfo(itemStack);
            if (mapItemInfo == null || !mapItemInfo.hasPlacement()) {
                return;
            }
            CombinedMapItemInfo.PlacementInfo placement = mapItemInfo.getPlacement();
            int id = mapItemInfo.getImageMapIndex();
            float yaw = placement.getYaw();
            UUID uuid = placement.getUniqueId();
            ImageMap imageMap = ImageFrame.imageMapManager.getFromImageId(id);
            if (imageMap == null) {
                return;
            }
            ItemFrameSelectionManager.SelectedItemFrameResult selection = this.findItemFrames(itemFrame, yaw, imageMap.getWidth(), imageMap.getHeight(), item -> {
                if (item == null || !item.getType().equals((Object)Material.FILLED_MAP)) {
                    return false;
                }
                CombinedMapItemInfo info = NMS.getInstance().getCombinedMapItemInfo((ItemStack)item);
                if (info == null || !info.hasPlacement()) {
                    return false;
                }
                return info.getImageMapIndex() == id && info.getPlacement().getUniqueId().equals(uuid);
            });
            if (selection == null) {
                return;
            }
            List<ItemFrame> itemFrames = selection.getItemFrames();
            if (player == null || itemFrames.stream().allMatch(each -> PlayerUtils.isDamageAllowed(player, (Entity)each))) {
                itemFrames.forEach(each -> each.setItem(null, false));
                itemFrame.setItem(this.getCombinedMap(imageMap), false);
            } else {
                player.sendMessage(ImageFrame.messageItemFrameOccupied);
            }
        }
        finally {
            this.entityDamageChecking.remove(player);
        }
    }
}

