/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.objectholders.ImageMapCreationTaskManager;
import com.loohp.imageframe.utils.ThrowingSupplier;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ImageMapCreationTask<T>
extends CompletableFuture<T>
implements Runnable {
    private final ImageMapCreationTaskManager manager;
    private final UUID creationTaskId;
    private final UUID creator;
    private final ThrowingSupplier<T> creationTask;
    private final ScheduledTask monitorTask;
    private final String queuingMessageTemplate;
    private final String processingMessageTemplate;
    private final AtomicBoolean queuing;
    private final AtomicInteger tick;
    private final AtomicInteger processingStart;
    private final Future<?> submission;

    public ImageMapCreationTask(ImageMapCreationTaskManager manager, UUID creator, ThrowingSupplier<T> creationTask, ExecutorService executor, String imageMapName, int imageMapWidth, int imageMapHeight) {
        this.manager = manager;
        this.creationTaskId = UUID.randomUUID();
        this.creator = creator;
        this.creationTask = creationTask;
        this.manager.getTaskInQueue().add(this);
        this.queuingMessageTemplate = ImageFrame.messageImageMapQueuedActionBar.replace("{Name}", imageMapName).replace("{Width}", imageMapWidth + "").replace("{Height}", imageMapHeight + "");
        this.processingMessageTemplate = ImageFrame.messageImageMapProcessingActionBar.replace("{Name}", imageMapName).replace("{Width}", imageMapWidth + "").replace("{Height}", imageMapHeight + "");
        this.monitorTask = Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, new MonitorTask(), 0L, 10L);
        this.tick = new AtomicInteger(0);
        this.processingStart = new AtomicInteger(-1);
        this.queuing = new AtomicBoolean(true);
        this.submission = executor.submit(this);
    }

    public ImageMapCreationTaskManager getManager() {
        return this.manager;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public UUID getCreationTaskId() {
        return this.creationTaskId;
    }

    public boolean isQueuing() {
        return this.queuing.get();
    }

    public int getPositionInQueue() {
        return this.manager.getPositionInQueue(this);
    }

    @Override
    public void run() {
        this.manager.getTaskInQueue().remove(this);
        this.queuing.set(false);
        try {
            this.complete(this.creationTask.get());
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public boolean isCompleted() {
        return this.monitorTask.isCancelled();
    }

    public void complete(String message) {
        if (!this.isCompleted()) {
            this.monitorTask.cancel();
            this.manager.getCreatorsInQueue().remove(this.creator);
            Player player = Bukkit.getPlayer((UUID)this.creator);
            if (player != null) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            }
        }
    }

    private class MonitorTask
    implements Runnable {
        private MonitorTask() {
        }

        @Override
        public void run() {
            ImageMapCreationTask.this.processingStart.updateAndGet(currentProcessingStart -> {
                int currentTick = ImageMapCreationTask.this.tick.get();
                if (currentProcessingStart < 0) {
                    if (!ImageMapCreationTask.this.queuing.get()) {
                        return currentTick;
                    }
                } else if (currentTick - currentProcessingStart > ImageFrame.maxProcessingTime * 20) {
                    ImageMapCreationTask.this.submission.cancel(true);
                }
                return currentProcessingStart;
            });
            Player player = Bukkit.getPlayer((UUID)ImageMapCreationTask.this.creator);
            if (player != null) {
                String message;
                if (ImageMapCreationTask.this.queuing.get()) {
                    int position = ImageMapCreationTask.this.getPositionInQueue() + 1;
                    message = ImageMapCreationTask.this.queuingMessageTemplate.replace("{Position}", String.valueOf(position));
                } else {
                    int dots = ImageMapCreationTask.this.tick.getAndIncrement() % 4;
                    StringBuilder dotString = new StringBuilder();
                    for (int i = 0; i < dots; ++i) {
                        dotString.append(".");
                    }
                    message = ImageMapCreationTask.this.processingMessageTemplate.replace("{Dots}", dotString.toString());
                }
                if (!message.isEmpty()) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                }
            }
        }
    }
}

