/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.upload;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.org.apache.commons.fileupload.MultipartStream;
import com.loohp.imageframe.upload.PendingUpload;
import com.loohp.imageframe.utils.FileUtils;
import com.loohp.imageframe.utils.JarUtils;
import com.loohp.imageframe.utils.SizeLimitedByteArrayOutputStream;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.plugin.Plugin;

public class ImageUploadManager
implements AutoCloseable {
    public static final Duration EXPIRATION = Duration.ofMinutes(5L);
    private final HttpServer server;
    private final File webRootDir;
    private final File uploadDir;
    private final Map<UUID, PendingUpload> pendingUploads;
    private final AtomicLong imagesUploadedCounter;

    public ImageUploadManager(boolean enabled, String host, int port) {
        try {
            this.webRootDir = new File(ImageFrame.plugin.getDataFolder(), "upload/web");
            this.uploadDir = new File(ImageFrame.plugin.getDataFolder(), "upload/images");
            FileUtils.removeFolderRecursively(this.uploadDir);
            if (!this.uploadDir.exists()) {
                this.uploadDir.mkdirs();
            }
            if (!this.webRootDir.exists()) {
                this.webRootDir.mkdirs();
            }
            JarUtils.copyFolderFromJar("upload/web", ImageFrame.plugin.getDataFolder(), JarUtils.CopyOption.COPY_IF_NOT_EXIST);
            Cache cache = CacheBuilder.newBuilder().expireAfterAccess(EXPIRATION).removalListener(notification -> {
                PendingUpload pendingUpload;
                if (notification.wasEvicted() && (pendingUpload = (PendingUpload)notification.getValue()) != null) {
                    pendingUpload.getFuture().completeExceptionally(new LinkTimeoutException());
                }
            }).build();
            this.pendingUploads = cache.asMap();
            this.imagesUploadedCounter = new AtomicLong(0L);
            if (enabled) {
                System.setProperty("sun.net.httpserver.maxReqTime", "30");
                System.setProperty("sun.net.httpserver.maxRspTime", "30");
                this.server = HttpServer.create(new InetSocketAddress(host, port), 8);
                this.server.createContext("/", new FileHandler());
                this.server.createContext("/upload", new UploadHandler());
                this.server.setExecutor(Executors.newFixedThreadPool(8));
                this.server.start();
            } else {
                this.server = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PendingUpload newPendingUpload(UUID user) {
        PendingUpload existing = this.pendingUploads.remove(user);
        if (existing != null) {
            existing.getFuture().completeExceptionally(new LinkTimeoutException());
        }
        PendingUpload pendingUpload = PendingUpload.create();
        this.pendingUploads.put(user, pendingUpload);
        return pendingUpload;
    }

    public AtomicLong getImagesUploadedCounter() {
        return this.imagesUploadedCounter;
    }

    public boolean wasUploaded(String url) {
        try {
            File file = Paths.get(new URL(url).toURI()).toFile();
            return this.uploadDir.equals(file.getParentFile());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEnabled() {
        return this.server != null;
    }

    @Override
    public void close() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private class FileHandler
    implements HttpHandler {
        private FileHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                File file;
                if (!exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
                if (!ImageUploadManager.this.webRootDir.exists()) {
                    ImageUploadManager.this.webRootDir.mkdirs();
                }
                byte[] bytes = (file = this.resolvePath(ImageUploadManager.this.webRootDir.toPath().toAbsolutePath(), Paths.get("." + exchange.getRequestURI().getPath(), new String[0])).toFile()).exists() ? (file.isDirectory() ? Files.readAllBytes(new File(file, "index.html").toPath()) : Files.readAllBytes(file.toPath())) : Files.readAllBytes(new File(ImageUploadManager.this.webRootDir, "index.html").toPath());
                exchange.getResponseHeaders().set("Content-Type", "text/html");
                exchange.sendResponseHeaders(200, bytes.length);
                exchange.getResponseBody().write(bytes);
                exchange.getResponseBody().close();
            }
            finally {
                exchange.close();
            }
        }

        private Path resolvePath(Path baseDirPath, Path userPath) {
            Path resolvedPath = baseDirPath.resolve(userPath).normalize();
            if (!resolvedPath.startsWith(baseDirPath)) {
                return baseDirPath;
            }
            return resolvedPath;
        }
    }

    private class UploadHandler
    implements HttpHandler {
        private UploadHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                String id;
                if (!exchange.getRequestMethod().equalsIgnoreCase("POST")) {
                    exchange.sendResponseHeaders(405, -1L);
                    return;
                }
                String query = exchange.getRequestURI().getQuery();
                Map<String, String> queryParams = this.parseQueryParams(query);
                String user = queryParams.get("user");
                PendingUpload pendingUpload = this.findPendingUpload(user, id = queryParams.get("id"));
                if (pendingUpload == null) {
                    this.sendResponse(exchange, 400, "{\"error\":\"Invalid or missing user or id\"}");
                    return;
                }
                List<String> contentType = Arrays.asList(exchange.getRequestHeaders().getFirst("Content-Type").split(";"));
                if (!contentType.get(0).trim().equals("multipart/form-data")) {
                    this.sendResponse(exchange, 400, "{\"error\":\"Invalid content type\"}");
                    return;
                }
                byte[] boundary = contentType.stream().map(s -> s.trim()).filter(s -> s.startsWith("boundary=")).findFirst().map(s -> s.substring("boundary=".length()).getBytes(StandardCharsets.UTF_8)).orElse(null);
                if (boundary == null) {
                    this.sendResponse(exchange, 400, "{\"error\":\"Invalid multipart boundary\"}");
                    return;
                }
                SizeLimitedByteArrayOutputStream output = new SizeLimitedByteArrayOutputStream(ImageFrame.maxImageFileSize);
                try (InputStream inputStream = exchange.getRequestBody();){
                    MultipartStream multipartStream = new MultipartStream(inputStream, boundary, 2048, null);
                    boolean nextPart = multipartStream.skipPreamble();
                    while (nextPart) {
                        List<String> headers = Arrays.asList(multipartStream.readHeaders().split(";"));
                        String name = headers.stream().map(s -> s.trim()).filter(s -> s.startsWith("name=")).findFirst().map(s -> s.substring("name=".length())).orElse(null);
                        if ("image".equals(name) || "\"image\"".equals(name)) {
                            multipartStream.readBodyData(output);
                            break;
                        }
                        multipartStream.discardBodyData();
                        nextPart = multipartStream.readBoundary();
                    }
                }
                byte[] fileData = output.toByteArray();
                if (!ImageUploadManager.this.uploadDir.exists()) {
                    ImageUploadManager.this.uploadDir.mkdir();
                }
                File outputFile = new File(ImageUploadManager.this.uploadDir, id + ".png");
                Files.write(outputFile.toPath(), fileData, new OpenOption[0]);
                ImageUploadManager.this.imagesUploadedCounter.incrementAndGet();
                ImageUploadManager.this.pendingUploads.remove(UUID.fromString(user));
                pendingUpload.getFuture().complete(outputFile);
                Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> outputFile.delete(), EXPIRATION.toMillis() / 50L);
                this.sendResponse(exchange, 200, "{\"message\":\"File uploaded successfully\"}");
            }
            finally {
                exchange.close();
            }
        }

        private Map<String, String> parseQueryParams(String query) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    String[] keyValue = pair.split("=");
                    if (keyValue.length != 2) continue;
                    map.put(keyValue[0], keyValue[1]);
                }
            }
            return map;
        }

        private PendingUpload findPendingUpload(String user, String id) {
            try {
                PendingUpload pendingUpload = (PendingUpload)ImageUploadManager.this.pendingUploads.get(UUID.fromString(user));
                if (!pendingUpload.getId().equals(UUID.fromString(id))) {
                    return null;
                }
                return pendingUpload;
            }
            catch (Exception e) {
                return null;
            }
        }

        private void sendResponse(HttpExchange exchange, int statusCode, String message) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(statusCode, message.length());
            exchange.getResponseBody().write(message.getBytes());
            exchange.getResponseBody().close();
        }
    }

    public static class LinkTimeoutException
    extends Exception {
        public LinkTimeoutException() {
        }

        public LinkTimeoutException(String message) {
            super(message);
        }

        public LinkTimeoutException(String message, Throwable cause) {
            super(message, cause);
        }

        public LinkTimeoutException(Throwable cause) {
            super(cause);
        }
    }
}

