/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.HDMapPreRespondEvent;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class CustomClientNetworkManager
implements PluginMessageListener,
Listener {
    public static final String CLIENTBOUND_ACKNOWLEDGEMENT = "imageframe:clientbound_ack";
    public static final String SERVERBOUND_ACKNOWLEDGEMENT = "imageframe:serverbound_ack";
    public static final String SERVERBOUND_HD_IMAGE_REQUEST = "imageframe:serverbound_hd_image";
    public static final String CLIENTBOUND_HD_IMAGE_RESPONSE = "imageframe:clientbound_hd_image";
    public static final String CLIENTBOUND_HD_IMAGE_MULTIPART_RESPONSE = "imageframe:clientbound_hd_image_multi";
    public static final String CLIENTBOUND_HD_UPDATE_SIGNAL = "imageframe:clientbound_update";
    public static final String SERVERBOUND_IMAGEMAP_DETAILS_REQUEST = "imageframe:serverbound_imagemap_details";
    public static final String CLIENTBOUND_IMAGEMAP_DETAILS_RESPONSE = "imageframe:clientbound_imagemap_details";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final Map<UUID, Long> acknowledgements = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> acknowledged = ConcurrentHashMap.newKeySet();

    public CustomClientNetworkManager(boolean enabled) {
        if (!enabled) {
            return;
        }
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)ImageFrame.plugin, CLIENTBOUND_ACKNOWLEDGEMENT);
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)ImageFrame.plugin, SERVERBOUND_ACKNOWLEDGEMENT, (PluginMessageListener)this);
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)ImageFrame.plugin, SERVERBOUND_HD_IMAGE_REQUEST, (PluginMessageListener)this);
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)ImageFrame.plugin, CLIENTBOUND_HD_IMAGE_RESPONSE);
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)ImageFrame.plugin, CLIENTBOUND_HD_IMAGE_MULTIPART_RESPONSE);
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)ImageFrame.plugin, CLIENTBOUND_HD_UPDATE_SIGNAL);
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)ImageFrame.plugin, SERVERBOUND_IMAGEMAP_DETAILS_REQUEST, (PluginMessageListener)this);
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)ImageFrame.plugin, CLIENTBOUND_IMAGEMAP_DETAILS_RESPONSE);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
    }

    public Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(this.acknowledged);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        long id = ThreadLocalRandom.current().nextLong();
        this.acknowledgements.put(player.getUniqueId(), id);
        Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> {
            if (player.isOnline()) {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeLong(id);
                player.sendPluginMessage((Plugin)ImageFrame.plugin, CLIENTBOUND_ACKNOWLEDGEMENT, out.toByteArray());
            }
        }, 40L);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.acknowledgements.remove(uuid);
        this.acknowledged.remove(uuid);
    }

    @EventHandler
    public void onUpdate(ImageMapUpdatedEvent event) {
        ImageMap imageMap = event.getImageMap();
        this.notifyHdMapUpdated(this.acknowledged, Collections.singletonList(imageMap), imageMap.getMapIds());
    }

    public void notifyHdMapUpdated(Collection<UUID> players, Collection<ImageMap> imageMaps, Collection<Integer> mapIds) {
        CustomClientNetworkManager.handle(() -> {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            CustomClientNetworkManager.writeVarInt(out, imageMaps.size());
            for (ImageMap imageMap : imageMaps) {
                out.writeInt(imageMap.getImageIndex());
            }
            CustomClientNetworkManager.writeVarInt(out, mapIds.size());
            Iterator iterator = mapIds.iterator();
            while (iterator.hasNext()) {
                int mapId = (Integer)iterator.next();
                out.writeInt(mapId);
            }
            return out.toByteArray();
        }, () -> true, out -> {
            for (UUID uuid : players) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) continue;
                player.sendPluginMessage((Plugin)ImageFrame.plugin, CLIENTBOUND_HD_UPDATE_SIGNAL, out);
            }
        });
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        try {
            switch (channel) {
                case "imageframe:serverbound_ack": {
                    ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
                    long id = in.readLong();
                    UUID uuid = player.getUniqueId();
                    if (this.acknowledgements.get(uuid) != id) break;
                    this.acknowledgements.remove(uuid);
                    this.acknowledged.add(uuid);
                    break;
                }
                case "imageframe:serverbound_hd_image": {
                    ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
                    int mapId = in.readInt();
                    ImageMap imageMap = ImageFrame.imageMapManager.getFromMapId(mapId);
                    CustomClientNetworkManager.handle(() -> {
                        ByteArrayDataOutput out;
                        ArrayList<byte[]> list;
                        block10: {
                            list = new ArrayList<byte[]>();
                            out = ByteStreams.newDataOutput();
                            out.writeInt(mapId);
                            try {
                                byte[] array;
                                MapView mapView = imageMap == null ? null : imageMap.getMapViewFromMapId(mapId);
                                boolean requestAccepted = imageMap == null || MapUtils.canViewMap(player, mapView).get() != false;
                                BufferedImage image = imageMap == null ? null : imageMap.getOriginalImage(mapId);
                                HDMapPreRespondEvent event = new HDMapPreRespondEvent(player, mapId, imageMap, mapView, requestAccepted, image);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                requestAccepted = event.isRequestAccepted();
                                image = event.getImage();
                                out.writeBoolean(requestAccepted);
                                if (image == null) {
                                    CustomClientNetworkManager.writeVarInt(out, 0);
                                    out.writeBoolean(false);
                                    break block10;
                                }
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                try {
                                    ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
                                    array = byteArrayOutputStream.toByteArray();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    array = EMPTY_BYTE_ARRAY;
                                }
                                if (array.length == 0) {
                                    CustomClientNetworkManager.writeVarInt(out, 0);
                                    out.writeBoolean(false);
                                } else {
                                    List<byte[]> chunked = CustomClientNetworkManager.chunked(array, 32000);
                                    CustomClientNetworkManager.writeVarInt(out, chunked.get(0).length);
                                    out.write(chunked.get(0));
                                    if (chunked.size() <= 1) {
                                        out.writeBoolean(false);
                                    } else {
                                        int multipartId = ThreadLocalRandom.current().nextInt();
                                        out.writeBoolean(true);
                                        out.writeInt(multipartId);
                                        for (int i = 1; i < chunked.size(); ++i) {
                                            ByteArrayDataOutput outMulti = ByteStreams.newDataOutput();
                                            outMulti.writeInt(mapId);
                                            outMulti.writeInt(multipartId);
                                            outMulti.writeInt(i);
                                            CustomClientNetworkManager.writeVarInt(outMulti, chunked.get(i).length);
                                            outMulti.write(chunked.get(i));
                                            outMulti.writeBoolean(i + 1 >= chunked.size());
                                            list.add(outMulti.toByteArray());
                                        }
                                    }
                                }
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                        list.add(0, out.toByteArray());
                        return list;
                    }, () -> player.isOnline(), out -> {
                        player.sendPluginMessage((Plugin)ImageFrame.plugin, CLIENTBOUND_HD_IMAGE_RESPONSE, (byte[])out.get(0));
                        for (int i = 1; i < out.size(); ++i) {
                            player.sendPluginMessage((Plugin)ImageFrame.plugin, CLIENTBOUND_HD_IMAGE_MULTIPART_RESPONSE, (byte[])out.get(i));
                        }
                    });
                    break;
                }
                case "imageframe:serverbound_imagemap_details": {
                    ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
                    int index = in.readInt();
                    ImageMap imageMap = ImageFrame.imageMapManager.getFromImageId(index);
                    CustomClientNetworkManager.handle(() -> {
                        ByteArrayDataOutput out = ByteStreams.newDataOutput();
                        out.writeInt(index);
                        if (imageMap == null) {
                            out.writeInt(0);
                            out.writeInt(0);
                            CustomClientNetworkManager.writeVarInt(out, 0);
                        } else {
                            out.writeInt(imageMap.getWidth());
                            out.writeInt(imageMap.getHeight());
                            CustomClientNetworkManager.writeVarInt(out, imageMap.getMapIds().size());
                            for (int mapId : imageMap.getMapIds()) {
                                out.writeInt(mapId);
                            }
                        }
                        return out.toByteArray();
                    }, () -> player.isOnline(), out -> {
                        player.sendPluginMessage((Plugin)ImageFrame.plugin, CLIENTBOUND_IMAGEMAP_DETAILS_RESPONSE, out);
                        if (imageMap != null) {
                            imageMap.send(player);
                        }
                    });
                    break;
                }
            }
        }
        catch (Throwable e) {
            new RuntimeException("Illegal payload received from " + player.getName() + " on channel " + channel, e).printStackTrace();
        }
    }

    private static void writeVarInt(ByteArrayDataOutput out, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            out.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        out.writeByte(i);
    }

    private static <T> void handle(Supplier<T> handleAsync, BooleanSupplier syncPredicate, Consumer<T> completeSync) {
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
            Object value = handleAsync.get();
            if (syncPredicate.getAsBoolean()) {
                Scheduler.runTask((Plugin)ImageFrame.plugin, () -> completeSync.accept(value));
            }
        });
    }

    private static List<byte[]> chunked(byte[] data, int chunkSize) {
        if (data.length <= chunkSize) {
            return Collections.singletonList(data);
        }
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int i = 0; i < data.length; i += chunkSize) {
            int end = Math.min(data.length, i + chunkSize);
            byte[] chunk = Arrays.copyOfRange(data, i, end);
            chunks.add(chunk);
        }
        return chunks;
    }
}

