/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.FileLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.URLStaticImageMap;
import com.loohp.imageframe.utils.FutureUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MinecraftURLOverlayImageMap
extends URLStaticImageMap {
    public static Future<? extends MinecraftURLOverlayImageMap> create(ImageMapManager manager, String name, String url, List<MapView> mapViews, int width, int height, DitheringType ditheringType, UUID creator) throws Exception {
        int mapsCount = width * height;
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapsCount);
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            MapView mapView = mapViews.get(i);
            mapIds.add(mapView.getId());
            for (MapRenderer mapRenderer : mapView.getRenderers()) {
                if (!mapRenderer.getClass().getName().equals(MinecraftURLOverlayImageMapRenderer.class.getName())) continue;
                mapView.removeRenderer(mapRenderer);
            }
            markers.add(new ConcurrentHashMap());
        }
        MinecraftURLOverlayImageMap map = new MinecraftURLOverlayImageMap(manager, -1, name, url, new FileLazyMappedBufferedImage[mapsCount], mapViews, mapIds, markers, width, height, ditheringType, creator, Collections.emptyMap(), System.currentTimeMillis());
        return FutureUtils.callAsyncMethod(() -> {
            FutureUtils.callSyncMethod(() -> {
                for (int i = 0; i < mapViews.size(); ++i) {
                    ((MapView)mapViews.get(i)).addRenderer((MapRenderer)new MinecraftURLOverlayImageMapRenderer(map, i));
                }
            }).get();
            map.update(false);
            return map;
        });
    }

    public static Future<? extends MinecraftURLOverlayImageMap> load(ImageMapManager manager, File folder, JsonObject json) throws Exception {
        Map<UUID, ImageMapAccessPermissionType> hasAccess;
        if (!json.get("type").getAsString().equals(MinecraftURLOverlayImageMap.class.getName())) {
            throw new IllegalArgumentException("invalid type");
        }
        int imageIndex = json.get("index").getAsInt();
        String name = json.has("name") ? json.get("name").getAsString() : "Unnamed";
        String url = json.get("url").getAsString();
        int width = json.get("width").getAsInt();
        int height = json.get("height").getAsInt();
        DitheringType ditheringType = DitheringType.fromName(json.has("ditheringType") ? json.get("ditheringType").getAsString() : null);
        long creationTime = json.get("creationTime").getAsLong();
        UUID creator = UUID.fromString(json.get("creator").getAsString());
        if (json.has("hasAccess")) {
            JsonObject accessJson = json.get("hasAccess").getAsJsonObject();
            hasAccess = new HashMap(accessJson.size());
            for (Map.Entry<String, JsonElement> entry : accessJson.entrySet()) {
                hasAccess.put(UUID.fromString(entry.getKey()), ImageMapAccessPermissionType.valueOf(entry.getValue().getAsString().toUpperCase()));
            }
        } else {
            hasAccess = Collections.emptyMap();
        }
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapDataJson.size());
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapDataJson.size());
        FileLazyMappedBufferedImage[] cachedImages = new FileLazyMappedBufferedImage[mapDataJson.size()];
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapDataJson.size());
        World world = (World)Bukkit.getWorlds().get(0);
        int i = 0;
        for (Object dataJson : mapDataJson) {
            JsonObject jsonObject = ((JsonElement)dataJson).getAsJsonObject();
            int mapId = jsonObject.get("mapid").getAsInt();
            mapIds.add(mapId);
            mapViewsFuture.add(MapUtils.getMapOrCreateMissing(world, mapId));
            cachedImages[i] = FileLazyMappedBufferedImage.fromFile(new File(folder, jsonObject.get("image").getAsString()));
            ConcurrentHashMap<String, MapCursor> mapCursors = new ConcurrentHashMap<String, MapCursor>();
            if (jsonObject.has("markers")) {
                JsonArray markerArray = jsonObject.get("markers").getAsJsonArray();
                for (JsonElement element : markerArray) {
                    JsonObject markerData = element.getAsJsonObject();
                    String markerName = markerData.get("name").getAsString();
                    byte x = markerData.get("x").getAsByte();
                    byte y = markerData.get("y").getAsByte();
                    MapCursor.Type type = MapCursor.Type.valueOf((String)markerData.get("type").getAsString().toUpperCase());
                    byte direction = markerData.get("direction").getAsByte();
                    boolean visible = markerData.get("visible").getAsBoolean();
                    JsonElement caption = markerData.get("caption");
                    mapCursors.put(markerName, new MapCursor(x, y, direction, type, visible, caption.isJsonNull() ? null : caption.getAsString()));
                }
            }
            markers.add(mapCursors);
            ++i;
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapViewsFuture.size());
        for (Future future : mapViewsFuture) {
            mapViews.add((MapView)future.get());
        }
        MinecraftURLOverlayImageMap map = new MinecraftURLOverlayImageMap(manager, imageIndex, name, url, cachedImages, mapViews, mapIds, markers, width, height, ditheringType, creator, hasAccess, creationTime);
        return FutureUtils.callSyncMethod(() -> {
            for (int u = 0; u < mapViews.size(); ++u) {
                MapView mapView = (MapView)mapViews.get(u);
                for (MapRenderer mapRenderer : mapView.getRenderers()) {
                    if (!mapRenderer.getClass().getName().equals(MinecraftURLOverlayImageMapRenderer.class.getName())) continue;
                    mapView.removeRenderer(mapRenderer);
                }
                mapView.addRenderer((MapRenderer)new MinecraftURLOverlayImageMapRenderer(map, u));
            }
            return map;
        });
    }

    protected MinecraftURLOverlayImageMap(ImageMapManager manager, int imageIndex, String name, String url, FileLazyMappedBufferedImage[] cachedImages, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime) {
        super(manager, imageIndex, name, url, cachedImages, mapViews, mapIds, mapMarkers, width, height, ditheringType, creator, hasAccess, creationTime);
    }

    @Override
    public BufferedImage getOriginalImage(int mapId) {
        return null;
    }

    @Override
    public ImageMap deepClone(String name, UUID creator) throws Exception {
        MinecraftURLOverlayImageMap imageMap = MinecraftURLOverlayImageMap.create(this.manager, name, this.url, this.mapViews, this.width, this.height, this.ditheringType, creator).get();
        List<Map<String, MapCursor>> newList = imageMap.getMapMarkers();
        int i = 0;
        for (Map<String, MapCursor> map : this.getMapMarkers()) {
            Map<String, MapCursor> newMap = newList.get(i++);
            for (Map.Entry<String, MapCursor> entry : map.entrySet()) {
                MapCursor mapCursor = entry.getValue();
                newMap.put(entry.getKey(), new MapCursor(mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), mapCursor.getType(), mapCursor.isVisible(), mapCursor.getCaption()));
            }
        }
        return imageMap;
    }

    @Override
    public boolean trackDeletedMaps() {
        return false;
    }

    @Override
    public void stop() {
        for (MapView mapView : this.mapViews) {
            for (MapRenderer mapRenderer : mapView.getRenderers()) {
                if (!mapRenderer.getClass().getName().equals(MinecraftURLOverlayImageMapRenderer.class.getName())) continue;
                mapView.removeRenderer(mapRenderer);
            }
        }
    }

    public static class MinecraftURLOverlayImageMapRenderer
    extends URLStaticImageMap.URLStaticImageMapRenderer {
        private final MinecraftURLOverlayImageMap parent;

        public MinecraftURLOverlayImageMapRenderer(MinecraftURLOverlayImageMap parent, int index) {
            super(parent, index);
            this.parent = parent;
        }

        @Override
        public void render(MapView mapView, MapCanvas canvas, Player player) {
            byte[] colors = this.parent.cachedColors != null && this.parent.cachedColors[this.index] != null ? this.parent.cachedColors[this.index] : (this.parent.cachedImages[this.index] != null ? MapUtils.toMapPaletteBytes(this.parent.cachedImages[this.index].get(), this.parent.ditheringType) : null);
            MutablePair<byte[], Collection<MapCursor>> renderData = new MutablePair<byte[], Collection<MapCursor>>(colors, this.parent.getMapMarkers().get(this.index).values());
            this.manager.callRenderEventListener(this.manager, this.imageMap, mapView, player, renderData);
            colors = renderData.getFirst();
            if (colors != null) {
                for (int i = 0; i < colors.length; ++i) {
                    byte color = colors[i];
                    if (color == 0) continue;
                    canvas.setPixel(i % 128, i / 128, color);
                }
            }
            canvas.setCursors(MapUtils.toMapCursorCollection(renderData.getSecond()));
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, Player player) {
            return MapUtils.bukkitRenderMap(mapView, player);
        }
    }
}

