/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.FileLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.URLImageMap;
import com.loohp.imageframe.utils.FutureUtils;
import com.loohp.imageframe.utils.HTTPRequestUtils;
import com.loohp.imageframe.utils.ImageUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLStaticImageMap
extends URLImageMap {
    protected final FileLazyMappedBufferedImage[] cachedImages;
    protected byte[][] cachedColors;

    public static Future<? extends URLStaticImageMap> create(ImageMapManager manager, String name, String url, int width, int height, DitheringType ditheringType, UUID creator) throws Exception {
        World world = MapUtils.getMainWorld();
        int mapsCount = width * height;
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapsCount);
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            mapViewsFuture.add(MapUtils.createMap(world));
            markers.add(new ConcurrentHashMap());
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapsCount);
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapsCount);
        for (Future future : mapViewsFuture) {
            try {
                MapView mapView = (MapView)future.get();
                Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                    for (MapRenderer renderer : mapView.getRenderers()) {
                        mapView.removeRenderer(renderer);
                    }
                });
                mapViews.add(mapView);
                mapIds.add(mapView.getId());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        URLStaticImageMap map = new URLStaticImageMap(manager, -1, name, url, new FileLazyMappedBufferedImage[mapsCount], mapViews, mapIds, markers, width, height, ditheringType, creator, Collections.emptyMap(), System.currentTimeMillis());
        return FutureUtils.callAsyncMethod(() -> {
            FutureUtils.callSyncMethod(() -> {
                for (int i = 0; i < mapViews.size(); ++i) {
                    ((MapView)mapViews.get(i)).addRenderer((MapRenderer)new URLStaticImageMapRenderer(map, i));
                }
            }).get();
            map.update(false);
            return map;
        });
    }

    public static Future<? extends URLStaticImageMap> load(ImageMapManager manager, File folder, JsonObject json) throws Exception {
        Map<UUID, ImageMapAccessPermissionType> hasAccess;
        if (!json.get("type").getAsString().equals(URLStaticImageMap.class.getName())) {
            throw new IllegalArgumentException("invalid type");
        }
        int imageIndex = json.get("index").getAsInt();
        String name = json.has("name") ? json.get("name").getAsString() : "Unnamed";
        String url = json.get("url").getAsString();
        int width = json.get("width").getAsInt();
        int height = json.get("height").getAsInt();
        DitheringType ditheringType = DitheringType.fromName(json.has("ditheringType") ? json.get("ditheringType").getAsString() : null);
        long creationTime = json.get("creationTime").getAsLong();
        UUID creator = UUID.fromString(json.get("creator").getAsString());
        if (json.has("hasAccess")) {
            JsonObject accessJson = json.get("hasAccess").getAsJsonObject();
            hasAccess = new HashMap(accessJson.size());
            for (Map.Entry<String, JsonElement> entry : accessJson.entrySet()) {
                hasAccess.put(UUID.fromString(entry.getKey()), ImageMapAccessPermissionType.valueOf(entry.getValue().getAsString().toUpperCase()));
            }
        } else {
            hasAccess = Collections.emptyMap();
        }
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapDataJson.size());
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapDataJson.size());
        FileLazyMappedBufferedImage[] cachedImages = new FileLazyMappedBufferedImage[mapDataJson.size()];
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapDataJson.size());
        World world = (World)Bukkit.getWorlds().get(0);
        int i = 0;
        for (Object dataJson : mapDataJson) {
            JsonObject jsonObject = ((JsonElement)dataJson).getAsJsonObject();
            int mapId = jsonObject.get("mapid").getAsInt();
            mapIds.add(mapId);
            mapViewsFuture.add(MapUtils.getMapOrCreateMissing(world, mapId));
            cachedImages[i] = FileLazyMappedBufferedImage.fromFile(new File(folder, jsonObject.get("image").getAsString()));
            ConcurrentHashMap<String, MapCursor> mapCursors = new ConcurrentHashMap<String, MapCursor>();
            if (jsonObject.has("markers")) {
                JsonArray markerArray = jsonObject.get("markers").getAsJsonArray();
                for (JsonElement element : markerArray) {
                    JsonObject markerData = element.getAsJsonObject();
                    String markerName = markerData.get("name").getAsString();
                    byte x = markerData.get("x").getAsByte();
                    byte y = markerData.get("y").getAsByte();
                    MapCursor.Type type = MapCursor.Type.valueOf((String)markerData.get("type").getAsString().toUpperCase());
                    byte direction = markerData.get("direction").getAsByte();
                    boolean visible = markerData.get("visible").getAsBoolean();
                    JsonElement caption = markerData.get("caption");
                    mapCursors.put(markerName, new MapCursor(x, y, direction, type, visible, caption.isJsonNull() ? null : caption.getAsString()));
                }
            }
            markers.add(mapCursors);
            ++i;
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapViewsFuture.size());
        for (Future future : mapViewsFuture) {
            mapViews.add((MapView)future.get());
        }
        URLStaticImageMap map = new URLStaticImageMap(manager, imageIndex, name, url, cachedImages, mapViews, mapIds, markers, width, height, ditheringType, creator, hasAccess, creationTime);
        return FutureUtils.callSyncMethod(() -> {
            for (int u = 0; u < mapViews.size(); ++u) {
                MapView mapView = (MapView)mapViews.get(u);
                for (MapRenderer renderer : mapView.getRenderers()) {
                    mapView.removeRenderer(renderer);
                }
                mapView.addRenderer((MapRenderer)new URLStaticImageMapRenderer(map, u));
            }
            return map;
        });
    }

    protected URLStaticImageMap(ImageMapManager manager, int imageIndex, String name, String url, FileLazyMappedBufferedImage[] cachedImages, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime) {
        super(manager, imageIndex, name, url, mapViews, mapIds, mapMarkers, width, height, ditheringType, creator, hasAccess, creationTime);
        this.cachedImages = cachedImages;
        this.cacheControlTask.loadCacheIfManual();
    }

    @Override
    public BufferedImage getOriginalImage(int mapId) {
        int index = this.mapIds.indexOf(mapId);
        if (index < 0 || index >= this.cachedImages.length) {
            return null;
        }
        return this.cachedImages[index].get();
    }

    @Override
    public void loadColorCache() {
        if (this.cachedImages == null) {
            return;
        }
        if (this.cachedImages[0] == null) {
            return;
        }
        byte[][] cachedColors = new byte[this.cachedImages.length][];
        BufferedImage combined = new BufferedImage(this.width * 128, this.height * 128, 2);
        Graphics2D g = combined.createGraphics();
        int index = 0;
        for (FileLazyMappedBufferedImage image : this.cachedImages) {
            g.drawImage((Image)ImageUtils.resizeImageFillWidth(image.get(), 128), index % this.width * 128, index / this.width * 128, null);
            ++index;
        }
        g.dispose();
        byte[] combinedData = MapUtils.toMapPaletteBytes(combined, this.ditheringType);
        for (int i = 0; i < index; ++i) {
            byte[] data = new byte[16384];
            for (int y = 0; y < 128; ++y) {
                int offset = (i / this.width * 128 + y) * (this.width * 128) + i % this.width * 128;
                System.arraycopy(combinedData, offset, data, y * 128, 128);
            }
            cachedColors[i] = data;
        }
        this.cachedColors = cachedColors;
    }

    @Override
    public boolean hasColorCached() {
        return this.cachedColors != null;
    }

    @Override
    public void unloadColorCache() {
        this.cachedColors = null;
    }

    @Override
    public ImageMap deepClone(String name, UUID creator) throws Exception {
        URLStaticImageMap imageMap = URLStaticImageMap.create(this.manager, name, this.url, this.width, this.height, this.ditheringType, creator).get();
        List<Map<String, MapCursor>> newList = imageMap.getMapMarkers();
        int i = 0;
        for (Map<String, MapCursor> map : this.getMapMarkers()) {
            Map<String, MapCursor> newMap = newList.get(i++);
            for (Map.Entry<String, MapCursor> entry : map.entrySet()) {
                MapCursor mapCursor = entry.getValue();
                newMap.put(entry.getKey(), new MapCursor(mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), mapCursor.getType(), mapCursor.isVisible(), mapCursor.getCaption()));
            }
        }
        return imageMap;
    }

    @Override
    public void update(boolean save) throws Exception {
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(HTTPRequestUtils.download(this.url, ImageFrame.maxImageFileSize)));
        if (image == null) {
            throw new RuntimeException("Unable to read or download image, does this url directly links to an image? (" + this.url + ")");
        }
        int hdMapWidth = image.getWidth() / this.width;
        image = MapUtils.resize(image, this.width, this.height, hdMapWidth);
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.cachedImages[i++] = FileLazyMappedBufferedImage.fromImage(MapUtils.getSubImage(image, x, y, hdMapWidth));
            }
        }
        this.reloadColorCache();
        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(this));
        this.send(this.getViewers());
        if (save) {
            this.save();
        }
    }

    @Override
    public void save() throws Exception {
        if (this.imageIndex < 0) {
            throw new IllegalStateException("ImageMap with index < 0 cannot be saved");
        }
        File folder = new File(this.manager.getDataFolder(), String.valueOf(this.imageIndex));
        folder.mkdirs();
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getClass().getName());
        json.addProperty("index", this.imageIndex);
        json.addProperty("name", this.name);
        json.addProperty("url", this.url);
        json.addProperty("width", this.width);
        json.addProperty("height", this.height);
        if (this.ditheringType != null) {
            json.addProperty("ditheringType", this.ditheringType.getName());
        }
        json.addProperty("creator", this.creator.toString());
        JsonObject accessJson = new JsonObject();
        for (Map.Entry<UUID, ImageMapAccessPermissionType> entry : this.accessControl.getPermissions().entrySet()) {
            accessJson.addProperty(entry.getKey().toString(), entry.getValue().name());
        }
        json.add("hasAccess", accessJson);
        json.addProperty("creationTime", this.creationTime);
        JsonArray mapDataJson = new JsonArray();
        for (int i = 0; i < this.mapViews.size(); ++i) {
            JsonObject dataJson = new JsonObject();
            dataJson.addProperty("mapid", (Number)this.mapIds.get(i));
            dataJson.addProperty("image", i + ".png");
            JsonArray markerArray = new JsonArray();
            for (Map.Entry entry : ((Map)this.mapMarkers.get(i)).entrySet()) {
                MapCursor marker = (MapCursor)entry.getValue();
                JsonObject markerData = new JsonObject();
                markerData.addProperty("name", (String)entry.getKey());
                markerData.addProperty("x", marker.getX());
                markerData.addProperty("y", marker.getY());
                markerData.addProperty("type", marker.getType().name());
                markerData.addProperty("direction", marker.getDirection());
                markerData.addProperty("visible", marker.isVisible());
                markerData.addProperty("caption", marker.getCaption());
                markerArray.add(markerData);
            }
            dataJson.add("markers", markerArray);
            mapDataJson.add(dataJson);
        }
        json.add("mapdata", mapDataJson);
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(new File(folder, "data.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            pw.println(GSON.toJson(json));
            pw.flush();
        }
        for (int i = 0; i < this.cachedImages.length; ++i) {
            this.cachedImages[i].setFile(new File(folder, i + ".png"));
        }
    }

    public static class URLStaticImageMapRenderer
    extends ImageMap.ImageMapRenderer {
        private final URLStaticImageMap parent;

        public URLStaticImageMapRenderer(URLStaticImageMap parent, int index) {
            super(parent.getManager(), parent, index);
            this.parent = parent;
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, Player player) {
            byte[] colors = this.parent.cachedColors != null && this.parent.cachedColors[this.index] != null ? this.parent.cachedColors[this.index] : (this.parent.cachedImages[this.index] != null ? MapUtils.toMapPaletteBytes(this.parent.cachedImages[this.index].get(), this.parent.ditheringType) : null);
            Collection<MapCursor> cursors = this.parent.getMapMarkers().get(this.index).values();
            return new MutablePair<byte[], Collection<MapCursor>>(colors, cursors);
        }
    }
}

