/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.media;

import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import java.io.IOException;
import java.util.List;

public class MediaLoadingException
extends IOException {
    private final List<MediaLoadingExceptionEntry> exceptions;

    public MediaLoadingException(String message, List<MediaLoadingExceptionEntry> exceptions) {
        super(message);
        this.exceptions = exceptions;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        System.err.println("Exceptions for each MediaLoader");
        for (MediaLoadingExceptionEntry entry : this.exceptions) {
            System.err.println("MediaLoader " + entry.getIdentifier().asString());
            entry.getException().printStackTrace();
        }
    }

    public static class MediaLoadingExceptionEntry {
        private final Key identifier;
        private final Exception exception;

        public MediaLoadingExceptionEntry(Key identifier, Exception exception) {
            this.identifier = identifier;
            this.exception = exception;
        }

        public Key getIdentifier() {
            return this.identifier;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

