/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.loohp.imageframe.objectholders.ImageMapCreationTask;
import com.loohp.imageframe.utils.ThrowingSupplier;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ImageMapCreationTaskManager {
    private final ThreadPoolExecutor executor;
    private final Set<UUID> creatorsInQueue;
    private final Queue<ImageMapCreationTask<?>> taskInQueue;

    public ImageMapCreationTaskManager(int parallelCount) {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("ImageFrame Image Map Creation Thread #%d").build();
        this.executor = new ThreadPoolExecutor(parallelCount, parallelCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        this.creatorsInQueue = ConcurrentHashMap.newKeySet();
        this.taskInQueue = new ConcurrentLinkedQueue();
    }

    public <T> ImageMapCreationTask<T> enqueue(UUID creator, String imageMapName, int imageMapWidth, int imageMapHeight, ThrowingSupplier<T> creationTask) throws EnqueueRejectedException {
        if (!this.creatorsInQueue.add(creator)) {
            throw new EnqueueRejectedException("Creator " + creator + " already in queue");
        }
        return new ImageMapCreationTask<T>(this, creator, creationTask, this.executor, imageMapName, imageMapWidth, imageMapHeight);
    }

    public boolean isCreatorInQueue(UUID creator) {
        return this.creatorsInQueue.contains(creator);
    }

    protected Set<UUID> getCreatorsInQueue() {
        return this.creatorsInQueue;
    }

    protected Queue<ImageMapCreationTask<?>> getTaskInQueue() {
        return this.taskInQueue;
    }

    public int getPositionInQueue(ImageMapCreationTask<?> creationTask) {
        int index = 0;
        for (ImageMapCreationTask imageMapCreationTask : this.taskInQueue) {
            if (creationTask.getCreationTaskId().equals(imageMapCreationTask.getCreationTaskId())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getPositionInQueue(UUID creator) {
        int index = 0;
        for (ImageMapCreationTask imageMapCreationTask : this.taskInQueue) {
            if (creator.equals(imageMapCreationTask.getCreator())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getQueueSize() {
        return this.executor.getQueue().size();
    }

    public static class EnqueueRejectedException
    extends Exception {
        public EnqueueRejectedException() {
        }

        public EnqueueRejectedException(String message) {
            super(message);
        }

        public EnqueueRejectedException(String message, Throwable cause) {
            super(message, cause);
        }

        public EnqueueRejectedException(Throwable cause) {
            super(cause);
        }
    }
}

