/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.FileLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMapCreateInfo;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMapLoader;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.URLStaticImageMap;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MinecraftURLOverlayImageMap
extends URLStaticImageMap {
    protected MinecraftURLOverlayImageMap(ImageMapManager manager, ImageMapLoader<?, ?> loader, int imageIndex, String name, String url, FileLazyMappedBufferedImage[] cachedImages, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime) {
        super(manager, loader, imageIndex, name, url, cachedImages, mapViews, mapIds, mapMarkers, width, height, ditheringType, creator, hasAccess, creationTime);
    }

    @Override
    public BufferedImage getOriginalImage(int mapId) {
        return null;
    }

    @Override
    public ImageMap deepClone(String name, UUID creator) throws Exception {
        MinecraftURLOverlayImageMap imageMap = ((MinecraftURLOverlayImageMapLoader)this.loader).create(new MinecraftURLOverlayImageMapCreateInfo(this.manager, name, this.url, this.mapViews, this.width, this.height, this.ditheringType, creator)).get();
        List<Map<String, MapCursor>> newList = imageMap.getMapMarkers();
        int i = 0;
        for (Map<String, MapCursor> map : this.getMapMarkers()) {
            Map<String, MapCursor> newMap = newList.get(i++);
            for (Map.Entry<String, MapCursor> entry : map.entrySet()) {
                MapCursor mapCursor = entry.getValue();
                newMap.put(entry.getKey(), new MapCursor(mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), mapCursor.getType(), mapCursor.isVisible(), mapCursor.getCaption()));
            }
        }
        return imageMap;
    }

    @Override
    public boolean trackDeletedMaps() {
        return false;
    }

    @Override
    public void stop() {
        for (MapView mapView : this.mapViews) {
            for (MapRenderer mapRenderer : mapView.getRenderers()) {
                if (!mapRenderer.getClass().getName().equals(MinecraftURLOverlayImageMapRenderer.class.getName())) continue;
                mapView.removeRenderer(mapRenderer);
            }
        }
    }

    public static class MinecraftURLOverlayImageMapRenderer
    extends URLStaticImageMap.URLStaticImageMapRenderer {
        private final MinecraftURLOverlayImageMap parent;

        public MinecraftURLOverlayImageMapRenderer(MinecraftURLOverlayImageMap parent, int index) {
            super(parent, index);
            this.parent = parent;
        }

        @Override
        public void render(MapView mapView, MapCanvas canvas, Player player) {
            byte[] colors = this.parent.cachedColors != null && this.parent.cachedColors[this.index] != null ? this.parent.cachedColors[this.index] : (this.parent.cachedImages[this.index] != null ? MapUtils.toMapPaletteBytes(this.parent.cachedImages[this.index].get(), this.parent.ditheringType) : null);
            MutablePair<byte[], Collection<MapCursor>> renderData = new MutablePair<byte[], Collection<MapCursor>>(colors, this.parent.getMapMarkers().get(this.index).values());
            this.manager.callRenderEventListener(this.manager, this.imageMap, mapView, player, renderData);
            colors = renderData.getFirst();
            if (colors != null) {
                for (int i = 0; i < colors.length; ++i) {
                    byte color = colors[i];
                    if (color == 0) continue;
                    canvas.setPixel(i % 128, i / 128, color);
                }
            }
            canvas.setCursors(MapUtils.toMapCursorCollection(renderData.getSecond()));
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, Player player) {
            return MapUtils.bukkitRenderMap(mapView, player);
        }
    }
}

