/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.FileLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.NonUpdatableImageMapCreateInfo;
import com.loohp.imageframe.objectholders.NonUpdatableStaticImageMapLoader;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class NonUpdatableStaticImageMap
extends ImageMap {
    protected final FileLazyMappedBufferedImage[] cachedImages;
    protected byte[][] cachedColors;

    protected NonUpdatableStaticImageMap(ImageMapManager manager, ImageMapLoader<?, ?> loader, int imageIndex, String name, FileLazyMappedBufferedImage[] cachedImages, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime) {
        super(manager, loader, imageIndex, name, mapViews, mapIds, mapMarkers, width, height, ditheringType, creator, hasAccess, creationTime);
        this.cachedImages = cachedImages;
        this.cacheControlTask.loadCacheIfManual();
    }

    @Override
    public void loadColorCache() {
        if (this.cachedImages == null) {
            return;
        }
        if (this.cachedImages[0] == null) {
            return;
        }
        byte[][] cachedColors = new byte[this.cachedImages.length][];
        BufferedImage combined = new BufferedImage(this.width * 128, this.height * 128, 2);
        Graphics2D g = combined.createGraphics();
        int index = 0;
        for (FileLazyMappedBufferedImage image : this.cachedImages) {
            g.drawImage((Image)image.get(), index % this.width * 128, index / this.width * 128, null);
            ++index;
        }
        g.dispose();
        byte[] combinedData = MapUtils.toMapPaletteBytes(combined, this.ditheringType);
        for (int i = 0; i < index; ++i) {
            byte[] data = new byte[16384];
            for (int y = 0; y < 128; ++y) {
                int offset = (i / this.width * 128 + y) * (this.width * 128) + i % this.width * 128;
                System.arraycopy(combinedData, offset, data, y * 128, 128);
            }
            cachedColors[i] = data;
        }
        this.cachedColors = cachedColors;
    }

    @Override
    public boolean hasColorCached() {
        return this.cachedColors != null;
    }

    @Override
    public void unloadColorCache() {
        this.cachedColors = null;
    }

    @Override
    public BufferedImage getOriginalImage(int mapId) {
        int index = this.mapIds.indexOf(mapId);
        if (index < 0 || index >= this.cachedImages.length) {
            return null;
        }
        return this.cachedImages[index].get();
    }

    @Override
    public ImageMap deepClone(String name, UUID creator) throws Exception {
        BufferedImage[] images = new BufferedImage[this.cachedImages.length];
        for (int i = 0; i < images.length; ++i) {
            BufferedImage image = this.cachedImages[i].get();
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = newImage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            images[i] = newImage;
        }
        NonUpdatableStaticImageMap imageMap = ((NonUpdatableStaticImageMapLoader)this.loader).create(new NonUpdatableImageMapCreateInfo(this.manager, name, images, this.width, this.height, this.ditheringType, creator)).get();
        List<Map<String, MapCursor>> newList = imageMap.getMapMarkers();
        int i = 0;
        for (Map<String, MapCursor> map : this.getMapMarkers()) {
            Map<String, MapCursor> newMap = newList.get(i++);
            for (Map.Entry<String, MapCursor> entry : map.entrySet()) {
                MapCursor mapCursor = entry.getValue();
                newMap.put(entry.getKey(), new MapCursor(mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), mapCursor.getType(), mapCursor.isVisible(), mapCursor.getCaption()));
            }
        }
        return imageMap;
    }

    @Override
    public void update(boolean save) throws Exception {
        this.reloadColorCache();
        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(this));
        this.send(this.getViewers());
        if (save) {
            this.save();
        }
    }

    @Override
    public void save() throws Exception {
        if (this.imageIndex < 0) {
            throw new IllegalStateException("ImageMap with index < 0 cannot be saved");
        }
        File folder = new File(this.manager.getDataFolder(), String.valueOf(this.imageIndex));
        folder.mkdirs();
        JsonObject json = new JsonObject();
        json.addProperty("type", this.loader.getIdentifier().asString());
        json.addProperty("index", this.imageIndex);
        json.addProperty("name", this.name);
        json.addProperty("width", this.width);
        json.addProperty("height", this.height);
        if (this.ditheringType != null) {
            json.addProperty("ditheringType", this.ditheringType.getName());
        }
        json.addProperty("creator", this.creator.toString());
        JsonObject accessJson = new JsonObject();
        for (Map.Entry<UUID, ImageMapAccessPermissionType> entry : this.accessControl.getPermissions().entrySet()) {
            accessJson.addProperty(entry.getKey().toString(), entry.getValue().name());
        }
        json.add("hasAccess", accessJson);
        json.addProperty("creationTime", this.creationTime);
        JsonArray mapDataJson = new JsonArray();
        for (int i = 0; i < this.mapViews.size(); ++i) {
            JsonObject dataJson = new JsonObject();
            dataJson.addProperty("mapid", (Number)this.mapIds.get(i));
            dataJson.addProperty("image", i + ".png");
            JsonArray markerArray = new JsonArray();
            for (Map.Entry entry : ((Map)this.mapMarkers.get(i)).entrySet()) {
                MapCursor marker = (MapCursor)entry.getValue();
                JsonObject markerData = new JsonObject();
                markerData.addProperty("name", (String)entry.getKey());
                markerData.addProperty("x", marker.getX());
                markerData.addProperty("y", marker.getY());
                markerData.addProperty("type", marker.getType().name());
                markerData.addProperty("direction", marker.getDirection());
                markerData.addProperty("visible", marker.isVisible());
                markerData.addProperty("caption", marker.getCaption());
                markerArray.add(markerData);
            }
            dataJson.add("markers", markerArray);
            mapDataJson.add(dataJson);
        }
        json.add("mapdata", mapDataJson);
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(new File(folder, "data.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            pw.println(GSON.toJson(json));
            pw.flush();
        }
        for (int i = 0; i < this.cachedImages.length; ++i) {
            this.cachedImages[i].setFile(new File(folder, i + ".png"));
        }
    }

    public static class NonUpdatableStaticImageMapRenderer
    extends ImageMap.ImageMapRenderer {
        private final NonUpdatableStaticImageMap parent;

        public NonUpdatableStaticImageMapRenderer(NonUpdatableStaticImageMap parent, int index) {
            super(parent.getManager(), parent, index);
            this.parent = parent;
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, Player player) {
            byte[] colors = this.parent.cachedColors != null && this.parent.cachedColors[this.index] != null ? this.parent.cachedColors[this.index] : (this.parent.cachedImages[this.index] != null ? MapUtils.toMapPaletteBytes(this.parent.cachedImages[this.index].get(), this.parent.ditheringType) : null);
            Collection<MapCursor> cursors = this.parent.getMapMarkers().get(this.index).values();
            return new MutablePair<byte[], Collection<MapCursor>>(colors, cursors);
        }
    }
}

