/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.placeholderapi;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.utils.ArrayUtils;
import com.loohp.imageframe.utils.ImageMapUtils;
import com.loohp.imageframe.utils.StringUtils;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class Placeholders
extends PlaceholderExpansion {
    public String getAuthor() {
        return String.join((CharSequence)", ", ImageFrame.plugin.getDescription().getAuthors());
    }

    public String getIdentifier() {
        return "imageframe";
    }

    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    public String getRequiredPlugin() {
        return ImageFrame.plugin.getName();
    }

    public String onRequest(OfflinePlayer offlineplayer, String identifier) {
        boolean nameQuoted;
        int firstUnderscore;
        if (identifier.startsWith("\"")) {
            int endQuote = identifier.indexOf("\"", 1);
            firstUnderscore = identifier.indexOf("_", Math.max(0, endQuote));
            nameQuoted = true;
        } else {
            firstUnderscore = identifier.indexOf("_");
            nameQuoted = false;
        }
        if (firstUnderscore >= 0) {
            String name = nameQuoted ? identifier.substring(1, firstUnderscore - 1) : identifier.substring(0, firstUnderscore);
            String secondPart = identifier.substring(firstUnderscore + 1);
            CommandSender sender = offlineplayer instanceof CommandSender ? (CommandSender)offlineplayer : null;
            ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, name);
            if (imageMap != null && imageMap.requiresAnimationService() && secondPart.startsWith("playback_")) {
                String playbackArg = secondPart.substring("playback_".length());
                if (playbackArg.startsWith("bar_")) {
                    int length;
                    String[] args = playbackArg.substring("bar_".length()).split("_");
                    try {
                        length = Integer.parseInt(args[0]);
                    }
                    catch (Exception e) {
                        length = 60;
                    }
                    String character = ArrayUtils.getOrElse(args, 1, "\u258e");
                    String colorCurrent = ArrayUtils.getOrElse(args, 2, "&c");
                    String colorRemaining = ArrayUtils.getOrElse(args, 3, "&7");
                    double position = (double)imageMap.getCurrentPositionInSequence() / (double)(imageMap.getSequenceLength() - 1);
                    int currentLength = (int)Math.floor((double)length * position);
                    int remainingLength = length - currentLength;
                    return colorCurrent + StringUtils.repeat(character, currentLength) + colorRemaining + StringUtils.repeat(character, remainingLength);
                }
                if (playbackArg.equals("current")) {
                    long time = (long)imageMap.getCurrentPositionInSequence() * 50L;
                    long hours = TimeUnit.MILLISECONDS.toHours(time);
                    long minutes = TimeUnit.MILLISECONDS.toMinutes(time) % 60L;
                    long seconds = TimeUnit.MILLISECONDS.toSeconds(time) % 60L;
                    long milliseconds = time % 1000L;
                    long total = (long)(imageMap.getSequenceLength() - 1) * 50L;
                    if (total >= 3600000L) {
                        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
                    }
                    if (total >= 10000L) {
                        return String.format("%02d:%02d", minutes, seconds);
                    }
                    return String.format("%01d.%03d", seconds, milliseconds);
                }
                if (playbackArg.equals("total")) {
                    long time = (long)(imageMap.getSequenceLength() - 1) * 50L;
                    long hours = TimeUnit.MILLISECONDS.toHours(time);
                    long minutes = TimeUnit.MILLISECONDS.toMinutes(time) % 60L;
                    long seconds = TimeUnit.MILLISECONDS.toSeconds(time) % 60L;
                    long milliseconds = time % 1000L;
                    if (time >= 3600000L) {
                        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
                    }
                    if (time >= 10000L) {
                        return String.format("%02d:%02d", minutes, seconds);
                    }
                    return String.format("%01d.%03d", seconds, milliseconds);
                }
                if (playbackArg.equals("pause")) {
                    return imageMap.isAnimationPaused() ? "\u23f8" : "\u23f5";
                }
            }
        }
        return null;
    }
}

