/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.updater;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.updater.Version;
import com.loohp.imageframe.utils.HTTPRequestUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;

public class Updater
implements Listener {
    public static final String PLUGIN_NAME = "ImageFrame";

    public static void sendUpdateMessage(CommandSender sender, String version, int spigotPluginId) {
        Updater.sendUpdateMessage(sender, version, spigotPluginId, false);
    }

    public static void sendUpdateMessage(CommandSender sender, String version, int spigotPluginId, boolean devbuild) {
        if (!version.equals("error")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (!devbuild) {
                    player.sendMessage(ChatColor.YELLOW + "[ImageFrame] A new version is available on SpigotMC: " + version);
                    TextComponent url = new TextComponent(ChatColor.GOLD + "https://www.spigotmc.org/resources/" + spigotPluginId);
                    url.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.AQUA + "Click me!").create()));
                    url.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/" + spigotPluginId));
                    player.spigot().sendMessage((BaseComponent)url);
                } else {
                    sender.sendMessage(ChatColor.GREEN + "[ImageFrame] You are running the latest release!");
                    TextComponent url = new TextComponent(ChatColor.YELLOW + "[ImageFrame] However, a new Development Build is available if you want to try that!");
                    url.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.AQUA + "Click me!").create()));
                    url.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://ci.loohpjames.com/job/ImageFrame"));
                    player.spigot().sendMessage((BaseComponent)url);
                }
            } else if (!devbuild) {
                sender.sendMessage(ChatColor.YELLOW + "[ImageFrame] A new version is available on SpigotMC: " + version);
                sender.sendMessage(ChatColor.GOLD + "Download: https://www.spigotmc.org/resources/" + spigotPluginId);
            } else {
                sender.sendMessage(ChatColor.GREEN + "[ImageFrame] You are running the latest release!");
                sender.sendMessage(ChatColor.YELLOW + "[ImageFrame] However, a new Development Build is available if you want to try that!");
            }
        }
    }

    public static UpdaterResponse checkUpdate() {
        try {
            String localPluginVersion = ImageFrame.plugin.getDescription().getVersion();
            JSONObject response = (JSONObject)HTTPRequestUtils.getJSONResponse("https://api.loohpjames.com/spigot/data").get((Object)PLUGIN_NAME);
            String spigotPluginVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"release");
            String devBuildVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"devbuild");
            int spigotPluginId = (int)((Long)((JSONObject)response.get((Object)"spigotmc")).get((Object)"pluginid")).longValue();
            int posOfThirdDot = localPluginVersion.indexOf(".", localPluginVersion.indexOf(".", localPluginVersion.indexOf(".") + 1) + 1);
            Version currentDevBuild = new Version(localPluginVersion);
            Version currentRelease = new Version(localPluginVersion.substring(0, posOfThirdDot >= 0 ? posOfThirdDot : localPluginVersion.length()));
            Version spigotmc = new Version(spigotPluginVersion);
            Version devBuild = new Version(devBuildVersion);
            if (currentRelease.compareTo(spigotmc) < 0) {
                return new UpdaterResponse(spigotPluginVersion, spigotPluginId, currentDevBuild.compareTo(devBuild) >= 0);
            }
            return new UpdaterResponse("latest", spigotPluginId, currentDevBuild.compareTo(devBuild) >= 0);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Failed to check against \"api.loohpjames.com\" for the latest version.. It could be an internet issue or \"api.loohpjames.com\" is down. If you want disable the update checker, you can disable in config.yml, but we still highly-recommend you to keep your plugin up to date!");
            return new UpdaterResponse("error", -1, false);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> {
            UpdaterResponse version;
            Player player;
            if (ImageFrame.updaterEnabled && (player = event.getPlayer()).hasPermission("imageframe.update") && !(version = Updater.checkUpdate()).getResult().equals("latest")) {
                Updater.sendUpdateMessage((CommandSender)player, version.getResult(), version.getSpigotPluginId());
            }
        }, 100L);
    }

    public static class UpdaterResponse {
        private final String result;
        private final int spigotPluginId;
        private final boolean devBuildIsLatest;

        public UpdaterResponse(String result, int spigotPluginId, boolean devBuildIsLatest) {
            this.result = result;
            this.spigotPluginId = spigotPluginId;
            this.devBuildIsLatest = devBuildIsLatest;
        }

        public String getResult() {
            return this.result;
        }

        public int getSpigotPluginId() {
            return this.spigotPluginId;
        }

        public boolean isDevBuildLatest() {
            return this.devBuildIsLatest;
        }
    }
}

