/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.objectholders.LazyBufferedImageSource;
import com.loohp.imageframe.objectholders.LazyMappedBufferedImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class StandardLazyMappedBufferedImage
implements LazyMappedBufferedImage {
    private LazyBufferedImageSource source;
    private BufferedImage strongReference;
    private WeakReference<BufferedImage> weakReference;

    public static StandardLazyMappedBufferedImage fromSource(LazyBufferedImageSource source) {
        return new StandardLazyMappedBufferedImage(source, null, null);
    }

    public static StandardLazyMappedBufferedImage fromImage(BufferedImage image) {
        return new StandardLazyMappedBufferedImage(null, image, null);
    }

    public static StandardLazyMappedBufferedImage fromImageToFile(LazyBufferedImageSource source, BufferedImage image) throws IOException {
        source.saveImage(image);
        return new StandardLazyMappedBufferedImage(source, null, new WeakReference<BufferedImage>(image));
    }

    private StandardLazyMappedBufferedImage(LazyBufferedImageSource source, BufferedImage strongReference, WeakReference<BufferedImage> weakReference) {
        if (source == null && strongReference == null) {
            throw new IllegalArgumentException("One of source and strongReference must not be null");
        }
        if (source != null && strongReference != null) {
            throw new IllegalArgumentException("Source and strongReference cannot both be not null");
        }
        this.source = source;
        this.strongReference = strongReference;
        this.weakReference = weakReference;
    }

    @Override
    public LazyBufferedImageSource getSource() {
        return this.source;
    }

    @Override
    public boolean canSetSource(LazyBufferedImageSource source) {
        if (this.source != null) {
            return this.source.equals(source);
        }
        return source != null;
    }

    @Override
    public synchronized void setSource(LazyBufferedImageSource source) {
        if (this.source != null) {
            if (this.source.equals(source)) {
                return;
            }
            throw new IllegalStateException("Cannot change source location");
        }
        if (source == null) {
            throw new IllegalArgumentException("Cannot set source to null");
        }
        try {
            source.saveImage(this.strongReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.source = source;
        this.weakReference = new WeakReference<BufferedImage>(this.strongReference);
        this.strongReference = null;
    }

    @Override
    public void saveCopy(LazyBufferedImageSource source) {
        try {
            source.saveImage(this.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized BufferedImage get() {
        BufferedImage image;
        if (this.strongReference != null) {
            return this.strongReference;
        }
        if (this.weakReference != null && (image = (BufferedImage)this.weakReference.get()) != null) {
            return image;
        }
        try {
            image = this.source.loadImage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.weakReference = new WeakReference<BufferedImage>(image);
        return image;
    }

    @Override
    public synchronized BufferedImage getIfLoaded() {
        if (this.strongReference != null) {
            return this.strongReference;
        }
        return (BufferedImage)this.weakReference.get();
    }
}

