/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.nms;

import com.google.common.collect.Collections2;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.nms.NMSWrapper;
import com.loohp.imageframe.objectholders.CombinedMapItemInfo;
import com.loohp.imageframe.objectholders.FilledMapItemInfo;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.utils.UUIDUtils;
import com.loohp.imageframe.utils.UnsafeAccessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_18_R2.map.RenderData;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_18_2
extends NMSWrapper {
    private final Field nmsEntityByteDataWatcherField;
    private final Field craftMapViewWorldMapField;
    private final Field[] nmsPacketPlayOutEntityMetadataFields;
    private final Field nmsItemFrameItemStackDataWatcherField;
    private final Field persistentIdCountsUsedAuxIdsField;

    public V1_18_2() {
        try {
            this.nmsEntityByteDataWatcherField = net.minecraft.world.entity.Entity.class.getDeclaredField("Z");
            this.craftMapViewWorldMapField = CraftMapView.class.getDeclaredField("worldMap");
            this.nmsPacketPlayOutEntityMetadataFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.nmsItemFrameItemStackDataWatcherField = EntityItemFrame.class.getDeclaredField("ao");
            this.persistentIdCountsUsedAuxIdsField = PersistentIdCounts.class.getDeclaredField("b");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public WorldMap getWorldMap(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewWorldMapField.setAccessible(true);
            return (WorldMap)this.craftMapViewWorldMapField.get(craftMapView);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setColors(MapView mapView, byte[] colors) {
        if (colors.length != 16384) {
            throw new IllegalArgumentException("colors array length must be 16384");
        }
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        nmsWorldMap.g = colors;
    }

    @Override
    public Collection<Player> getViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.o;
        return Collections2.transform(humansMap.keySet(), e -> (Player)e.getBukkitEntity());
    }

    @Override
    public boolean hasViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.o;
        return !humansMap.isEmpty();
    }

    public MapIcon toNMSMapIcon(MapCursor mapCursor) {
        MapIcon.Type mapIconType = this.toNMSMapIconType(mapCursor.getType());
        IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)mapCursor.getCaption());
        return new MapIcon(mapIconType, mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), iChat);
    }

    public MapIcon.Type toNMSMapIconType(MapCursor.Type type) {
        return MapIcon.Type.a((byte)type.getValue());
    }

    @Override
    public boolean isRenderOnFrame(MapCursor.Type type) {
        MapIcon.Type mapIconType = this.toNMSMapIconType(type);
        return mapIconType.b();
    }

    @Override
    public int getNextAvailableMapId(World world) {
        try {
            this.persistentIdCountsUsedAuxIdsField.setAccessible(true);
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.n().D().t().a(PersistentIdCounts::b, PersistentIdCounts::new, "idcounts");
            Object2IntMap usedAuxIds = (Object2IntMap)this.persistentIdCountsUsedAuxIdsField.get(persistentIdCounts);
            return usedAuxIds.getInt((Object)"map") + 1;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MapView getMapOrCreateMissing(World world, int id) {
        try {
            MapView mapView = Bukkit.getMap((int)id);
            if (mapView != null) {
                return mapView;
            }
            this.persistentIdCountsUsedAuxIdsField.setAccessible(true);
            Location spawnLocation = world.getSpawnLocation();
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            ResourceKey worldTypeKey = worldServer.aa();
            WorldMap worldMap = WorldMap.a((double)spawnLocation.getX(), (double)spawnLocation.getZ(), (byte)3, (boolean)false, (boolean)false, (ResourceKey)worldTypeKey);
            worldServer.a(ItemWorldMap.a((int)id), worldMap);
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.n().D().t().a(PersistentIdCounts::b, PersistentIdCounts::new, "idcounts");
            Object2IntMap usedAuxIds = (Object2IntMap)this.persistentIdCountsUsedAuxIdsField.get(persistentIdCounts);
            int freeAuxValue = usedAuxIds.getInt((Object)"map");
            if (freeAuxValue < id) {
                usedAuxIds.put((Object)"map", id);
                persistentIdCounts.b();
            }
            return Bukkit.getMap((int)id);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutablePair<byte[], List<MapCursor>> bukkitRenderMap(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        RenderData renderData = craftMapView.render(craftPlayer);
        return new MutablePair<byte[], List<MapCursor>>(renderData.buffer, renderData.cursors);
    }

    @Override
    public Set<Player> getEntityTrackers(Entity entity) {
        WorldServer worldServer = ((CraftWorld)entity.getWorld()).getHandle();
        ChunkProviderServer chunkProviderServer = worldServer.k();
        PlayerChunkMap playerChunkMap = chunkProviderServer.a;
        Int2ObjectMap entityTrackers = playerChunkMap.J;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)entityTrackers.get(entity.getEntityId());
        if (entityTracker == null) {
            return Collections.emptySet();
        }
        HashSet<Player> players = new HashSet<Player>();
        for (ServerPlayerConnection connection : entityTracker.f) {
            if (!(connection instanceof PlayerConnection)) continue;
            players.add((Player)((PlayerConnection)connection).getCraftPlayer());
        }
        return players;
    }

    public PacketPlayOutMap createMapPacket(int mapId, byte[] colors, Collection<MapCursor> cursors) {
        List mapIcons = cursors == null ? null : cursors.stream().map(this::toNMSMapIcon).collect(Collectors.toList());
        WorldMap.b b2 = colors == null ? null : new WorldMap.b(0, 0, 128, 128, colors);
        return new PacketPlayOutMap(mapId, 0, false, mapIcons, b2);
    }

    public PacketPlayOutEntityMetadata createItemFrameItemChangePacket(int entityId, ItemStack itemStack) {
        try {
            this.nmsItemFrameItemStackDataWatcherField.setAccessible(true);
            DataWatcherObject dataWatcherObject = (DataWatcherObject)this.nmsItemFrameItemStackDataWatcherField.get(null);
            List<DataWatcher.Item> dataWatchers = Collections.singletonList(new DataWatcher.Item(dataWatcherObject, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
            PacketPlayOutEntityMetadata packet = (PacketPlayOutEntityMetadata)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutEntityMetadata.class);
            this.nmsPacketPlayOutEntityMetadataFields[0].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[0].setInt(packet, entityId);
            this.nmsPacketPlayOutEntityMetadataFields[1].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[1].set(packet, dataWatchers);
            return packet;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object createEntityFlagsPacket(Entity entity, Boolean invisible, Boolean glowing) {
        try {
            int entityId = entity.getEntityId();
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            this.nmsEntityByteDataWatcherField.setAccessible(true);
            DataWatcher watcher = nmsEntity.ai();
            DataWatcherObject byteField = (DataWatcherObject)this.nmsEntityByteDataWatcherField.get(null);
            byte value = (Byte)watcher.a(byteField);
            if (invisible != null) {
                value = invisible != false ? (byte)(value | 0x20) : (byte)(value & 0xFFFFFFDF);
            }
            if (glowing != null) {
                value = glowing != false ? (byte)(value | 0x40) : (byte)(value & 0xFFFFFFBF);
            }
            List<DataWatcher.Item> dataWatchers = Collections.singletonList(new DataWatcher.Item(byteField, (Object)value));
            PacketPlayOutEntityMetadata packet = (PacketPlayOutEntityMetadata)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutEntityMetadata.class);
            this.nmsPacketPlayOutEntityMetadataFields[0].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[0].setInt(packet, entityId);
            this.nmsPacketPlayOutEntityMetadataFields[1].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[1].set(packet, dataWatchers);
            return packet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    @Override
    public CombinedMapItemInfo getCombinedMapItemInfo(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.t();
        if (tag == null || !tag.e("CombinedImageMap")) {
            return null;
        }
        int imageMapIndex = tag.h("CombinedImageMap");
        if (!tag.e("CombinedImageMapPlacementUUID") || !tag.e("CombinedImageMapPlacementYaw")) {
            return new CombinedMapItemInfo(imageMapIndex);
        }
        float yaw = tag.j("CombinedImageMapPlacementYaw");
        UUID uuid = UUIDUtils.fromIntArray(tag.n("CombinedImageMapPlacementUUID"));
        return new CombinedMapItemInfo(imageMapIndex, new CombinedMapItemInfo.PlacementInfo(yaw, uuid));
    }

    @Override
    public ItemStack withCombinedMapItemInfo(ItemStack itemStack, CombinedMapItemInfo combinedMapItemInfo) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.u();
        tag.a("CombinedImageMap", combinedMapItemInfo.getImageMapIndex());
        if (combinedMapItemInfo.hasPlacement()) {
            CombinedMapItemInfo.PlacementInfo placement = combinedMapItemInfo.getPlacement();
            tag.a("CombinedImageMapPlacementYaw", placement.getYaw());
            tag.a("CombinedImageMapPlacementUUID", UUIDUtils.toIntArray(placement.getUniqueId()));
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public FilledMapItemInfo getFilledMapItemInfo(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.t();
        if (tag == null || !tag.e("ImageMap")) {
            return null;
        }
        int imageMapIndex = tag.h("ImageMap");
        int mapPartIndex = tag.h("ImageMapPart");
        return new FilledMapItemInfo(imageMapIndex, mapPartIndex);
    }

    @Override
    public ItemStack withFilledMapItemInfo(ItemStack itemStack, FilledMapItemInfo filledMapItemInfo) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.u();
        tag.a("ImageMap", filledMapItemInfo.getImageMapIndex());
        tag.a("ImageMapPart", filledMapItemInfo.getMapPartIndex());
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack withInvisibleItemFrameMeta(ItemStack itemStack) {
        ArrayList<String> loreLines;
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return itemStack;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound displayTag = nmsItemStack.a("display");
        if (displayTag.d("Lore") == 9) {
            NBTTagList loreLineTagList = displayTag.c("Lore", 8);
            loreLines = new ArrayList(loreLineTagList.size());
            for (int i = 0; i < loreLineTagList.size(); ++i) {
                loreLines.add(loreLineTagList.j(i));
            }
        } else {
            loreLines = new ArrayList<String>(1);
        }
        TranslatableComponent translatableComponent = new TranslatableComponent("effect.minecraft.invisibility", new Object[0]);
        translatableComponent.setColor(ChatColor.GRAY);
        translatableComponent.setItalic(Boolean.valueOf(false));
        loreLines.add(0, ComponentSerializer.toString((BaseComponent)translatableComponent));
        NBTTagList loreLineTagList = new NBTTagList();
        for (int i = 0; i < loreLines.size(); ++i) {
            loreLineTagList.b(i, (NBTBase)NBTTagString.a((String)((String)loreLines.get(i))));
        }
        displayTag.a("Lore", (NBTBase)loreLineTagList);
        CraftItemStack modified = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
        ItemMeta itemMeta = modified.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.addEnchant(Enchantment.LUCK, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        modified.setItemMeta(itemMeta);
        return modified;
    }

    @Override
    public List<ItemStack> giveItems(Player player, List<ItemStack> itemStacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory inventory = nmsPlayer.fr();
        for (ItemStack itemStack : itemStacks) {
            net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            boolean added = inventory.e(nmsItemStack);
            if (added && nmsItemStack.b()) continue;
            leftovers.add(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
        }
        nmsPlayer.bU.d();
        return leftovers;
    }

    @Override
    public Key getWorldNamespacedKey(World world) {
        NamespacedKey key = world.getKey();
        return Key.key(key.getNamespace(), key.getKey());
    }
}

