/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.nms;

import com.google.common.collect.Collections2;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.nms.NMSWrapper;
import com.loohp.imageframe.objectholders.CombinedMapItemInfo;
import com.loohp.imageframe.objectholders.FilledMapItemInfo;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.utils.UUIDUtils;
import com.loohp.imageframe.utils.UnsafeAccessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_16_R1.ChunkProviderServer;
import net.minecraft.server.v1_16_R1.DataWatcher;
import net.minecraft.server.v1_16_R1.DataWatcherObject;
import net.minecraft.server.v1_16_R1.Entity;
import net.minecraft.server.v1_16_R1.EntityItemFrame;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.ItemWorldMap;
import net.minecraft.server.v1_16_R1.MapIcon;
import net.minecraft.server.v1_16_R1.MinecraftKey;
import net.minecraft.server.v1_16_R1.NBTBase;
import net.minecraft.server.v1_16_R1.NBTTagCompound;
import net.minecraft.server.v1_16_R1.NBTTagList;
import net.minecraft.server.v1_16_R1.NBTTagString;
import net.minecraft.server.v1_16_R1.Packet;
import net.minecraft.server.v1_16_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R1.PacketPlayOutMap;
import net.minecraft.server.v1_16_R1.PersistentIdCounts;
import net.minecraft.server.v1_16_R1.PlayerChunkMap;
import net.minecraft.server.v1_16_R1.PlayerInventory;
import net.minecraft.server.v1_16_R1.ResourceKey;
import net.minecraft.server.v1_16_R1.WorldMap;
import net.minecraft.server.v1_16_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.bukkit.craftbukkit.v1_16_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_16_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_16_R1.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class V1_16
extends NMSWrapper {
    private final Field nmsEntityByteDataWatcherField;
    private final Field craftMapViewWorldMapField;
    private final Field nmsMapIconTypeDisplayField;
    private final Field[] nmsPacketPlayOutEntityMetadataFields;
    private final Field nmsItemFrameItemStackDataWatcherField;
    private final Field persistentIdCountsUsedAuxIdsField;

    public V1_16() {
        try {
            this.nmsEntityByteDataWatcherField = Entity.class.getDeclaredField("T");
            this.craftMapViewWorldMapField = CraftMapView.class.getDeclaredField("worldMap");
            this.nmsMapIconTypeDisplayField = MapIcon.Type.class.getDeclaredField("C");
            this.nmsPacketPlayOutEntityMetadataFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.nmsItemFrameItemStackDataWatcherField = EntityItemFrame.class.getDeclaredField("ITEM");
            this.persistentIdCountsUsedAuxIdsField = PersistentIdCounts.class.getDeclaredField("a");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public WorldMap getWorldMap(MapView mapView) {
        try {
            CraftMapView craftMapView = (CraftMapView)mapView;
            this.craftMapViewWorldMapField.setAccessible(true);
            return (WorldMap)this.craftMapViewWorldMapField.get(craftMapView);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setColors(MapView mapView, byte[] colors) {
        if (colors.length != 16384) {
            throw new IllegalArgumentException("colors array length must be 16384");
        }
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        nmsWorldMap.colors = colors;
    }

    @Override
    public Collection<Player> getViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.humans;
        return Collections2.transform(humansMap.keySet(), e -> (Player)e.getBukkitEntity());
    }

    @Override
    public boolean hasViewers(MapView mapView) {
        WorldMap nmsWorldMap = this.getWorldMap(mapView);
        Map humansMap = nmsWorldMap.humans;
        return !humansMap.isEmpty();
    }

    public MapIcon toNMSMapIcon(MapCursor mapCursor) {
        MapIcon.Type mapIconType = this.toNMSMapIconType(mapCursor.getType());
        IChatBaseComponent iChat = CraftChatMessage.fromStringOrNull((String)mapCursor.getCaption());
        return new MapIcon(mapIconType, mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), iChat);
    }

    public MapIcon.Type toNMSMapIconType(MapCursor.Type type) {
        return MapIcon.Type.a((byte)type.getValue());
    }

    @Override
    public boolean isRenderOnFrame(MapCursor.Type type) {
        MapIcon.Type mapIconType = this.toNMSMapIconType(type);
        try {
            this.nmsMapIconTypeDisplayField.setAccessible(true);
            return this.nmsMapIconTypeDisplayField.getBoolean(mapIconType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNextAvailableMapId(World world) {
        try {
            this.persistentIdCountsUsedAuxIdsField.setAccessible(true);
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.getMinecraftServer().D().getWorldPersistentData().a(PersistentIdCounts::new, "idcounts");
            Object2IntMap usedAuxIds = (Object2IntMap)this.persistentIdCountsUsedAuxIdsField.get(persistentIdCounts);
            return usedAuxIds.getInt((Object)"map") + 1;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MapView getMapOrCreateMissing(World world, int id) {
        try {
            MapView mapView = Bukkit.getMap((int)id);
            if (mapView != null) {
                return mapView;
            }
            this.persistentIdCountsUsedAuxIdsField.setAccessible(true);
            Location spawnLocation = world.getSpawnLocation();
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            ResourceKey worldTypeKey = worldServer.getDimensionKey();
            String mapId = ItemWorldMap.a((int)id);
            WorldMap worldMap = new WorldMap(mapId);
            worldMap.a(spawnLocation.getBlockX(), spawnLocation.getBlockZ(), 3, false, false, worldTypeKey);
            worldServer.a(worldMap);
            PersistentIdCounts persistentIdCounts = (PersistentIdCounts)worldServer.getMinecraftServer().D().getWorldPersistentData().a(PersistentIdCounts::new, "idcounts");
            Object2IntMap usedAuxIds = (Object2IntMap)this.persistentIdCountsUsedAuxIdsField.get(persistentIdCounts);
            int freeAuxValue = usedAuxIds.getInt((Object)"map");
            if (freeAuxValue < id) {
                usedAuxIds.put((Object)"map", id);
                persistentIdCounts.b();
            }
            return Bukkit.getMap((int)id);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutablePair<byte[], List<MapCursor>> bukkitRenderMap(MapView mapView, Player player) {
        CraftMapView craftMapView = (CraftMapView)mapView;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        RenderData renderData = craftMapView.render(craftPlayer);
        return new MutablePair<byte[], List<MapCursor>>(renderData.buffer, renderData.cursors);
    }

    @Override
    public Set<Player> getEntityTrackers(org.bukkit.entity.Entity entity) {
        WorldServer worldServer = ((CraftWorld)entity.getWorld()).getHandle();
        ChunkProviderServer chunkProviderServer = worldServer.getChunkProvider();
        PlayerChunkMap playerChunkMap = chunkProviderServer.playerChunkMap;
        Int2ObjectMap entityTrackers = playerChunkMap.trackedEntities;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)entityTrackers.get(entity.getEntityId());
        if (entityTracker == null) {
            return Collections.emptySet();
        }
        HashSet<Player> players = new HashSet<Player>();
        for (EntityPlayer player : entityTracker.trackedPlayers) {
            players.add((Player)player.getBukkitEntity());
        }
        return players;
    }

    public PacketPlayOutMap createMapPacket(int mapId, byte[] colors, Collection<MapCursor> cursors) {
        int size;
        byte[] colors0;
        List mapIcons;
        List list = mapIcons = cursors == null ? Collections.emptyList() : cursors.stream().map(this::toNMSMapIcon).collect(Collectors.toList());
        if (colors == null) {
            colors0 = EMPTY_BYTE_ARRAY;
            size = 0;
        } else {
            colors0 = colors;
            size = 128;
        }
        return new PacketPlayOutMap(mapId, 0, false, false, mapIcons, colors0, 0, 0, size, size);
    }

    public PacketPlayOutEntityMetadata createItemFrameItemChangePacket(int entityId, ItemStack itemStack) {
        try {
            this.nmsItemFrameItemStackDataWatcherField.setAccessible(true);
            DataWatcherObject dataWatcherObject = (DataWatcherObject)this.nmsItemFrameItemStackDataWatcherField.get(null);
            List<DataWatcher.Item> dataWatchers = Collections.singletonList(new DataWatcher.Item(dataWatcherObject, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            this.nmsPacketPlayOutEntityMetadataFields[0].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[0].setInt(packet, entityId);
            this.nmsPacketPlayOutEntityMetadataFields[1].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[1].set(packet, dataWatchers);
            return packet;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object createEntityFlagsPacket(org.bukkit.entity.Entity entity, Boolean invisible, Boolean glowing) {
        try {
            int entityId = entity.getEntityId();
            Entity nmsEntity = ((CraftEntity)entity).getHandle();
            this.nmsEntityByteDataWatcherField.setAccessible(true);
            DataWatcher watcher = nmsEntity.getDataWatcher();
            DataWatcherObject byteField = (DataWatcherObject)this.nmsEntityByteDataWatcherField.get(null);
            byte value = (Byte)watcher.get(byteField);
            if (invisible != null) {
                value = invisible != false ? (byte)(value | 0x20) : (byte)(value & 0xFFFFFFDF);
            }
            if (glowing != null) {
                value = glowing != false ? (byte)(value | 0x40) : (byte)(value & 0xFFFFFFBF);
            }
            List<DataWatcher.Item> dataWatchers = Collections.singletonList(new DataWatcher.Item(byteField, (Object)value));
            PacketPlayOutEntityMetadata packet = (PacketPlayOutEntityMetadata)UnsafeAccessor.getUnsafe().allocateInstance(PacketPlayOutEntityMetadata.class);
            this.nmsPacketPlayOutEntityMetadataFields[0].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[0].setInt(packet, entityId);
            this.nmsPacketPlayOutEntityMetadataFields[1].setAccessible(true);
            this.nmsPacketPlayOutEntityMetadataFields[1].set(packet, dataWatchers);
            return packet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public CombinedMapItemInfo getCombinedMapItemInfo(ItemStack itemStack) {
        net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.getTag();
        if (tag == null || !tag.hasKey("CombinedImageMap")) {
            return null;
        }
        int imageMapIndex = tag.getInt("CombinedImageMap");
        if (!tag.hasKey("CombinedImageMapPlacementUUID") || !tag.hasKey("CombinedImageMapPlacementYaw")) {
            return new CombinedMapItemInfo(imageMapIndex);
        }
        float yaw = tag.getFloat("CombinedImageMapPlacementYaw");
        UUID uuid = UUIDUtils.fromIntArray(tag.getIntArray("CombinedImageMapPlacementUUID"));
        return new CombinedMapItemInfo(imageMapIndex, new CombinedMapItemInfo.PlacementInfo(yaw, uuid));
    }

    @Override
    public ItemStack withCombinedMapItemInfo(ItemStack itemStack, CombinedMapItemInfo combinedMapItemInfo) {
        net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.getOrCreateTag();
        tag.setInt("CombinedImageMap", combinedMapItemInfo.getImageMapIndex());
        if (combinedMapItemInfo.hasPlacement()) {
            CombinedMapItemInfo.PlacementInfo placement = combinedMapItemInfo.getPlacement();
            tag.setFloat("CombinedImageMapPlacementYaw", placement.getYaw());
            tag.setIntArray("CombinedImageMapPlacementUUID", UUIDUtils.toIntArray(placement.getUniqueId()));
        }
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_16_R1.ItemStack)nmsItemStack);
    }

    @Override
    public FilledMapItemInfo getFilledMapItemInfo(ItemStack itemStack) {
        net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.getTag();
        if (tag == null || !tag.hasKey("ImageMap")) {
            return null;
        }
        int imageMapIndex = tag.getInt("ImageMap");
        int mapPartIndex = tag.getInt("ImageMapPart");
        return new FilledMapItemInfo(imageMapIndex, mapPartIndex);
    }

    @Override
    public ItemStack withFilledMapItemInfo(ItemStack itemStack, FilledMapItemInfo filledMapItemInfo) {
        net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.getOrCreateTag();
        tag.setInt("ImageMap", filledMapItemInfo.getImageMapIndex());
        tag.setInt("ImageMapPart", filledMapItemInfo.getMapPartIndex());
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_16_R1.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack withInvisibleItemFrameMeta(ItemStack itemStack) {
        ArrayList<String> loreLines;
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return itemStack;
        }
        net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound displayTag = nmsItemStack.a("display");
        if (displayTag.d("Lore") == 9) {
            NBTTagList loreLineTagList = displayTag.getList("Lore", 8);
            loreLines = new ArrayList(loreLineTagList.size());
            for (int i = 0; i < loreLineTagList.size(); ++i) {
                loreLines.add(loreLineTagList.getString(i));
            }
        } else {
            loreLines = new ArrayList<String>(1);
        }
        TranslatableComponent translatableComponent = new TranslatableComponent("effect.minecraft.invisibility", new Object[0]);
        translatableComponent.setColor(ChatColor.GRAY);
        translatableComponent.setItalic(Boolean.valueOf(false));
        loreLines.add(0, ComponentSerializer.toString((BaseComponent)translatableComponent));
        NBTTagList loreLineTagList = new NBTTagList();
        for (int i = 0; i < loreLines.size(); ++i) {
            loreLineTagList.b(i, (NBTBase)NBTTagString.a((String)((String)loreLines.get(i))));
        }
        displayTag.set("Lore", (NBTBase)loreLineTagList);
        CraftItemStack modified = CraftItemStack.asCraftMirror((net.minecraft.server.v1_16_R1.ItemStack)nmsItemStack);
        ItemMeta itemMeta = modified.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.addEnchant(Enchantment.LUCK, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        modified.setItemMeta(itemMeta);
        return modified;
    }

    @Override
    public List<ItemStack> giveItems(Player player, List<ItemStack> itemStacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        PlayerInventory inventory = nmsPlayer.inventory;
        for (ItemStack itemStack : itemStacks) {
            net.minecraft.server.v1_16_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            boolean added = inventory.pickup(nmsItemStack);
            if (added && nmsItemStack.isEmpty()) continue;
            leftovers.add(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R1.ItemStack)nmsItemStack));
        }
        nmsPlayer.activeContainer.c();
        return leftovers;
    }

    @Override
    public Key getWorldNamespacedKey(World world) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        MinecraftKey key = nmsWorld.getTypeKey().a();
        return Key.key(key.getNamespace(), key.getKey());
    }
}

