/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.net.kyori.adventure.text.Component;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapRenderEventListener;
import com.loohp.imageframe.objectholders.IntPosition;
import com.loohp.imageframe.utils.CommandSenderUtils;
import com.loohp.imageframe.utils.ComponentUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class MapMarkerEditManager
implements Listener,
AutoCloseable {
    private final Map<Player, MapMarkerEditData> activeEditing = new ConcurrentHashMap<Player, MapMarkerEditData>();
    private final ImageMapRenderEventListener renderEventListener = (manager, imageMap, map, player, renderData) -> {
        Collection cursors = (Collection)renderData.getSecond();
        LinkedList<MapCursor> additionCursors = new LinkedList<MapCursor>();
        for (MapMarkerEditData data : this.activeEditing.values()) {
            MapView targetMap = data.getCurrentTargetMap();
            if (targetMap == null || !targetMap.equals((Object)map) || !data.getImageMap().equals(imageMap)) continue;
            additionCursors.add(data.getMapCursor());
        }
        if (!additionCursors.isEmpty()) {
            additionCursors.addAll(cursors);
            renderData.setSecond(additionCursors);
        }
    };
    private final ScheduledTask task;

    public MapMarkerEditManager() {
        ImageFrame.imageMapManager.appendRenderEventListener(this.renderEventListener);
        this.task = Scheduler.runTaskTimer((Plugin)ImageFrame.plugin, () -> this.editTask(), 0L, 1L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
    }

    @Override
    public void close() {
        ImageFrame.imageMapManager.removeRenderEventListener(this.renderEventListener);
        this.task.cancel();
        HandlerList.unregisterAll((Listener)this);
    }

    private void editTask() {
        for (Map.Entry<Player, MapMarkerEditData> entry : this.activeEditing.entrySet()) {
            MapMeta mapMeta;
            MapView mapView;
            ItemMeta itemMeta;
            ItemFrame itemFrame;
            Location location;
            RayTraceResult result;
            Player player = entry.getKey();
            if (!player.isOnline() || (result = MapUtils.rayTraceItemFrame(location = player.getEyeLocation(), location.getDirection(), 5.0)) == null || (itemFrame = (ItemFrame)result.getHitEntity()) == null) continue;
            Vector hitPosition = result.getHitPosition();
            ItemStack itemStack = itemFrame.getItem();
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || !itemStack.hasItemMeta() || !((itemMeta = itemStack.getItemMeta()) instanceof MapMeta) || (mapView = (mapMeta = (MapMeta)itemMeta).getMapView()) == null) continue;
            MapMarkerEditData editData = entry.getValue();
            ImageMap imageMap = editData.getImageMap();
            if (!imageMap.isValid()) {
                this.leaveActiveEditing(player);
                continue;
            }
            if (!imageMap.getMapViews().contains(mapView)) continue;
            IntPosition target = MapUtils.getTargetPixelOnItemFrame(itemFrame.getLocation().toVector(), itemFrame.getFacing().getDirection(), hitPosition, itemFrame.getRotation());
            editData.setCurrentTargetMap(mapView);
            editData.getMapCursor().setX((byte)target.getX());
            editData.getMapCursor().setY((byte)target.getY());
            Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> imageMap.send(imageMap.getViewers()));
        }
    }

    public void setActiveEditing(Player player, String name, MapCursor mapCursor, ImageMap imageMap) {
        this.activeEditing.put(player, new MapMarkerEditData(name, mapCursor, imageMap));
    }

    public boolean isActiveEditing(Player player) {
        return this.activeEditing.containsKey(player);
    }

    public MapMarkerEditData getActiveEditing(Player player) {
        return this.activeEditing.get(player);
    }

    public MapMarkerEditData leaveActiveEditing(Player player) {
        return this.activeEditing.remove(player);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.leaveActiveEditing(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        this.handlePlayerInteract(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            this.handlePlayerInteract(event);
        }
    }

    public <T extends PlayerEvent> void handlePlayerInteract(T event) {
        Player player = event.getPlayer();
        MapMarkerEditData editData = this.activeEditing.get(player);
        if (editData == null) {
            return;
        }
        Location location = player.getEyeLocation();
        RayTraceResult result = MapUtils.rayTraceItemFrame(location, location.getDirection(), 5.0);
        if (result == null) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)result.getHitEntity();
        if (itemFrame == null) {
            return;
        }
        ItemStack itemStack = itemFrame.getItem();
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!itemStack.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof MapMeta)) {
            return;
        }
        MapMeta mapMeta = (MapMeta)itemMeta;
        MapView mapView = mapMeta.getMapView();
        if (mapView == null) {
            return;
        }
        ImageMap imageMap = editData.getImageMap();
        if (!imageMap.getMapViews().contains(mapView)) {
            return;
        }
        ((Cancellable)event).setCancelled(true);
        this.activeEditing.remove(player);
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
            try {
                Map<String, MapCursor> markers = imageMap.getMapMarkers(mapView);
                if (!player.hasPermission("imageframe.marker.unlimited") && markers.size() >= ImageFrame.mapMarkerLimit) {
                    CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.markers.limit_reached", ImageFrame.mapMarkerLimit).color(NamedTextColor.RED));
                } else {
                    MapCursor mapCursor = editData.getMapCursor();
                    markers.put(editData.getName(), mapCursor);
                    Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(imageMap));
                    imageMap.send(imageMap.getViewers());
                    imageMap.save();
                    CommandSenderUtils.sendMessage((CommandSender)player, Component.translatable("imageframe.messages.markers.add_confirm").color(NamedTextColor.GREEN));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static class MapMarkerEditData {
        private final String name;
        private final MapCursor mapCursor;
        private final ImageMap imageMap;
        private MapView currentTargetMap;

        public MapMarkerEditData(String name, MapCursor mapCursor, ImageMap imageMap) {
            this.name = name;
            this.mapCursor = mapCursor;
            this.imageMap = imageMap;
        }

        public String getName() {
            return this.name;
        }

        public MapCursor getMapCursor() {
            return this.mapCursor;
        }

        public ImageMap getImageMap() {
            return this.imageMap;
        }

        public MapView getCurrentTargetMap() {
            return this.currentTargetMap;
        }

        protected void setCurrentTargetMap(MapView currentTargetMap) {
            this.currentTargetMap = currentTargetMap;
        }
    }
}

