/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.upload;

import com.loohp.imageframe.upload.ImageUploadManager;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bukkit.Bukkit;

public class PendingUpload {
    private final UUID id;
    private final long expire;
    private final CompletableFuture<File> future;

    public static PendingUpload create() {
        return new PendingUpload(UUID.randomUUID(), System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L), new CompletableFuture<File>());
    }

    private PendingUpload(UUID id, long expire, CompletableFuture<File> future) {
        this.id = id;
        this.expire = expire;
        this.future = future;
    }

    public UUID getId() {
        return this.id;
    }

    public long getExpire() {
        return this.expire;
    }

    protected CompletableFuture<File> getFuture() {
        return this.future;
    }

    public File getFileBlocking() throws InterruptedException, ImageUploadManager.LinkTimeoutException {
        try {
            return this.future.get(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new ImageUploadManager.LinkTimeoutException();
        }
    }

    public String getUrl(String domain, UUID user) {
        String name = Bukkit.getOfflinePlayer((UUID)user).getName();
        if (name == null) {
            return domain + "?user=" + user + "&id=" + this.id + "&expire=" + this.expire;
        }
        return domain + "?user=" + user + "&id=" + this.id + "&expire=" + this.expire + "&name=" + name;
    }
}

